/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.tasks;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TasksRegistry;
import org.apache.kafka.streams.processor.internals.tasks.DefaultTaskManager;
import org.apache.kafka.streams.processor.internals.tasks.TaskExecutor;
import org.apache.kafka.streams.processor.internals.tasks.TaskManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DefaultTaskManagerTest {
    private final Time time = new MockTime(1L);
    private final StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
    private final TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
    private final TaskExecutor taskExecutor = (TaskExecutor)Mockito.mock(TaskExecutor.class);
    private final StreamsConfig config = new StreamsConfig((Map)this.configProps());
    private final TaskManager taskManager = new DefaultTaskManager(this.time, "TaskManager", this.tasks, this.config, (taskManager, name, time) -> this.taskExecutor);

    private Properties configProps() {
        return Utils.mkObjectProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"appId"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"localhost:2171"), Utils.mkEntry((Object)"processing.guarantee", (Object)"exactly_once_v2")}));
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.task.id()).thenReturn((Object)new TaskId(0, 0, "A"));
        Mockito.when((Object)this.task.isProcessable(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.task.isActive()).thenReturn((Object)true);
    }

    @Test
    public void shouldAddTask() {
        this.taskManager.add(Collections.singleton(this.task));
        ((TasksRegistry)Mockito.verify((Object)this.tasks)).addTask((Task)this.task);
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Assertions.assertEquals((int)1, (int)this.taskManager.getTasks().size());
    }

    @Test
    public void shouldAssignTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldUnassignTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        this.taskManager.unassignTask(this.task, this.taskExecutor);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotUnassignNotOwnedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        TaskExecutor anotherExecutor = (TaskExecutor)Mockito.mock(TaskExecutor.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.unassignTask(this.task, anotherExecutor));
    }

    @Test
    public void shouldNotRemoveUnlockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.remove(this.task.id()));
    }

    @Test
    public void shouldNotRemoveAssignedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        this.taskManager.assignNextTask(this.taskExecutor);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.taskManager.remove(this.task.id()));
    }

    @Test
    public void shouldRemoveTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        this.taskManager.lockTasks(Collections.singleton(this.task.id()));
        this.taskManager.remove(this.task.id());
        ((TasksRegistry)Mockito.verify((Object)this.tasks)).removeTask((Task)this.task);
        Mockito.reset((Object[])new TasksRegistry[]{this.tasks});
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.emptySet());
        Assertions.assertEquals((int)0, (int)this.taskManager.getTasks().size());
    }

    @Test
    public void shouldNotAssignLockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.taskManager.lockTasks(Collections.singleton(this.task.id())).isDone());
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldNotAssignAnyLockedTask() {
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.taskManager.lockAllTasks().isDone());
        Assertions.assertNull((Object)this.taskManager.assignNextTask(this.taskExecutor));
    }

    @Test
    public void shouldUnassignLockingTask() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        this.taskManager.add(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.activeTasks()).thenReturn(Collections.singleton(this.task));
        Mockito.when((Object)this.tasks.task(this.task.id())).thenReturn((Object)this.task);
        Mockito.when((Object)this.tasks.contains(this.task.id())).thenReturn((Object)true);
        Mockito.when((Object)this.taskExecutor.unassign()).thenReturn((Object)future);
        Assertions.assertEquals((Object)this.task, (Object)this.taskManager.assignNextTask(this.taskExecutor));
        KafkaFuture lockFuture = this.taskManager.lockAllTasks();
        Assertions.assertFalse((boolean)lockFuture.isDone());
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).unassign();
        future.complete((Object)this.task);
        Assertions.assertTrue((boolean)lockFuture.isDone());
    }
}

