/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MergedSortedCacheWrappedWindowStoreKeyValueIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private static final int WINDOW_SIZE = 10;
    private final String storeKey = "a";
    private final String cacheKey = "b";
    private final TimeWindow storeWindow = new TimeWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair((Object)new Windowed((Object)Bytes.wrap((byte[])"a".getBytes()), (Window)this.storeWindow), (Object)"a".getBytes())).iterator();
    private final TimeWindow cacheWindow = new TimeWindow(10L, 20L);
    private Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs;
    private final Deserializer<String> deserializer = Serdes.String().deserializer();
    private StoreKeySerializer<String> storeKeySerializer;
    private MergedSortedCacheWindowStoreKeyValueIterator.StoreKeyToWindowKey storeKeyToWindowKey;
    private MergedSortedCacheWindowStoreKeyValueIterator.WindowKeyToBytes windowKeyToBytes;
    @Parameterized.Parameter
    public SchemaType schemaType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SchemaType.WINDOW_KEY_SCHEMA}, {SchemaType.KEY_FIRST_SCHEMA}, {SchemaType.TIME_FIRST_SCHEMA});
    }

    @Before
    public void setUp() {
        switch (this.schemaType) {
            case KEY_FIRST_SCHEMA: {
                this.storeKeySerializer = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            case WINDOW_KEY_SCHEMA: {
                this.storeKeySerializer = WindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = WindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = WindowKeySchema::toStoreKeyBinary;
                break;
            }
            case TIME_FIRST_SCHEMA: {
                this.storeKeySerializer = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown schemaType: " + (Object)((Object)this.schemaType));
            }
        }
        this.cacheKvs = Collections.singleton(KeyValue.pair((Object)SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize((Windowed<String>)new Windowed((Object)"b", (Window)this.cacheWindow), 0, new StateSerdes("dummy", Serdes.String(), Serdes.ByteArray()))), (Object)new LRUCacheEntry("b".getBytes()))).iterator();
    }

    @Test
    public void shouldHaveNextFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldHaveNextFromReverseStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
    }

    @Test
    public void shouldGetNextFromReverseStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
    }

    @Test
    public void shouldPeekNextKeyFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"a", (Window)this.storeWindow)));
    }

    @Test
    public void shouldPeekNextKeyFromReverseStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"a", (Window)this.storeWindow)));
    }

    @Test
    public void shouldHaveNextFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldHaveNextFromReverseCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
    }

    @Test
    public void shouldGetNextFromReverseCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
    }

    @Test
    public void shouldPeekNextKeyFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"b", (Window)this.cacheWindow)));
    }

    @Test
    public void shouldPeekNextKeyFromReverseCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"b", (Window)this.cacheWindow)));
    }

    @Test
    public void shouldIterateBothStoreAndCache() {
        MergedSortedCacheWindowStoreKeyValueIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldReverseIterateBothStoreAndCache() {
        MergedSortedCacheWindowStoreKeyValueIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private KeyValue<Windowed<String>, String> convertKeyValuePair(KeyValue<Windowed<Bytes>, byte[]> next) {
        String value = (String)this.deserializer.deserialize("", (byte[])next.value);
        return KeyValue.pair(this.convertWindowedKey((Windowed<Bytes>)((Windowed)next.key)), (Object)value);
    }

    private Windowed<String> convertWindowedKey(Windowed<Bytes> bytesWindowed) {
        String key = (String)this.deserializer.deserialize("", ((Bytes)bytesWindowed.key()).get());
        return new Windowed((Object)key, bytesWindowed.window());
    }

    private MergedSortedCacheWindowStoreKeyValueIterator createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs, boolean forward) {
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator cacheIterator = new DelegatingPeekingKeyValueIterator("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheWindowStoreKeyValueIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, new StateSerdes("name", Serdes.Bytes(), Serdes.ByteArray()), 10L, SINGLE_SEGMENT_CACHE_FUNCTION, forward, this.storeKeyToWindowKey, this.windowKeyToBytes);
    }

    private static enum SchemaType {
        WINDOW_KEY_SCHEMA,
        KEY_FIRST_SCHEMA,
        TIME_FIRST_SCHEMA;

    }

    @FunctionalInterface
    private static interface StoreKeySerializer<K> {
        public Bytes serialize(Windowed<K> var1, int var2, StateSerdes<K, ?> var3);
    }
}

