/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.tests.RelationalSmokeTest;
import org.apache.kafka.streams.tests.SmokeTestUtil;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class RelationalSmokeTestTest
extends SmokeTestUtil {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);

    @Test
    public void verifySmokeTestLogic() {
        try (TopologyTestDriver driver = new TopologyTestDriver(RelationalSmokeTest.App.getTopology(), RelationalSmokeTest.App.getConfig("nothing:0", "test", "test", "at_least_once", TestUtils.tempDirectory().getAbsolutePath()));){
            TestInputTopic articles = driver.createInputTopic("in-article", (Serializer)new IntegerSerializer(), (Serializer)new RelationalSmokeTest.Article.ArticleSerializer());
            TestInputTopic comments = driver.createInputTopic("in-comment", (Serializer)new IntegerSerializer(), (Serializer)new RelationalSmokeTest.Comment.CommentSerializer());
            TestOutputTopic augmentedArticles = driver.createOutputTopic("out-augmented-article", (Deserializer)new IntegerDeserializer(), (Deserializer)new RelationalSmokeTest.AugmentedArticle.AugmentedArticleDeserializer());
            TestOutputTopic augmentedComments = driver.createOutputTopic("out-augmented-comment", (Deserializer)new IntegerDeserializer(), (Deserializer)new RelationalSmokeTest.AugmentedComment.AugmentedCommentDeserializer());
            RelationalSmokeTest.DataSet dataSet = RelationalSmokeTest.DataSet.generate(10, 30);
            TreeMap<Integer, RelationalSmokeTest.Article> articleMap = new TreeMap<Integer, RelationalSmokeTest.Article>();
            for (RelationalSmokeTest.Article article : dataSet.getArticles()) {
                articles.pipeInput((Object)article.getKey(), (Object)article, article.getTimestamp());
                articleMap.put(article.getKey(), article);
            }
            TreeMap<Integer, Long> commentCounts = new TreeMap<Integer, Long>();
            TreeMap<Integer, RelationalSmokeTest.Comment> commentMap = new TreeMap<Integer, RelationalSmokeTest.Comment>();
            for (RelationalSmokeTest.Comment comment : dataSet.getComments()) {
                comments.pipeInput((Object)comment.getKey(), (Object)comment, comment.getTimestamp());
                commentMap.put(comment.getKey(), comment);
                commentCounts.put(comment.getArticleId(), commentCounts.getOrDefault(comment.getArticleId(), 0L) + 1L);
            }
            Map augmentedArticleResults = augmentedArticles.readKeyValuesToMap();
            Map augmentedCommentResults = augmentedComments.readKeyValuesToMap();
            MatcherAssert.assertThat((Object)augmentedArticleResults.size(), (Matcher)CoreMatchers.is((Object)dataSet.getArticles().length));
            MatcherAssert.assertThat((Object)augmentedCommentResults.size(), (Matcher)CoreMatchers.is((Object)dataSet.getComments().length));
            MatcherAssert.assertThat((Object)RelationalSmokeTest.App.verifySync(true, articleMap, commentMap, augmentedArticleResults, augmentedCommentResults), (Matcher)CoreMatchers.is((Object)true));
        }
    }
}

