/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.state.internals.AbstractRocksDBTimeOrderedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

public class RocksDBTimeOrderedKeyValueBytesStore
extends AbstractRocksDBTimeOrderedSegmentedBytesStore {
    private long minTimestamp = Long.MAX_VALUE;

    RocksDBTimeOrderedKeyValueBytesStore(String name, String metricsScope) {
        super(name, metricsScope, Long.MAX_VALUE, Long.MAX_VALUE, new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema(), Optional.empty());
    }

    @Override
    protected KeyValue<Bytes, byte[]> getIndexKeyValue(Bytes baseKey, byte[] baseValue) {
        throw new UnsupportedOperationException("Do not use for TimeOrderedKeyValueStore");
    }

    @Override
    Map<KeyValueSegment, WriteBatch> getWriteBatches(Collection<ConsumerRecord<byte[], byte[]>> records) {
        HashMap<KeyValueSegment, WriteBatch> writeBatchMap = new HashMap<KeyValueSegment, WriteBatch>();
        for (ConsumerRecord<byte[], byte[]> record : records) {
            long timestamp = WindowKeySchema.extractStoreTimestamp((byte[])record.key());
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            this.minTimestamp = Math.min(this.minTimestamp, timestamp);
            long segmentId = this.segments.segmentId(timestamp);
            KeyValueSegment segment = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(segmentId, this.context, this.observedStreamTime);
            if (segment == null) continue;
            ChangelogRecordDeserializationHelper.applyChecksAndUpdatePosition(record, this.consistencyEnabled, this.position);
            try {
                WriteBatch batch = writeBatchMap.computeIfAbsent(segment, s -> new WriteBatch());
                byte[] baseKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromNonPrefixWindowKey((byte[])record.key());
                segment.addToBatch(new KeyValue<byte[], Object>(baseKey, record.value()), batch);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error restoring batch to store " + this.name(), e);
            }
        }
        return writeBatchMap;
    }

    @Override
    protected AbstractRocksDBTimeOrderedSegmentedBytesStore.IndexToBaseStoreIterator getIndexToBaseStoreIterator(SegmentIterator<KeyValueSegment> segmentIterator) {
        throw new UnsupportedOperationException("Do not use for TimeOrderedKeyValueStore");
    }

    protected long minTimestamp() {
        return this.minTimestamp;
    }
}

