/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.RepartitionTopics;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class RepartitionTopicsTest {
    private static final String SOURCE_TOPIC_NAME1 = "source1";
    private static final String SOURCE_TOPIC_NAME2 = "source2";
    private static final String SOURCE_TOPIC_NAME3 = "source3";
    private static final String SINK_TOPIC_NAME1 = "sink1";
    private static final String SINK_TOPIC_NAME2 = "sink2";
    private static final String REPARTITION_TOPIC_NAME1 = "repartition1";
    private static final String REPARTITION_TOPIC_NAME2 = "repartition2";
    private static final String REPARTITION_TOPIC_NAME3 = "repartition3";
    private static final String REPARTITION_TOPIC_NAME4 = "repartition4";
    private static final String REPARTITION_WITHOUT_PARTITION_COUNT = "repartitionWithoutPartitionCount";
    private static final String SOME_OTHER_TOPIC = "someOtherTopic";
    private static final Map<String, String> TOPIC_CONFIG1 = Collections.singletonMap("config1", "val1");
    private static final Map<String, String> TOPIC_CONFIG2 = Collections.singletonMap("config2", "val2");
    private static final Map<String, String> TOPIC_CONFIG5 = Collections.singletonMap("config5", "val5");
    private static final RepartitionTopicConfig REPARTITION_TOPIC_CONFIG1 = new RepartitionTopicConfig("repartition1", TOPIC_CONFIG1, 4, true);
    private static final RepartitionTopicConfig REPARTITION_TOPIC_CONFIG2 = new RepartitionTopicConfig("repartition2", TOPIC_CONFIG2, 2, true);
    private static final InternalTopologyBuilder.TopicsInfo TOPICS_INFO1 = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{"repartition1"}), Utils.mkSet((Object[])new String[]{"source1", "source2"}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"repartition1", (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)"repartition2", (Object)REPARTITION_TOPIC_CONFIG2)}), Collections.emptyMap());
    private static final InternalTopologyBuilder.TopicsInfo TOPICS_INFO2 = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{"sink1"}), Utils.mkSet((Object[])new String[]{"repartition1"}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"repartition1", (Object)REPARTITION_TOPIC_CONFIG1)}), Collections.emptyMap());
    final StreamsConfig config = new DummyStreamsConfig();
    @Mock
    InternalTopologyBuilder internalTopologyBuilder;
    @Mock
    InternalTopicManager internalTopicManager;
    @Mock
    CopartitionedTopicsEnforcer copartitionedTopicsEnforcer;
    @Mock
    Cluster clusterMetadata;

    @Before
    public void setup() {
        Mockito.when((Object)this.internalTopologyBuilder.hasNamedTopology()).thenReturn((Object)false);
        Mockito.when((Object)this.internalTopologyBuilder.topologyName()).thenReturn(null);
    }

    @Test
    public void shouldSetupRepartitionTopics() {
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)TOPICS_INFO1), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)TOPICS_INFO2)}));
        Set coPartitionGroup1 = Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1, SOURCE_TOPIC_NAME2});
        Set coPartitionGroup2 = Utils.mkSet((Object[])new String[]{REPARTITION_TOPIC_NAME1, REPARTITION_TOPIC_NAME2});
        List<Set> coPartitionGroups = Arrays.asList(coPartitionGroup1, coPartitionGroup2);
        Mockito.when((Object)this.internalTopologyBuilder.copartitionGroups()).thenReturn(coPartitionGroups);
        Mockito.when((Object)this.internalTopicManager.makeReady(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_TOPIC_NAME2, (Object)REPARTITION_TOPIC_CONFIG2)}))).thenReturn(Collections.emptySet());
        this.setupCluster();
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        repartitionTopics.setup();
        Map topicPartitionsInfo = repartitionTopics.topicPartitionsInfo();
        MatcherAssert.assertThat((Object)topicPartitionsInfo.size(), (Matcher)CoreMatchers.is((Object)6));
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 2);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 3);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 1);
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        ((CopartitionedTopicsEnforcer)Mockito.verify((Object)this.copartitionedTopicsEnforcer)).enforce((Set)ArgumentMatchers.eq((Object)coPartitionGroup1), (Map)ArgumentMatchers.any(), (Cluster)ArgumentMatchers.eq((Object)this.clusterMetadata));
        ((CopartitionedTopicsEnforcer)Mockito.verify((Object)this.copartitionedTopicsEnforcer)).enforce((Set)ArgumentMatchers.eq((Object)coPartitionGroup2), (Map)ArgumentMatchers.any(), (Cluster)ArgumentMatchers.eq((Object)this.clusterMetadata));
    }

    @Test
    public void shouldReturnMissingSourceTopics() {
        Set missingSourceTopics = Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1});
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)TOPICS_INFO1), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)TOPICS_INFO2)}));
        this.setupClusterWithMissingTopics(missingSourceTopics);
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        repartitionTopics.setup();
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics(), (Matcher)CoreMatchers.equalTo(Collections.singleton("__UNNAMED_TOPOLOGY__")));
        StreamsException exception = (StreamsException)((Object)repartitionTopics.missingSourceTopicExceptions().poll());
        MatcherAssert.assertThat((Object)((Object)exception), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.taskId().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(exception.taskId().get(), (Matcher)CoreMatchers.equalTo((Object)new TaskId(0, 0)));
    }

    @Test
    public void shouldThrowTaskAssignmentExceptionIfPartitionCountCannotBeComputedForAllRepartitionTopics() {
        RepartitionTopicConfig repartitionTopicConfigWithoutPartitionCount = new RepartitionTopicConfig(REPARTITION_WITHOUT_PARTITION_COUNT, TOPIC_CONFIG5);
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)TOPICS_INFO1), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)this.setupTopicInfoWithRepartitionTopicWithoutPartitionCount(repartitionTopicConfigWithoutPartitionCount))}));
        this.setupCluster();
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        TaskAssignmentException exception = (TaskAssignmentException)Assert.assertThrows(TaskAssignmentException.class, () -> ((RepartitionTopics)repartitionTopics).setup());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Failed to compute number of partitions for all repartition topics, make sure all user input topics are created and all Pattern subscriptions match at least one topic in the cluster"));
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldThrowTaskAssignmentExceptionIfSourceTopicHasNoPartitionCount() {
        RepartitionTopicConfig repartitionTopicConfigWithoutPartitionCount = new RepartitionTopicConfig(REPARTITION_WITHOUT_PARTITION_COUNT, TOPIC_CONFIG5);
        InternalTopologyBuilder.TopicsInfo topicsInfo = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{REPARTITION_WITHOUT_PARTITION_COUNT}), Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}), Collections.emptyMap());
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)topicsInfo), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)this.setupTopicInfoWithRepartitionTopicWithoutPartitionCount(repartitionTopicConfigWithoutPartitionCount))}));
        this.setupClusterWithMissingPartitionCounts(Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1}));
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        TaskAssignmentException exception = (TaskAssignmentException)Assert.assertThrows(TaskAssignmentException.class, () -> ((RepartitionTopics)repartitionTopics).setup());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"No partition count found for source topic source1, but it should have been."));
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldSetRepartitionTopicPartitionCountFromUpstreamExternalSourceTopic() {
        RepartitionTopicConfig repartitionTopicConfigWithoutPartitionCount = new RepartitionTopicConfig(REPARTITION_WITHOUT_PARTITION_COUNT, TOPIC_CONFIG5);
        InternalTopologyBuilder.TopicsInfo topicsInfo = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{REPARTITION_TOPIC_NAME1, REPARTITION_WITHOUT_PARTITION_COUNT}), Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1, REPARTITION_TOPIC_NAME2}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_TOPIC_NAME2, (Object)REPARTITION_TOPIC_CONFIG2), Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}), Collections.emptyMap());
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)topicsInfo), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)this.setupTopicInfoWithRepartitionTopicWithoutPartitionCount(repartitionTopicConfigWithoutPartitionCount))}));
        Mockito.when((Object)this.internalTopologyBuilder.copartitionGroups()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.internalTopicManager.makeReady(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_TOPIC_NAME2, (Object)REPARTITION_TOPIC_CONFIG2), Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}))).thenReturn(Collections.emptySet());
        this.setupCluster();
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        repartitionTopics.setup();
        Map topicPartitionsInfo = repartitionTopics.topicPartitionsInfo();
        MatcherAssert.assertThat((Object)topicPartitionsInfo.size(), (Matcher)CoreMatchers.is((Object)9));
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 2);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 3);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 2);
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldSetRepartitionTopicPartitionCountFromUpstreamInternalRepartitionSourceTopic() {
        RepartitionTopicConfig repartitionTopicConfigWithoutPartitionCount = new RepartitionTopicConfig(REPARTITION_WITHOUT_PARTITION_COUNT, TOPIC_CONFIG5);
        InternalTopologyBuilder.TopicsInfo topicsInfo = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{REPARTITION_TOPIC_NAME2, REPARTITION_WITHOUT_PARTITION_COUNT}), Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1, REPARTITION_TOPIC_NAME1}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_TOPIC_NAME2, (Object)REPARTITION_TOPIC_CONFIG2), Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}), Collections.emptyMap());
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)topicsInfo), Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_1, (Object)this.setupTopicInfoWithRepartitionTopicWithoutPartitionCount(repartitionTopicConfigWithoutPartitionCount))}));
        Mockito.when((Object)this.internalTopologyBuilder.copartitionGroups()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.internalTopicManager.makeReady(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_TOPIC_NAME2, (Object)REPARTITION_TOPIC_CONFIG2), Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}))).thenReturn(Collections.emptySet());
        this.setupCluster();
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        repartitionTopics.setup();
        Map topicPartitionsInfo = repartitionTopics.topicPartitionsInfo();
        MatcherAssert.assertThat((Object)topicPartitionsInfo.size(), (Matcher)CoreMatchers.is((Object)10));
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 2);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME1, 3);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_TOPIC_NAME2, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 0);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 1);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 2);
        this.verifyRepartitionTopicPartitionInfo(topicPartitionsInfo, REPARTITION_WITHOUT_PARTITION_COUNT, 3);
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotSetupRepartitionTopicsWhenTopologyDoesNotContainAnyRepartitionTopics() {
        InternalTopologyBuilder.TopicsInfo topicsInfo = new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{SINK_TOPIC_NAME1}), Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1}), Collections.emptyMap(), Collections.emptyMap());
        Mockito.when((Object)this.internalTopologyBuilder.subtopologyToTopicsInfo()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.SUBTOPOLOGY_0, (Object)topicsInfo)}));
        this.setupCluster();
        RepartitionTopics repartitionTopics = new RepartitionTopics(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.internalTopicManager, this.copartitionedTopicsEnforcer, this.clusterMetadata, "[test] ");
        repartitionTopics.setup();
        Map topicPartitionsInfo = repartitionTopics.topicPartitionsInfo();
        MatcherAssert.assertThat((Object)topicPartitionsInfo, (Matcher)CoreMatchers.is(Collections.emptyMap()));
        MatcherAssert.assertThat((Object)repartitionTopics.topologiesWithMissingInputTopics().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)repartitionTopics.missingSourceTopicExceptions().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void verifyRepartitionTopicPartitionInfo(Map<TopicPartition, PartitionInfo> topicPartitionsInfo, String topic, int partition) {
        TopicPartition repartitionTopicPartition = new TopicPartition(topic, partition);
        MatcherAssert.assertThat((Object)topicPartitionsInfo.containsKey(repartitionTopicPartition), (Matcher)CoreMatchers.is((Object)true));
        PartitionInfo repartitionTopicInfo = topicPartitionsInfo.get(repartitionTopicPartition);
        MatcherAssert.assertThat((Object)repartitionTopicInfo.topic(), (Matcher)CoreMatchers.is((Object)topic));
        MatcherAssert.assertThat((Object)repartitionTopicInfo.partition(), (Matcher)CoreMatchers.is((Object)partition));
        MatcherAssert.assertThat((Object)repartitionTopicInfo.inSyncReplicas(), (Matcher)CoreMatchers.is((Object)new Node[0]));
        MatcherAssert.assertThat((Object)repartitionTopicInfo.leader(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)repartitionTopicInfo.offlineReplicas(), (Matcher)CoreMatchers.is((Object)new Node[0]));
        MatcherAssert.assertThat((Object)repartitionTopicInfo.replicas(), (Matcher)CoreMatchers.is((Object)new Node[0]));
    }

    private void setupCluster() {
        this.setupClusterWithMissingTopicsAndMissingPartitionCounts(Collections.emptySet(), Collections.emptySet());
    }

    private void setupClusterWithMissingTopics(Set<String> missingTopics) {
        this.setupClusterWithMissingTopicsAndMissingPartitionCounts(missingTopics, Collections.emptySet());
    }

    private void setupClusterWithMissingPartitionCounts(Set<String> topicsWithMissingPartitionCounts) {
        this.setupClusterWithMissingTopicsAndMissingPartitionCounts(Collections.emptySet(), topicsWithMissingPartitionCounts);
    }

    private void setupClusterWithMissingTopicsAndMissingPartitionCounts(Set<String> missingTopics, Set<String> topicsWithMissingPartitionCounts) {
        Set topics = Utils.mkSet((Object[])new String[]{SOURCE_TOPIC_NAME1, SOURCE_TOPIC_NAME2, SOURCE_TOPIC_NAME3, SINK_TOPIC_NAME1, SINK_TOPIC_NAME2, REPARTITION_TOPIC_NAME1, REPARTITION_TOPIC_NAME2, REPARTITION_TOPIC_NAME3, REPARTITION_TOPIC_NAME4, SOME_OTHER_TOPIC});
        topics.removeAll(missingTopics);
        Mockito.when((Object)this.clusterMetadata.topics()).thenReturn((Object)topics);
        Mockito.when((Object)this.clusterMetadata.partitionCountForTopic(SOURCE_TOPIC_NAME1)).thenReturn((Object)(topicsWithMissingPartitionCounts.contains(SOURCE_TOPIC_NAME1) ? null : Integer.valueOf(3)));
    }

    private InternalTopologyBuilder.TopicsInfo setupTopicInfoWithRepartitionTopicWithoutPartitionCount(RepartitionTopicConfig repartitionTopicConfigWithoutPartitionCount) {
        return new InternalTopologyBuilder.TopicsInfo(Utils.mkSet((Object[])new String[]{SINK_TOPIC_NAME2}), Utils.mkSet((Object[])new String[]{REPARTITION_TOPIC_NAME1, REPARTITION_WITHOUT_PARTITION_COUNT}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)REPARTITION_TOPIC_NAME1, (Object)REPARTITION_TOPIC_CONFIG1), Utils.mkEntry((Object)REPARTITION_WITHOUT_PARTITION_COUNT, (Object)repartitionTopicConfigWithoutPartitionCount)}), Collections.emptyMap());
    }
}

