/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.apache.kafka.streams.state.internals.CacheFlushListenerStub;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheTest;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class CachingInMemoryKeyValueStoreTest
extends AbstractKeyValueStoreTest {
    private static final String TOPIC = "topic";
    private static final String CACHE_NAMESPACE = "0_0-store-name";
    private final int maxCacheSizeBytes = 150;
    private InternalMockProcessorContext context;
    private CachingKeyValueStore store;
    private KeyValueStore<Bytes, byte[]> underlyingStore;
    private ThreadCache cache;
    private CacheFlushListenerStub<String, String> cacheFlushListener;

    @Before
    public void setUp() {
        String storeName = "store";
        this.underlyingStore = new InMemoryKeyValueStore("store");
        this.cacheFlushListener = new CacheFlushListenerStub(new StringDeserializer(), new StringDeserializer());
        this.store = new CachingKeyValueStore(this.underlyingStore, false);
        this.store.setFlushListener(this.cacheFlushListener, false);
        this.cache = new ThreadCache(new LogContext("testCache "), 150L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.context = new InternalMockProcessorContext(null, null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.store.init((StateStoreContext)this.context, null);
    }

    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(StateStoreContext context) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"cache-store"), (Serde)context.keySerde(), (Serde)context.valueSerde()).withCachingEnabled();
        KeyValueStore store = (KeyValueStore)storeBuilder.build();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        KeyValueStore inner = (KeyValueStore)Mockito.mock(InMemoryKeyValueStore.class);
        CachingKeyValueStore outer = new CachingKeyValueStore(inner, false);
        Mockito.when((Object)inner.name()).thenReturn((Object)"store");
        outer.init((ProcessorContext)this.context, (StateStore)outer);
        ((KeyValueStore)Mockito.verify((Object)inner)).init((ProcessorContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldDelegateInit() {
        KeyValueStore inner = (KeyValueStore)Mockito.mock(InMemoryKeyValueStore.class);
        CachingKeyValueStore outer = new CachingKeyValueStore(inner, false);
        Mockito.when((Object)inner.name()).thenReturn((Object)"store");
        outer.init((StateStoreContext)this.context, (StateStore)outer);
        ((KeyValueStore)Mockito.verify((Object)inner)).init((StateStoreContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldSetFlushListener() {
        Assert.assertTrue((boolean)this.store.setFlushListener(null, true));
        Assert.assertTrue((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldAvoidFlushingDeletionsWithoutDirtyKeys() {
        int added = this.addItemsToCache();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
        this.store.put(this.bytesKey("key"), this.bytesValue("value"));
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
        this.store.put(this.bytesKey("key"), null);
        this.store.flush();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.cacheFlushListener.forwarded.size());
    }

    @Test
    public void shouldCloseWrappedStoreAndCacheAfterErrorDuringCacheFlush() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache, this.underlyingStore});
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on flush")}).when((Object)this.cache)).flush(CACHE_NAMESPACE);
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).close(CACHE_NAMESPACE);
        ((KeyValueStore)inOrder.verify(this.underlyingStore)).close();
    }

    @Test
    public void shouldCloseWrappedStoreAfterErrorDuringCacheClose() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache, this.underlyingStore});
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).when((Object)this.cache)).close(CACHE_NAMESPACE);
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).flush(CACHE_NAMESPACE);
        ((KeyValueStore)inOrder.verify(this.underlyingStore)).close();
    }

    @Test
    public void shouldCloseCacheAfterErrorDuringStateStoreClose() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache});
        ((KeyValueStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).when(this.underlyingStore)).close();
        Assert.assertThrows(RuntimeException.class, () -> ((CachingKeyValueStore)this.store).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).flush(CACHE_NAMESPACE);
        ((ThreadCache)inOrder.verify((Object)this.cache)).close(CACHE_NAMESPACE);
    }

    private void setUpCloseTests() {
        this.underlyingStore = (KeyValueStore)Mockito.mock(KeyValueStore.class);
        Mockito.when((Object)this.underlyingStore.name()).thenReturn((Object)"store-name");
        this.store = new CachingKeyValueStore(this.underlyingStore, false);
        this.cache = (ThreadCache)Mockito.mock(ThreadCache.class);
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldPutGetToFromCache() {
        this.store.put(this.bytesKey("key"), this.bytesValue("value"));
        this.store.put(this.bytesKey("key2"), this.bytesValue("value2"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("key")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("value")));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("key2")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("value2")));
        Assert.assertEquals((long)2L, (long)this.cache.size());
        Assert.assertEquals((long)0L, (long)this.underlyingStore.approximateNumEntries());
    }

    @Test
    public void shouldMatchPositionAfterPutWithFlushListener() {
        this.store.setFlushListener(record -> {}, false);
        this.shouldMatchPositionAfterPut();
    }

    @Test
    public void shouldMatchPositionAfterPutWithoutFlushListener() {
        this.store.setFlushListener(null, false);
        this.shouldMatchPositionAfterPut();
    }

    private void shouldMatchPositionAfterPut() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.store.put(this.bytesKey("key1"), this.bytesValue("value1"));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.store.put(this.bytesKey("key2"), this.bytesValue("value2"));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        Assert.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.store.getPosition());
        Assert.assertEquals((Object)Position.emptyPosition(), (Object)this.underlyingStore.getPosition());
        this.store.flush();
        Assert.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.store.getPosition());
        Assert.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.underlyingStore.getPosition());
    }

    private byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }

    @Test
    public void shouldFlushEvictedItemsIntoUnderlyingStore() {
        int added = this.addItemsToCache();
        Assert.assertEquals((long)added, (long)this.underlyingStore.approximateNumEntries());
        Assert.assertEquals((long)added, (long)this.store.approximateNumEntries());
        Assert.assertNotNull((Object)this.underlyingStore.get((Object)Bytes.wrap((byte[])"0".getBytes())));
    }

    @Test
    public void shouldForwardDirtyItemToListenerWhenEvicted() {
        int numRecords = this.addItemsToCache();
        Assert.assertEquals((long)numRecords, (long)this.cacheFlushListener.forwarded.size());
    }

    @Test
    public void shouldForwardDirtyItemsWhenFlushCalled() {
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
    }

    @Test
    public void shouldForwardOldValuesWhenEnabled() {
        this.store.setFlushListener(this.cacheFlushListener, true);
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), this.bytesValue("c"));
        this.store.flush();
        Assert.assertEquals((Object)"c", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertEquals((Object)"c", (Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.cacheFlushListener.forwarded.clear();
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull(this.cacheFlushListener.forwarded.get("1"));
        this.cacheFlushListener.forwarded.clear();
    }

    @Test
    public void shouldNotForwardOldValuesWhenDisabled() {
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.flush();
        Assert.assertEquals((Object)"b", (Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").newValue);
        Assert.assertNull((Object)this.cacheFlushListener.forwarded.get((Object)"1").oldValue);
        this.cacheFlushListener.forwarded.clear();
        this.store.put(this.bytesKey("1"), this.bytesValue("a"));
        this.store.put(this.bytesKey("1"), this.bytesValue("b"));
        this.store.put(this.bytesKey("1"), null);
        this.store.flush();
        Assert.assertNull(this.cacheFlushListener.forwarded.get("1"));
        this.cacheFlushListener.forwarded.clear();
    }

    @Test
    public void shouldIterateAllStoredItems() {
        int items = this.addItemsToCache();
        ArrayList<Object> results = new ArrayList<Object>();
        try (KeyValueIterator all = this.store.all();){
            while (all.hasNext()) {
                results.add(((KeyValue)all.next()).key);
            }
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"0".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"2".getBytes())), results);
    }

    @Test
    public void shouldReverseIterateAllStoredItems() {
        int items = this.addItemsToCache();
        ArrayList<Object> results = new ArrayList<Object>();
        try (KeyValueIterator all = this.store.reverseAll();){
            while (all.hasNext()) {
                results.add(((KeyValue)all.next()).key);
            }
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"2".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"0".getBytes())), results);
    }

    @Test
    public void shouldIterateOverRange() {
        int items = this.addItemsToCache();
        ArrayList<Object> results = new ArrayList<Object>();
        try (KeyValueIterator range = this.store.range(this.bytesKey(String.valueOf(0)), this.bytesKey(String.valueOf(items)));){
            while (range.hasNext()) {
                results.add(((KeyValue)range.next()).key);
            }
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"0".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"2".getBytes())), results);
    }

    @Test
    public void shouldReverseIterateOverRange() {
        int items = this.addItemsToCache();
        ArrayList<Object> results = new ArrayList<Object>();
        try (KeyValueIterator range = this.store.reverseRange(this.bytesKey(String.valueOf(0)), this.bytesKey(String.valueOf(items)));){
            while (range.hasNext()) {
                results.add(((KeyValue)range.next()).key);
            }
        }
        Assert.assertEquals((long)items, (long)results.size());
        Assert.assertEquals(Arrays.asList(Bytes.wrap((byte[])"2".getBytes()), Bytes.wrap((byte[])"1".getBytes()), Bytes.wrap((byte[])"0".getBytes())), results);
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("p11"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("k1"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("k2"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p2"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p1"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("p0"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)"p1", (Serializer)new StringSerializer());){
            while (keysWithPrefix.hasNext()) {
                KeyValue next = (KeyValue)keysWithPrefix.next();
                keys.add(((Bytes)next.key).toString());
                values.add(new String((byte[])next.value));
                ++numberOfKeysReturned;
            }
        }
        Assert.assertEquals((long)2L, (long)numberOfKeysReturned);
        Assert.assertEquals(Arrays.asList("p1", "p11"), keys);
        Assert.assertEquals(Arrays.asList("2", "2"), values);
    }

    @Test
    public void shouldGetRecordsWithPrefixKeyExcludingNextLargestKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("abcd"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("abcdd"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("abce"), (Object)this.bytesValue("2")));
        entries.add(new KeyValue((Object)this.bytesKey("abc"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int numberOfKeysReturned = 0;
        try (KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)"abcd", (Serializer)new StringSerializer());){
            while (keysWithPrefix.hasNext()) {
                KeyValue next = (KeyValue)keysWithPrefix.next();
                keys.add(((Bytes)next.key).toString());
                values.add(new String((byte[])next.value));
                ++numberOfKeysReturned;
            }
        }
        Assert.assertEquals((long)2L, (long)numberOfKeysReturned);
        Assert.assertEquals(Arrays.asList("abcd", "abcdd"), keys);
        Assert.assertEquals(Arrays.asList("2", "1"), values);
    }

    @Test
    public void shouldDeleteItemsFromCache() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        this.store.delete(this.bytesKey("a"));
        Assert.assertNull((Object)this.store.get(this.bytesKey("a")));
        Assert.assertFalse((boolean)this.store.range(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.all().hasNext());
        Assert.assertFalse((boolean)this.store.reverseAll().hasNext());
    }

    @Test
    public void shouldNotShowItemsDeletedFromCacheButFlushedToStoreBeforeDelete() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        this.store.flush();
        this.store.delete(this.bytesKey("a"));
        Assert.assertNull((Object)this.store.get(this.bytesKey("a")));
        Assert.assertFalse((boolean)this.store.range(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b")).hasNext());
        Assert.assertFalse((boolean)this.store.all().hasNext());
        Assert.assertFalse((boolean)this.store.reverseAll().hasNext());
    }

    @Test
    public void shouldClearNamespaceCacheOnClose() {
        this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.store.close();
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void shouldThrowIfTryingToGetFromClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.get(this.bytesKey("a"));
        });
    }

    @Test
    public void shouldThrowIfTryingToWriteToClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.put(this.bytesKey("a"), this.bytesValue("a"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoRangeQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.range(this.bytesKey("a"), this.bytesKey("b"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoReverseRangeQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.reverseRange(this.bytesKey("a"), this.bytesKey("b"));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoAllQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.all();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoReverseAllQueryOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.reverseAll();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoGetApproxSizeOnClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.close();
            this.store.approximateNumEntries();
        });
    }

    @Test
    public void shouldThrowIfTryingToDoPutAllClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.putAll(Collections.singletonList(KeyValue.pair((Object)this.bytesKey("a"), (Object)this.bytesValue("a"))));
        });
    }

    @Test
    public void shouldThrowIfTryingToDoPutIfAbsentClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("c"));
        });
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutWithNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(null, this.bytesValue("c")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutIfAbsentWithNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.putIfAbsent(null, this.bytesValue("c")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutAllWithNullKey() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue(null, (Object)this.bytesValue("a")));
        Assert.assertThrows(NullPointerException.class, () -> this.store.putAll(entries));
    }

    @Test
    public void shouldPutIfAbsent() {
        this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("2"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
        this.store.putIfAbsent(this.bytesKey("b"), this.bytesValue("3"));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
    }

    @Override
    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)this.bytesKey("a"), (Object)this.bytesValue("1")));
        entries.add(new KeyValue((Object)this.bytesKey("b"), (Object)this.bytesValue("2")));
        this.store.putAll(entries);
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("a")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("1")));
        MatcherAssert.assertThat((Object)this.store.get(this.bytesKey("b")), (Matcher)CoreMatchers.equalTo((Object)this.bytesValue("2")));
    }

    @Test
    public void shouldReturnUnderlying() {
        Assert.assertEquals(this.underlyingStore, (Object)this.store.wrapped());
    }

    @Test
    public void shouldThrowIfTryingToDeleteFromClosedCachingStore() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> {
            this.store.close();
            this.store.delete(this.bytesKey("key"));
        });
    }

    private int addItemsToCache() {
        String kv;
        int i = 0;
        for (long cachedSize = 0L; cachedSize < 150L; cachedSize += ThreadCacheTest.memoryCacheEntrySize(kv.getBytes(), kv.getBytes(), TOPIC)) {
            kv = String.valueOf(i++);
            this.store.put(this.bytesKey(kv), this.bytesValue(kv));
        }
        return i;
    }
}

