/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Graph<V extends Comparable<V>> {
    private final SortedMap<V, SortedMap<V, Edge>> adjList = new TreeMap<V, SortedMap<V, Edge>>();
    private final SortedSet<V> nodes = new TreeSet<V>();
    private final boolean isResidualGraph;
    private V sourceNode;
    private V sinkNode;

    public Graph() {
        this(false);
    }

    private Graph(boolean isResidualGraph) {
        this.isResidualGraph = isResidualGraph;
    }

    public void addEdge(V u, V v, int capacity, int cost, int flow) {
        this.addEdge(u, new Edge(this, v, capacity, cost, capacity - flow, flow));
    }

    public SortedSet<V> nodes() {
        return this.nodes;
    }

    public SortedMap<V, Edge> edges(V node) {
        SortedMap edge = (SortedMap)this.adjList.get(node);
        return edge == null ? new TreeMap() : edge;
    }

    public boolean isResidualGraph() {
        return this.isResidualGraph;
    }

    public void setSourceNode(V node) {
        this.sourceNode = node;
    }

    public void setSinkNode(V node) {
        this.sinkNode = node;
    }

    public long totalCost() {
        long totalCost = 0L;
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            SortedMap<V, Edge> edges = nodeEdges.getValue();
            for (Edge nodeEdge : edges.values()) {
                totalCost += (long)nodeEdge.cost * (long)nodeEdge.flow;
            }
        }
        return totalCost;
    }

    private void addEdge(V u, Edge edge) {
        Map edgeMap;
        if (!this.isResidualGraph && (edgeMap = (Map)this.adjList.get(edge.destination)) != null && edgeMap.containsKey(u)) {
            throw new IllegalArgumentException("There is already an edge from " + edge.destination + " to " + u + ". Can not add an edge from " + u + " to " + edge.destination + " since there will create a cycle between two nodes");
        }
        this.adjList.computeIfAbsent((SortedMap)u, (Function<SortedMap, SortedMap<SortedMap, Edge>>)((Function<Comparable, SortedMap>)set -> new TreeMap())).put(edge.destination, edge);
        this.nodes.add(u);
        this.nodes.add(edge.destination);
    }

    public Graph<V> residualGraph() {
        if (this.isResidualGraph) {
            return this;
        }
        Graph<V> residualGraph = new Graph<V>(true);
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            SortedMap<V, Edge> edges = nodeEdges.getValue();
            for (Map.Entry<V, Edge> nodeEdge : edges.entrySet()) {
                Edge backwardEdge;
                Edge edge = nodeEdge.getValue();
                Edge forwardEdge = new Edge(this, edge.destination, edge.capacity, edge.cost, edge.capacity - edge.flow, edge.flow);
                forwardEdge.counterEdge = backwardEdge = new Edge(this, node, edge.capacity, edge.cost * -1, edge.flow, 0, false);
                backwardEdge.counterEdge = forwardEdge;
                super.addEdge(node, forwardEdge);
                super.addEdge(edge.destination, backwardEdge);
            }
        }
        return residualGraph;
    }

    public void solveMinCostFlow() {
        this.validateMinCostGraph();
        Graph<V> residualGraph = this.residualGraph();
        super.cancelNegativeCycles();
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                Comparable destination = (Comparable)nodeEdge.getKey();
                Edge edge = nodeEdge.getValue();
                Edge residualEdge = (Edge)((SortedMap)residualGraph.adjList.get(node)).get(destination);
                edge.flow = residualEdge.flow;
                edge.residualFlow = residualEdge.residualFlow;
            }
        }
    }

    private void populateInOutFlow(Map<V, Long> inFlow, Map<V, Long> outFlow) {
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            if (node.equals(this.sinkNode)) {
                throw new IllegalStateException("Sink node " + this.sinkNode + " shouldn't have output");
            }
            for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                Comparable destination = (Comparable)nodeEdge.getKey();
                if (destination.equals(this.sourceNode)) {
                    throw new IllegalStateException("Source node " + this.sourceNode + " shouldn't have input " + node);
                }
                Edge edge = nodeEdge.getValue();
                Long count = outFlow.get(node);
                if (count == null) {
                    outFlow.put((Long)node, Long.valueOf(edge.flow));
                } else {
                    outFlow.put((Long)node, count + (long)edge.flow);
                }
                count = inFlow.get(destination);
                if (count == null) {
                    inFlow.put((Long)destination, Long.valueOf(edge.flow));
                    continue;
                }
                inFlow.put((Long)destination, count + (long)edge.flow);
            }
        }
    }

    private void validateMinCostGraph() {
        Long sinkInput;
        if (this.isResidualGraph) {
            throw new IllegalStateException("Should not be residual graph to solve min cost flow");
        }
        HashMap inFlow = new HashMap();
        HashMap outFlow = new HashMap();
        this.populateInOutFlow(inFlow, outFlow);
        for (Map.Entry in : inFlow.entrySet()) {
            if (((Comparable)in.getKey()).equals(this.sourceNode) || ((Comparable)in.getKey()).equals(this.sinkNode)) continue;
            Long out = (Long)outFlow.get(in.getKey());
            if (Objects.equals(in.getValue(), out)) continue;
            throw new IllegalStateException("Input flow for node " + in.getKey() + " is " + in.getValue() + " which doesn't match output flow " + out);
        }
        Long sourceOutput = (Long)outFlow.get(this.sourceNode);
        if (!Objects.equals(sourceOutput, sinkInput = (Long)inFlow.get(this.sinkNode))) {
            throw new IllegalStateException("Output flow for source " + this.sourceNode + " is " + sourceOutput + " which doesn't match input flow " + sinkInput + " for sink " + this.sinkNode);
        }
    }

    private void cancelNegativeCycles() {
        if (!this.isResidualGraph) {
            throw new IllegalStateException("Should be residual graph to cancel negative cycles");
        }
        boolean cyclePossible = true;
        while (cyclePossible) {
            cyclePossible = false;
            for (Comparable node : this.nodes) {
                HashMap parentEdges;
                HashMap parentNodes;
                Comparable possibleNodeInCycle = this.detectNegativeCycles(node, parentNodes = new HashMap(), parentEdges = new HashMap());
                if (possibleNodeInCycle == null) continue;
                HashSet<Comparable> visited = new HashSet<Comparable>();
                Comparable nodeInCycle = possibleNodeInCycle;
                while (!visited.contains(nodeInCycle)) {
                    visited.add(nodeInCycle);
                    nodeInCycle = (Comparable)parentNodes.get(nodeInCycle);
                }
                cyclePossible = true;
                this.cancelNegativeCycle(nodeInCycle, parentNodes, parentEdges);
            }
        }
    }

    private void cancelNegativeCycle(V nodeInCycle, Map<V, V> parentNodes, Map<V, Edge> parentEdges) {
        Comparable parentNode = (Comparable)parentNodes.get(nodeInCycle);
        Edge parentEdge = parentEdges.get(nodeInCycle);
        int possibleFlow = parentEdge.residualFlow;
        Comparable curNode = parentNode;
        while (curNode != nodeInCycle) {
            parentEdge = parentEdges.get(curNode);
            possibleFlow = Math.min(possibleFlow, parentEdge.residualFlow);
            curNode = (Comparable)parentNodes.get(curNode);
        }
        parentEdge = parentEdges.get(nodeInCycle);
        Edge counterEdge = parentEdge.counterEdge;
        parentEdge.residualFlow -= possibleFlow;
        if (parentEdge.forwardEdge) {
            parentEdge.flow += possibleFlow;
        }
        counterEdge.residualFlow += possibleFlow;
        if (counterEdge.forwardEdge && counterEdge.flow >= possibleFlow) {
            counterEdge.flow -= possibleFlow;
        }
        Comparable curNode2 = parentNode;
        while (curNode2 != nodeInCycle) {
            parentEdge = parentEdges.get(curNode2);
            counterEdge = parentEdge.counterEdge;
            parentEdge.residualFlow -= possibleFlow;
            if (parentEdge.forwardEdge) {
                parentEdge.flow += possibleFlow;
            }
            counterEdge.residualFlow += possibleFlow;
            if (counterEdge.forwardEdge && counterEdge.flow >= possibleFlow) {
                counterEdge.flow -= possibleFlow;
            }
            curNode2 = (Comparable)parentNodes.get(curNode2);
        }
    }

    V detectNegativeCycles(V source, Map<V, V> parentNodes, Map<V, Edge> parentEdges) {
        Map<Comparable, Long> distance = this.nodes.stream().collect(Collectors.toMap(node -> node, node -> Integer.MAX_VALUE));
        distance.put((Comparable)source, 0L);
        int nodeCount = this.nodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
                Comparable u = (Comparable)nodeEdges.getKey();
                for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                    Object v;
                    Edge edge = nodeEdge.getValue();
                    if (edge.residualFlow == 0 || distance.get(v = edge.destination) <= distance.get(u) + (long)edge.cost) continue;
                    if (i == nodeCount - 1) {
                        return v;
                    }
                    distance.put((Comparable)v, distance.get(u) + (long)edge.cost);
                    parentNodes.put((Comparable)v, u);
                    parentEdges.put((Edge)v, edge);
                }
            }
        }
        return null;
    }

    public class Edge {
        final V destination;
        final int capacity;
        final int cost;
        int residualFlow;
        int flow;
        Edge counterEdge;
        boolean forwardEdge;
        final /* synthetic */ Graph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Edge(V destination, int capacity, int cost, int residualFlow, int flow) {
            this((Graph)this$0, (Comparable)destination, capacity, cost, residualFlow, flow, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public Edge(V destination, int capacity, int cost, int residualFlow, int flow, boolean forwardEdge) {
            this.this$0 = (Graph)this$0;
            Objects.requireNonNull(destination);
            if (capacity < 0) {
                throw new IllegalArgumentException("Edge capacity cannot be negative");
            }
            if (flow > capacity) {
                throw new IllegalArgumentException(String.format("Edge flow %d cannot exceed capacity %d", flow, capacity));
            }
            this.destination = destination;
            this.capacity = capacity;
            this.cost = cost;
            this.residualFlow = residualFlow;
            this.flow = flow;
            this.forwardEdge = forwardEdge;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Edge otherEdge = (Edge)other;
            return this.destination.equals(otherEdge.destination) && this.capacity == otherEdge.capacity && this.cost == otherEdge.cost && this.residualFlow == otherEdge.residualFlow && this.flow == otherEdge.flow && this.forwardEdge == otherEdge.forwardEdge;
        }

        public int hashCode() {
            return Objects.hash(this.destination, this.capacity, this.cost, this.residualFlow, this.flow, this.forwardEdge);
        }

        public String toString() {
            return "Edge {destination= " + this.destination + ", capacity=" + this.capacity + ", cost=" + this.cost + ", residualFlow=" + this.residualFlow + ", flow=" + this.flow + ", forwardEdge=" + this.forwardEdge + "}";
        }
    }
}

