/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ClientStateTest {
    private final ClientState client = new ClientState(1);
    private final ClientState zeroCapacityClient = new ClientState(0);

    @Test
    public void previousStateConstructorShouldCreateAValidObject() {
        ClientState clientState = new ClientState(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1}), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)5L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)-1L)}), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 4);
        MatcherAssert.assertThat((Object)clientState.activeTaskCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)clientState.activeTaskLoad(), (Matcher)Matchers.is((Object)0.0));
        MatcherAssert.assertThat((Object)clientState.activeTasks(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)clientState.standbyTaskCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)clientState.standbyTasks(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)clientState.assignedTaskCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)clientState.assignedTasks(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)clientState.prevActiveTasks(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)clientState.prevStandbyTasks(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3})));
        MatcherAssert.assertThat((Object)clientState.previousAssignedTasks(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3})));
        MatcherAssert.assertThat((Object)clientState.capacity(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)clientState.lagFor(AssignmentTestUtils.TASK_0_0), (Matcher)Matchers.is((Object)5L));
        MatcherAssert.assertThat((Object)clientState.lagFor(AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)-1L));
    }

    @Test
    public void shouldHaveNotReachedCapacityWhenAssignedTasksLessThanCapacity() {
        Assert.assertFalse((boolean)this.client.reachedCapacity());
    }

    @Test
    public void shouldHaveReachedCapacityWhenAssignedTasksGreaterThanOrEqualToCapacity() {
        this.client.assignActive(AssignmentTestUtils.TASK_0_1);
        Assert.assertTrue((boolean)this.client.reachedCapacity());
    }

    @Test
    public void shouldRefuseDoubleActiveTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignActive(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.assignActive(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseActiveAndStandbyTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignActive(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.assignStandby(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseDoubleStandbyTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignStandby(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.assignStandby(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseStandbyAndActiveTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignStandby(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.assignActive(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseToUnassignNotAssignedActiveTask() {
        ClientState clientState = new ClientState(1);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.unassignActive(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseToUnassignNotAssignedStandbyTask() {
        ClientState clientState = new ClientState(1);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.unassignStandby(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseToUnassignActiveTaskAsStandby() {
        ClientState clientState = new ClientState(1);
        clientState.assignActive(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.unassignStandby(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldRefuseToUnassignStandbyTaskAsActive() {
        ClientState clientState = new ClientState(1);
        clientState.assignStandby(AssignmentTestUtils.TASK_0_0);
        Assert.assertThrows(IllegalArgumentException.class, () -> clientState.unassignActive(AssignmentTestUtils.TASK_0_0));
    }

    @Test
    public void shouldUnassignActiveTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignActive(AssignmentTestUtils.TASK_0_0);
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasActiveTasks(1));
        clientState.unassignActive(AssignmentTestUtils.TASK_0_0);
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasActiveTasks(0));
    }

    @Test
    public void shouldUnassignStandbyTask() {
        ClientState clientState = new ClientState(1);
        clientState.assignStandby(AssignmentTestUtils.TASK_0_0);
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasStandbyTasks(1));
        clientState.unassignStandby(AssignmentTestUtils.TASK_0_0);
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasStandbyTasks(0));
    }

    @Test
    public void shouldNotModifyActiveView() {
        ClientState clientState = new ClientState(1);
        Set taskIds = clientState.activeTasks();
        Assert.assertThrows(UnsupportedOperationException.class, () -> taskIds.add(AssignmentTestUtils.TASK_0_0));
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasActiveTasks(0));
    }

    @Test
    public void shouldNotModifyStandbyView() {
        ClientState clientState = new ClientState(1);
        Set taskIds = clientState.standbyTasks();
        Assert.assertThrows(UnsupportedOperationException.class, () -> taskIds.add(AssignmentTestUtils.TASK_0_0));
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasStandbyTasks(0));
    }

    @Test
    public void shouldNotModifyAssignedView() {
        ClientState clientState = new ClientState(1);
        Set taskIds = clientState.assignedTasks();
        Assert.assertThrows(UnsupportedOperationException.class, () -> taskIds.add(AssignmentTestUtils.TASK_0_0));
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasActiveTasks(0));
        MatcherAssert.assertThat((Object)clientState, AssignmentTestUtils.hasStandbyTasks(0));
    }

    @Test
    public void shouldAddActiveTasksToBothAssignedAndActive() {
        this.client.assignActive(AssignmentTestUtils.TASK_0_1);
        MatcherAssert.assertThat((Object)this.client.activeTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.client.assignedTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.client.assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.client.standbyTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAddStandbyTasksToBothStandbyAndAssigned() {
        this.client.assignStandby(AssignmentTestUtils.TASK_0_1);
        MatcherAssert.assertThat((Object)this.client.assignedTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.client.standbyTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.client.assignedTaskCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.client.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAddPreviousActiveTasksToPreviousAssignedAndPreviousActive() {
        this.client.addPreviousActiveTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}));
        MatcherAssert.assertThat((Object)this.client.prevActiveTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldAddPreviousStandbyTasksToPreviousAssignedAndPreviousStandby() {
        this.client.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}));
        MatcherAssert.assertThat((Object)this.client.prevActiveTasks().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldHaveAssignedTaskIfActiveTaskAssigned() {
        this.client.assignActive(AssignmentTestUtils.TASK_0_1);
        Assert.assertTrue((boolean)this.client.hasAssignedTask(AssignmentTestUtils.TASK_0_1));
    }

    @Test
    public void shouldHaveAssignedTaskIfStandbyTaskAssigned() {
        this.client.assignStandby(AssignmentTestUtils.TASK_0_1);
        Assert.assertTrue((boolean)this.client.hasAssignedTask(AssignmentTestUtils.TASK_0_1));
    }

    @Test
    public void shouldNotHaveAssignedTaskIfTaskNotAssigned() {
        this.client.assignActive(AssignmentTestUtils.TASK_0_1);
        Assert.assertFalse((boolean)this.client.hasAssignedTask(AssignmentTestUtils.TASK_0_2));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityTheSameButFewerAssignedTasks() {
        ClientState otherClient = new ClientState(1);
        this.client.assignActive(AssignmentTestUtils.TASK_0_1);
        Assert.assertTrue((boolean)otherClient.hasMoreAvailableCapacityThan(this.client));
        Assert.assertFalse((boolean)this.client.hasMoreAvailableCapacityThan(otherClient));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityHigherAndSameAssignedTaskCount() {
        ClientState otherClient = new ClientState(2);
        Assert.assertTrue((boolean)otherClient.hasMoreAvailableCapacityThan(this.client));
        Assert.assertFalse((boolean)this.client.hasMoreAvailableCapacityThan(otherClient));
    }

    @Test
    public void shouldUseMultiplesOfCapacityToDetermineClientWithMoreAvailableCapacity() {
        int i;
        ClientState otherClient = new ClientState(2);
        for (i = 0; i < 7; ++i) {
            otherClient.assignActive(new TaskId(0, i));
        }
        for (i = 7; i < 11; ++i) {
            this.client.assignActive(new TaskId(0, i));
        }
        Assert.assertTrue((boolean)otherClient.hasMoreAvailableCapacityThan(this.client));
    }

    @Test
    public void shouldHaveMoreAvailableCapacityWhenCapacityIsTheSameButAssignedTasksIsLess() {
        ClientState client = new ClientState(3);
        ClientState otherClient = new ClientState(3);
        for (int i = 0; i < 4; ++i) {
            client.assignActive(new TaskId(0, i));
            otherClient.assignActive(new TaskId(0, i));
        }
        otherClient.assignActive(new TaskId(0, 5));
        Assert.assertTrue((boolean)client.hasMoreAvailableCapacityThan(otherClient));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfCapacityOfThisClientStateIsZero() {
        Assert.assertThrows(IllegalStateException.class, () -> this.zeroCapacityClient.hasMoreAvailableCapacityThan(this.client));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfCapacityOfOtherClientStateIsZero() {
        Assert.assertThrows(IllegalStateException.class, () -> this.client.hasMoreAvailableCapacityThan(this.zeroCapacityClient));
    }

    @Test
    public void shouldHaveUnfulfilledQuotaWhenActiveTaskSizeLessThanCapacityTimesTasksPerThread() {
        this.client.assignActive(new TaskId(0, 1));
        Assert.assertTrue((boolean)this.client.hasUnfulfilledQuota(2));
    }

    @Test
    public void shouldNotHaveUnfulfilledQuotaWhenActiveTaskSizeGreaterEqualThanCapacityTimesTasksPerThread() {
        this.client.assignActive(new TaskId(0, 1));
        Assert.assertFalse((boolean)this.client.hasUnfulfilledQuota(1));
    }

    @Test
    public void shouldAddTasksWithLatestOffsetToPrevActiveTasks() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, -2L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.initializePrevTasks(Collections.emptyMap(), false);
        MatcherAssert.assertThat((Object)this.client.prevActiveTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        Assert.assertTrue((boolean)this.client.prevStandbyTasks().isEmpty());
    }

    @Test
    public void shouldThrowWhenSomeOwnedPartitionsAreNotRecognizedWhenInitializingPrevTasks() {
        Map<TopicPartition, TaskId> taskForPartitionMap = Collections.singletonMap(AssignmentTestUtils.TP_0_1, AssignmentTestUtils.TASK_0_1);
        this.client.addOwnedPartitions(Collections.singleton(AssignmentTestUtils.TP_0_0), "c1");
        this.client.addPreviousTasksAndOffsetSums("c1", Collections.emptyMap());
        Assert.assertThrows(IllegalStateException.class, () -> this.client.initializePrevTasks(taskForPartitionMap, false));
    }

    @Test
    public void shouldFilterOutUnrecognizedPartitionsAndInitializePrevTasksWhenUsingNamedTopologies() {
        Map<TopicPartition, TaskId> taskForPartitionMap = Collections.singletonMap(AssignmentTestUtils.TP_0_1, AssignmentTestUtils.TASK_0_1);
        this.client.addOwnedPartitions(Collections.singleton(AssignmentTestUtils.TP_0_0), "c1");
        this.client.addPreviousTasksAndOffsetSums("c1", Collections.emptyMap());
        this.client.initializePrevTasks(taskForPartitionMap, true);
        MatcherAssert.assertThat((Object)this.client.prevActiveTasks().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.client.prevStandbyTasks().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldReturnPreviousStatefulTasksForConsumer() {
        this.client.addPreviousTasksAndOffsetSums("c1", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)100L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)-2L)}));
        this.client.addPreviousTasksAndOffsetSums("c2", Collections.singletonMap(AssignmentTestUtils.TASK_0_2, 0L));
        this.client.addPreviousTasksAndOffsetSums("c3", Collections.emptyMap());
        this.client.initializePrevTasks(Collections.emptyMap(), false);
        MatcherAssert.assertThat((Object)this.client.prevOwnedStatefulTasksByConsumer("c1"), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)this.client.prevOwnedStatefulTasksByConsumer("c2"), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        Assert.assertTrue((boolean)this.client.prevOwnedStatefulTasksByConsumer("c3").isEmpty());
    }

    @Test
    public void shouldReturnPreviousActiveStandbyTasksForConsumer() {
        this.client.addOwnedPartitions((Collection)Utils.mkSet((Object[])new TopicPartition[]{AssignmentTestUtils.TP_0_1, AssignmentTestUtils.TP_1_1}), "c1");
        this.client.addOwnedPartitions((Collection)Utils.mkSet((Object[])new TopicPartition[]{AssignmentTestUtils.TP_0_2, AssignmentTestUtils.TP_1_2}), "c2");
        this.client.initializePrevTasks(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TP_0_0, (Object)AssignmentTestUtils.TASK_0_0), Utils.mkEntry((Object)AssignmentTestUtils.TP_0_1, (Object)AssignmentTestUtils.TASK_0_1), Utils.mkEntry((Object)AssignmentTestUtils.TP_0_2, (Object)AssignmentTestUtils.TASK_0_2), Utils.mkEntry((Object)AssignmentTestUtils.TP_1_0, (Object)AssignmentTestUtils.TASK_0_0), Utils.mkEntry((Object)AssignmentTestUtils.TP_1_1, (Object)AssignmentTestUtils.TASK_0_1), Utils.mkEntry((Object)AssignmentTestUtils.TP_1_2, (Object)AssignmentTestUtils.TASK_0_2)}), false);
        this.client.addPreviousTasksAndOffsetSums("c1", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)10L)}));
        this.client.addPreviousTasksAndOffsetSums("c2", Collections.singletonMap(AssignmentTestUtils.TASK_0_2, 0L));
        MatcherAssert.assertThat((Object)this.client.prevOwnedStatefulTasksByConsumer("c1"), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)this.client.prevOwnedStatefulTasksByConsumer("c2"), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)this.client.prevOwnedActiveTasksByConsumer(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", Collections.singleton(AssignmentTestUtils.TASK_0_1)), Utils.mkEntry((Object)"c2", Collections.singleton(AssignmentTestUtils.TASK_0_2))})));
        MatcherAssert.assertThat((Object)this.client.prevOwnedStandbyByConsumer(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", Collections.singleton(AssignmentTestUtils.TASK_0_0)), Utils.mkEntry((Object)"c2", Collections.emptySet())})));
    }

    @Test
    public void shouldReturnAssignedTasksForConsumer() {
        ArrayList<TaskId> allTasks = new ArrayList<TaskId>(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2));
        this.client.assignActiveTasks(allTasks);
        this.client.assignActiveToConsumer(AssignmentTestUtils.TASK_0_0, "c1");
        this.client.assignActiveToConsumer(AssignmentTestUtils.TASK_0_0, "c1");
        this.client.assignActiveToConsumer(AssignmentTestUtils.TASK_0_1, "c1");
        this.client.assignActiveToConsumer(AssignmentTestUtils.TASK_0_2, "c2");
        this.client.assignStandbyToConsumer(AssignmentTestUtils.TASK_0_2, "c1");
        this.client.assignStandbyToConsumer(AssignmentTestUtils.TASK_0_0, "c2");
        this.client.assignStandbyToConsumer(AssignmentTestUtils.TASK_0_0, "c2");
        this.client.revokeActiveFromConsumer(AssignmentTestUtils.TASK_0_1, "c1");
        this.client.revokeActiveFromConsumer(AssignmentTestUtils.TASK_0_1, "c1");
        MatcherAssert.assertThat((Object)this.client.assignedActiveTasksByConsumer(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", (Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})), Utils.mkEntry((Object)"c2", (Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}))})));
        MatcherAssert.assertThat((Object)this.client.assignedStandbyTasksByConsumer(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"c1", (Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})), Utils.mkEntry((Object)"c2", (Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}))})));
        MatcherAssert.assertThat((Object)this.client.revokingActiveTasksByConsumer(), (Matcher)CoreMatchers.equalTo(Collections.singletonMap("c1", Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}))));
    }

    @Test
    public void shouldAddTasksInOffsetSumsMapToPrevStandbyTasks() {
        Map taskOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)0L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)100L)});
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.initializePrevTasks(Collections.emptyMap(), false);
        MatcherAssert.assertThat((Object)this.client.prevStandbyTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)this.client.previousAssignedTasks(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        Assert.assertTrue((boolean)this.client.prevActiveTasks().isEmpty());
    }

    @Test
    public void shouldComputeTaskLags() {
        Map taskOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)0L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)100L)});
        Map allTaskEndOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)500L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)100L)});
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_1), (Matcher)CoreMatchers.equalTo((Object)500L));
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_2), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotTryToLookupTasksThatWerePreviouslyAssignedButNoLongerExist() {
        Map clientReportedTaskEndOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_0, (Object)500L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T1_0_0, (Object)500L)});
        Map<TaskId, Long> allTaskEndOffsetSumsComputedByAssignor = Collections.singletonMap(AssignmentTestUtils.NAMED_TASK_T0_0_0, 500L);
        this.client.addPreviousTasksAndOffsetSums("c1", clientReportedTaskEndOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSumsComputedByAssignor);
        Assert.assertThrows(IllegalStateException.class, () -> this.client.lagFor(AssignmentTestUtils.NAMED_TASK_T1_0_0));
        this.client.assignActive(AssignmentTestUtils.NAMED_TASK_T0_0_0);
        MatcherAssert.assertThat((Object)this.client.prevTasksByLag("c1"), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.NAMED_TASK_T0_0_0})));
    }

    @Test
    public void shouldReturnEndOffsetSumForLagOfTaskWeDidNotPreviouslyOwn() {
        Map taskOffsetSums = Collections.emptyMap();
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 500L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_1), (Matcher)CoreMatchers.equalTo((Object)500L));
    }

    @Test
    public void shouldReturnLatestOffsetForLagOfPreviousActiveRunningTask() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, -2L);
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 500L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_1), (Matcher)CoreMatchers.equalTo((Object)-2L));
    }

    @Test
    public void shouldReturnUnknownOffsetSumForLagOfTaskWithUnknownOffset() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, -3L);
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 500L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_1), (Matcher)CoreMatchers.equalTo((Object)-3L));
    }

    @Test
    public void shouldReturnEndOffsetSumIfOffsetSumIsGreaterThanEndOffsetSum() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 5L);
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 1L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        MatcherAssert.assertThat((Object)this.client.lagFor(AssignmentTestUtils.TASK_0_1), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfTaskLagsMapIsNotEmpty() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 5L);
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 1L);
        this.client.computeTaskLags(null, taskOffsetSums);
        Assert.assertThrows(IllegalStateException.class, () -> this.client.computeTaskLags(null, allTaskEndOffsetSums));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnLagForUnknownTask() {
        Map<TaskId, Long> taskOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 0L);
        Map<TaskId, Long> allTaskEndOffsetSums = Collections.singletonMap(AssignmentTestUtils.TASK_0_1, 500L);
        this.client.addPreviousTasksAndOffsetSums("c1", taskOffsetSums);
        this.client.computeTaskLags(null, allTaskEndOffsetSums);
        Assert.assertThrows(IllegalStateException.class, () -> this.client.lagFor(AssignmentTestUtils.TASK_0_2));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfAttemptingToInitializeNonEmptyPrevTaskSets() {
        this.client.addPreviousActiveTasks(Collections.singleton(AssignmentTestUtils.TASK_0_1));
        Assert.assertThrows(IllegalStateException.class, () -> this.client.initializePrevTasks(Collections.emptyMap(), false));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfAssignedTasksForConsumerToNonClientAssignActive() {
        Assert.assertThrows(IllegalStateException.class, () -> this.client.assignActiveToConsumer(AssignmentTestUtils.TASK_0_0, "c1"));
    }

    @Test
    public void shouldReturnClientTags() {
        Map clientTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"k1", (Object)"v1")});
        Assert.assertEquals((Object)clientTags, (Object)new ClientState(null, 0, clientTags).clientTags());
    }

    @Test
    public void shouldReturnEmptyClientTagsMapByDefault() {
        Assert.assertTrue((boolean)new ClientState().clientTags().isEmpty());
    }

    @Test
    public void shouldSetProcessId() {
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)new ClientState(AssignmentTestUtils.UUID_1, 1).processId());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_2, (Object)new ClientState(AssignmentTestUtils.UUID_2, Utils.mkMap((Map.Entry[])new Map.Entry[0])).processId());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_3, (Object)new ClientState(AssignmentTestUtils.UUID_3, 1, Utils.mkMap((Map.Entry[])new Map.Entry[0])).processId());
        Assert.assertNull((Object)new ClientState().processId());
    }

    @Test
    public void shouldCopyState() {
        ClientState clientState = new ClientState(Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 0)}), Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 1)}), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.uuidForInt(1));
        ClientState clientStateCopy = new ClientState(clientState);
        Assert.assertEquals((Object)clientStateCopy.processId(), (Object)clientState.processId());
        Assert.assertEquals((long)clientStateCopy.capacity(), (long)clientState.capacity());
        Assert.assertEquals((Object)clientStateCopy.prevActiveTasks(), (Object)clientStateCopy.prevActiveTasks());
        Assert.assertEquals((Object)clientStateCopy.prevStandbyTasks(), (Object)clientStateCopy.prevStandbyTasks());
        MatcherAssert.assertThat((Object)clientStateCopy.prevActiveTasks(), (Matcher)CoreMatchers.equalTo((Object)clientState.prevActiveTasks()));
        MatcherAssert.assertThat((Object)clientStateCopy.prevStandbyTasks(), (Matcher)CoreMatchers.equalTo((Object)clientState.prevStandbyTasks()));
    }
}

