/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.BufferValue;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.rocksdb.WriteBatch;

class RocksDBTimeOrderedKeyValueBytesStoreTest {
    private InternalMockProcessorContext context;
    private RocksDBTimeOrderedKeyValueBytesStore bytesStore;
    private File stateDir;
    final String storeName = "bytes-store";
    private static final String METRICS_SCOPE = "metrics-scope";
    private final String topic = "changelog";

    RocksDBTimeOrderedKeyValueBytesStoreTest() {
    }

    @BeforeEach
    public void before() {
        this.bytesStore = new RocksDBTimeOrderedKeyValueBytesStore("bytes-store", METRICS_SCOPE);
        this.stateDir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDir, Serdes.String(), Serdes.Long(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.bytesStore.init((StateStoreContext)this.context, (StateStore)this.bytesStore);
    }

    @AfterEach
    public void close() {
        this.bytesStore.close();
    }

    @Test
    public void shouldCreateWriteBatches() {
        String key = "a";
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey("a", 0, 0L).get(), (Object)this.serializeValue(50L)));
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey("a", 1, 1L).get(), (Object)this.serializeValue(100L)));
        Map writeBatchMap = this.bytesStore.getWriteBatches(records);
        Assertions.assertEquals((int)1, (int)writeBatchMap.size());
        for (WriteBatch batch : writeBatchMap.values()) {
            Assertions.assertEquals((int)2, (int)batch.count());
        }
    }

    @Test
    public void shouldCreateEmptyWriteBatches() {
        ArrayList records = new ArrayList();
        Map writeBatchMap = this.bytesStore.getWriteBatches(records);
        Assertions.assertEquals((int)0, (int)writeBatchMap.size());
    }

    private byte[] serializeValue(Long value) {
        Serdes.LongSerde valueSerde = new Serdes.LongSerde();
        byte[] valueBytes = valueSerde.serializer().serialize("changelog", (Object)value);
        BufferValue buffered = new BufferValue(null, null, valueBytes, new ProcessorRecordContext(0L, 0L, 0, "changelog", (Headers)new RecordHeaders()));
        return buffered.serialize(0).array();
    }

    private Bytes serializeKey(String key, int seqnum, long timestamp) {
        Serdes.StringSerde keySerde = new Serdes.StringSerde();
        return Bytes.wrap((byte[])PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary((byte[])keySerde.serializer().serialize("changelog", (Object)key), (long)timestamp, (int)seqnum).get());
    }
}

