/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.CommitCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public abstract class AbstractProcessorContext<KOut, VOut>
implements InternalProcessorContext<KOut, VOut> {
    private final TaskId taskId;
    private final String applicationId;
    private final StreamsConfig config;
    private final StreamsMetricsImpl metrics;
    private final Serde<?> keySerde;
    private final Serde<?> valueSerde;
    private boolean initialized;
    protected ProcessorRecordContext recordContext;
    protected ProcessorNode<?, ?, ?, ?> currentNode;
    private long cachedSystemTimeMs;
    protected ThreadCache cache;
    private ProcessorMetadata processorMetadata;

    public AbstractProcessorContext(TaskId taskId, StreamsConfig config, StreamsMetricsImpl metrics, ThreadCache cache) {
        this.taskId = taskId;
        this.applicationId = config.getString("application.id");
        this.config = config;
        this.metrics = metrics;
        this.valueSerde = null;
        this.keySerde = null;
        this.cache = cache;
        this.processorMetadata = new ProcessorMetadata();
    }

    protected abstract StateManager stateManager();

    @Override
    public void setSystemTimeMs(long timeMs) {
        this.cachedSystemTimeMs = timeMs;
    }

    @Override
    public long currentSystemTimeMs() {
        return this.cachedSystemTimeMs;
    }

    @Override
    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public TaskId taskId() {
        return this.taskId;
    }

    @Override
    public Serde<?> keySerde() {
        if (this.keySerde == null) {
            return this.config.defaultKeySerde();
        }
        return this.keySerde;
    }

    @Override
    public Serde<?> valueSerde() {
        if (this.valueSerde == null) {
            return this.config.defaultValueSerde();
        }
        return this.valueSerde;
    }

    @Override
    public File stateDir() {
        return this.stateManager().baseDir();
    }

    @Override
    public StreamsMetricsImpl metrics() {
        return this.metrics;
    }

    @Override
    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.register(store, stateRestoreCallback, () -> {});
    }

    @Override
    public void register(StateStore store, StateRestoreCallback stateRestoreCallback, CommitCallback checkpoint) {
        if (this.initialized) {
            throw new IllegalStateException("Can only create state stores during initialization.");
        }
        Objects.requireNonNull(store, "store must not be null");
        this.stateManager().registerStore(store, stateRestoreCallback, checkpoint);
    }

    @Override
    public String topic() {
        if (this.recordContext == null) {
            return null;
        }
        return this.recordContext.topic();
    }

    @Override
    public int partition() {
        if (this.recordContext == null) {
            return -1;
        }
        return this.recordContext.partition();
    }

    @Override
    public long offset() {
        if (this.recordContext == null) {
            return -1L;
        }
        return this.recordContext.offset();
    }

    @Override
    public Headers headers() {
        if (this.recordContext == null) {
            return new RecordHeaders();
        }
        return this.recordContext.headers();
    }

    @Override
    public long timestamp() {
        if (this.recordContext == null) {
            return 0L;
        }
        return this.recordContext.timestamp();
    }

    @Override
    public Map<String, Object> appConfigs() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        combined.putAll(this.config.originals());
        combined.putAll(this.config.values());
        return combined;
    }

    @Override
    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    @Override
    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.recordContext = recordContext;
    }

    @Override
    public ProcessorRecordContext recordContext() {
        return this.recordContext;
    }

    @Override
    public Optional<RecordMetadata> recordMetadata() {
        return Optional.ofNullable(this.recordContext);
    }

    @Override
    public void setCurrentNode(ProcessorNode<?, ?, ?, ?> currentNode) {
        this.currentNode = currentNode;
    }

    @Override
    public ProcessorNode<?, ?, ?, ?> currentNode() {
        return this.currentNode;
    }

    @Override
    public ThreadCache cache() {
        return this.cache;
    }

    @Override
    public void initialize() {
        this.initialized = true;
    }

    @Override
    public void uninitialize() {
        this.initialized = false;
    }

    @Override
    public Task.TaskType taskType() {
        return this.stateManager().taskType();
    }

    @Override
    public String changelogFor(String storeName) {
        return this.stateManager().changelogFor(storeName);
    }

    @Override
    public void addProcessorMetadataKeyValue(String key, long value) {
        this.processorMetadata.put(key, value);
    }

    @Override
    public Long processorMetadataForKey(String key) {
        return this.processorMetadata.get(key);
    }

    @Override
    public void setProcessorMetadata(ProcessorMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.processorMetadata = metadata;
    }

    @Override
    public ProcessorMetadata getProcessorMetadata() {
        return this.processorMetadata;
    }
}

