/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionWindowedDeserializerTest {
    private final SessionWindowedDeserializer<?> sessionWindowedDeserializer = new SessionWindowedDeserializer((Deserializer)new StringDeserializer());
    private final Map<String, String> props = new HashMap<String, String>();

    @Test
    public void testSessionWindowedDeserializerConstructor() {
        this.sessionWindowedDeserializer.configure(this.props, true);
        Deserializer inner = this.sessionWindowedDeserializer.innerDeserializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner deserializer should be not null");
        Assertions.assertInstanceOf(StringDeserializer.class, (Object)inner, (String)"Inner deserializer type should be StringDeserializer");
    }

    @Test
    public void shouldSetWindowedInnerClassDeserialiserThroughConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        SessionWindowedDeserializer deserializer = new SessionWindowedDeserializer();
        deserializer.configure(this.props, false);
        Assertions.assertInstanceOf(ByteArrayDeserializer.class, (Object)deserializer.innerDeserializer());
    }

    @Test
    public void shouldThrowErrorIfWindowInnerClassDeserialiserIsNotSet() {
        SessionWindowedDeserializer deserializer = new SessionWindowedDeserializer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> deserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfDeserialisersConflictInConstructorAndConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.sessionWindowedDeserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowConfigExceptionWhenInvalidWindowInnerClassDeserialiserSupplied() {
        this.props.put("windowed.inner.class.serde", "some.non.existent.class");
        Assertions.assertThrows(ConfigException.class, () -> this.sessionWindowedDeserializer.configure(this.props, false));
    }
}

