/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.LegacyStickyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class LegacyStickyTaskAssignorTest {
    private final List<Integer> expectedTopicGroupIds = Arrays.asList(1, 2);
    private final Time time = new MockTime();
    private final Map<ProcessId, ClientState> clients = new TreeMap<ProcessId, ClientState>();
    private boolean enableRackAwareTaskAssignor;
    @Parameterized.Parameter
    public String rackAwareStrategy;

    @Before
    public void setUp() {
        this.enableRackAwareTaskAssignor = !this.rackAwareStrategy.equals("none");
    }

    @Parameterized.Parameters(name="rackAwareStrategy={0}")
    public static Collection<Object[]> getParamStoreType() {
        return Arrays.asList({"none"}, {"min_traffic"}, {"balance_subtopology"});
    }

    @Test
    public void shouldAssignOneActiveTaskToEachProcessWhenTaskCountSameAsProcessCount() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        for (ClientState clientState : this.clients.values()) {
            MatcherAssert.assertThat((Object)clientState.activeTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithNoStandByTasks() {
        this.createClient(AssignmentTestUtils.PID_1, 2);
        this.createClient(AssignmentTestUtils.PID_2, 2);
        this.createClient(AssignmentTestUtils.PID_3, 2);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed();
    }

    @Test
    public void shouldAssignTopicGroupIdEvenlyAcrossClientsWithStandByTasks() {
        this.createClient(AssignmentTestUtils.PID_1, 2);
        this.createClient(AssignmentTestUtils.PID_2, 2);
        this.createClient(AssignmentTestUtils.PID_3, 2);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        this.assertActiveTaskTopicGroupIdsEvenlyDistributed();
    }

    @Test
    public void shouldNotMigrateActiveTaskToOtherProcess() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_1);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
        this.clients.clear();
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
    }

    @Test
    public void shouldMigrateActiveTasksToNewProcessWithoutChangingAllAssignments() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).activeTasks().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
    }

    @Test
    public void shouldAssignBasedOnCapacity() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 2);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAssignTasksEvenlyWithUnequalTopicGroupSizes() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5, AssignmentTestUtils.TASK_1_0);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5), (Matcher)Matchers.is((Object)false));
        HashSet<TaskId> allTasks = new HashSet<TaskId>(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_5, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4));
        Set client1Tasks = this.clients.get(AssignmentTestUtils.PID_1).activeTasks();
        Set client2Tasks = this.clients.get(AssignmentTestUtils.PID_2).activeTasks();
        MatcherAssert.assertThat((Object)(client1Tasks.size() == 3 && client2Tasks.size() == 4 || client1Tasks.size() == 4 && client2Tasks.size() == 3 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        allTasks.removeAll(client1Tasks);
        MatcherAssert.assertThat((Object)client2Tasks, (Matcher)Matchers.equalTo(allTasks));
    }

    @Test
    public void shouldKeepActiveTaskStickinessWhenMoreClientThanActiveTasks() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        this.createClient(AssignmentTestUtils.PID_5, 1);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        this.clients.clear();
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_0);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_4, 1, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_5, 1, AssignmentTestUtils.TASK_0_1);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_4).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_5).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
    }

    @Test
    public void shouldAssignTasksToClientWithPreviousStandbyTasks() {
        ClientState client1 = this.createClient(AssignmentTestUtils.PID_1, 1);
        client1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2}));
        ClientState client2 = this.createClient(AssignmentTestUtils.PID_2, 1);
        client2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        ClientState client3 = this.createClient(AssignmentTestUtils.PID_3, 1);
        client3.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}));
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_1)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
    }

    @Test
    public void shouldAssignBasedOnCapacityWhenMultipleClientHaveStandbyTasks() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 2, AssignmentTestUtils.TASK_0_2);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}));
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.equalTo(Collections.singleton(AssignmentTestUtils.TASK_0_0)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1})));
    }

    @Test
    public void shouldAssignStandbyTasksToDifferentClientThanCorrespondingActiveTaskIsAssignedTo() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_4, 1, AssignmentTestUtils.TASK_0_3);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).standbyTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).standbyTasks().size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).standbyTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).standbyTasks().size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).standbyTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).standbyTasks().size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_4).standbyTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_4).standbyTasks().size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2)));
        int nonEmptyStandbyTaskCount = 0;
        for (ClientState clientState : this.clients.values()) {
            nonEmptyStandbyTaskCount += clientState.standbyTasks().isEmpty() ? 0 : 1;
        }
        MatcherAssert.assertThat((Object)nonEmptyStandbyTaskCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
        MatcherAssert.assertThat(this.allStandbyTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3)));
    }

    @Test
    public void shouldAssignMultipleReplicasOfStandbyTask() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_2);
        boolean probingRebalanceNeeded = this.assign(2, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
    }

    @Test
    public void shouldNotAssignStandbyTaskReplicasWhenNoClientAvailableWithoutHavingTheTaskAssigned() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).standbyTasks().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldAssignActiveAndStandbyTasks() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
        MatcherAssert.assertThat(this.allStandbyTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
    }

    @Test
    public void shouldAssignAtLeastOneTaskToEachClientIfPossible() {
        this.createClient(AssignmentTestUtils.PID_1, 3);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldAssignEachActiveTaskToOneClientWhenMoreClientsThanTasks() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        this.createClient(AssignmentTestUtils.PID_5, 1);
        this.createClient(AssignmentTestUtils.PID_6, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(this.allActiveTasks(), (Matcher)Matchers.equalTo(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2)));
    }

    @Test
    public void shouldBalanceActiveAndStandbyTasksAcrossAvailableClients() {
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        this.createClient(AssignmentTestUtils.PID_5, 1);
        this.createClient(AssignmentTestUtils.PID_6, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        for (ClientState clientState : this.clients.values()) {
            MatcherAssert.assertThat((Object)clientState.assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    public void shouldAssignMoreTasksToClientWithMoreCapacity() {
        this.createClient(AssignmentTestUtils.PID_2, 2);
        this.createClient(AssignmentTestUtils.PID_1, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_2, AssignmentTestUtils.TASK_3_0, AssignmentTestUtils.TASK_3_1, AssignmentTestUtils.TASK_3_2);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void shouldEvenlyDistributeByTaskIdAndPartition() {
        this.createClient(AssignmentTestUtils.PID_1, 4);
        this.createClient(AssignmentTestUtils.PID_2, 4);
        this.createClient(AssignmentTestUtils.PID_3, 4);
        this.createClient(AssignmentTestUtils.PID_4, 4);
        ArrayList<TaskId> taskIds = new ArrayList<TaskId>();
        TaskId[] taskIdArray = new TaskId[16];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 8; ++j) {
                taskIds.add(new TaskId(i, j));
            }
        }
        Collections.shuffle(taskIds);
        taskIds.toArray(taskIdArray);
        int nodeSize = 5;
        int topicSize = 2;
        int partitionSize = 8;
        int clientSize = 4;
        Cluster cluster = AssignmentTestUtils.getRandomCluster(5, 2, 8);
        SortedMap<TaskId, Set<TopicPartition>> partitionsForTask = AssignmentTestUtils.getTaskTopicPartitionMap(2, 8, false);
        SortedMap<TaskId, Set<TopicPartition>> changelogPartitionsForTask = AssignmentTestUtils.getTaskTopicPartitionMap(2, 8, true);
        Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer = AssignmentTestUtils.getRandomProcessRacks(4, 5);
        InternalTopicManager internalTopicManager = AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(5, 2, 8);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = new RackAwareTaskAssignor(cluster, partitionsForTask, changelogPartitionsForTask, AssignmentTestUtils.getTasksForTopicGroup(2, 8), racksForProcessConsumer, internalTopicManager, configs, this.time);
        boolean probingRebalanceNeeded = this.assign(configs, rackAwareTaskAssignor, taskIdArray);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        Collections.sort(taskIds);
        Set<TaskId> expectedClientOneAssignment = LegacyStickyTaskAssignorTest.getExpectedTaskIdAssignment(taskIds, 0, 4, 8, 12);
        Set<TaskId> expectedClientTwoAssignment = LegacyStickyTaskAssignorTest.getExpectedTaskIdAssignment(taskIds, 1, 5, 9, 13);
        Set<TaskId> expectedClientThreeAssignment = LegacyStickyTaskAssignorTest.getExpectedTaskIdAssignment(taskIds, 2, 6, 10, 14);
        Set<TaskId> expectedClientFourAssignment = LegacyStickyTaskAssignorTest.getExpectedTaskIdAssignment(taskIds, 3, 7, 11, 15);
        Map<ProcessId, Set<TaskId>> sortedAssignments = LegacyStickyTaskAssignorTest.sortClientAssignments(this.clients);
        MatcherAssert.assertThat(sortedAssignments.get(AssignmentTestUtils.PID_1), (Matcher)Matchers.equalTo(expectedClientOneAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(AssignmentTestUtils.PID_2), (Matcher)Matchers.equalTo(expectedClientTwoAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(AssignmentTestUtils.PID_3), (Matcher)Matchers.equalTo(expectedClientThreeAssignment));
        MatcherAssert.assertThat(sortedAssignments.get(AssignmentTestUtils.PID_4), (Matcher)Matchers.equalTo(expectedClientFourAssignment));
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHosts() {
        List<ProcessId> allProcessIds = Arrays.asList(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_4);
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        for (ProcessId uuid : allProcessIds) {
            Set taskIds = this.clients.get(uuid).assignedTasks();
            for (ProcessId otherProcessId : allProcessIds) {
                if (uuid.equals((Object)otherProcessId)) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(otherProcessId).assignedTasks(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHostsWhenThereArePreviousActiveTasks() {
        List<ProcessId> allProcessIds = Arrays.asList(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_3);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_0);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        for (ProcessId uuid : allProcessIds) {
            Set taskIds = this.clients.get(uuid).assignedTasks();
            for (ProcessId otherProcessId : allProcessIds) {
                if (uuid.equals((Object)otherProcessId)) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(otherProcessId).assignedTasks(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldNotHaveSameAssignmentOnAnyTwoHostsWhenThereArePreviousStandbyTasks() {
        List<ProcessId> allProcessIds = Arrays.asList(AssignmentTestUtils.PID_1, AssignmentTestUtils.PID_2, AssignmentTestUtils.PID_3, AssignmentTestUtils.PID_4);
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_0}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_0);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}));
        this.createClient(AssignmentTestUtils.PID_3, 1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        boolean probingRebalanceNeeded = this.assign(1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        for (ProcessId uuid : allProcessIds) {
            Set taskIds = this.clients.get(uuid).assignedTasks();
            for (ProcessId otherProcessId : allProcessIds) {
                if (uuid.equals((Object)otherProcessId)) continue;
                MatcherAssert.assertThat((String)"clients shouldn't have same task assignment", (Object)this.clients.get(otherProcessId).assignedTasks(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)taskIds)));
            }
        }
    }

    @Test
    public void shouldReBalanceTasksAcrossAllClientsWhenCapacityAndTaskCountTheSame() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        this.createClient(AssignmentTestUtils.PID_4, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_4).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldReBalanceTasksAcrossClientsWhenCapacityLessThanTaskCount() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        this.createClient(AssignmentTestUtils.PID_1, 1);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldRebalanceTasksToClientsBasedOnCapacity() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_2);
        this.createClient(AssignmentTestUtils.PID_3, 2);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).assignedTaskCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldMoveMinimalNumberOfTasksWhenPreviouslyAboveCapacityAndNewClientAdded() {
        Set p1PrevTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2});
        Set p2PrevTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3});
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, new TaskId[0]);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        Set p3ActiveTasks = this.clients.get(AssignmentTestUtils.PID_3).activeTasks();
        MatcherAssert.assertThat((Object)p3ActiveTasks.size(), (Matcher)Matchers.equalTo((Object)1));
        if (p1PrevTasks.removeAll(p3ActiveTasks)) {
            MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.equalTo((Object)p2PrevTasks));
        } else {
            MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.equalTo((Object)p1PrevTasks));
        }
    }

    @Test
    public void shouldNotMoveAnyTasksWhenNewTasksAdded() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_5);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1}));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3}));
    }

    @Test
    public void shouldAssignNewTasksToNewClientWhenPreviousTasksAssignedToOldClients() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1);
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_3);
        this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_5);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_1}));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_2).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_3}));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_3).activeTasks(), (Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5}));
    }

    @Test
    public void shouldAssignTasksNotPreviouslyActiveToNewClient() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_3}));
        ClientState c3 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3);
        c3.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2}));
        ClientState newClient = this.createClient(AssignmentTestUtils.PID_4, 1);
        newClient.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_2, AssignmentTestUtils.TASK_2_3}));
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_2, AssignmentTestUtils.TASK_2_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        if (this.rackAwareStrategy.equals("balance_subtopology")) {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_3})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2})));
            MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_1})));
            MatcherAssert.assertThat((Object)newClient.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_2_0})));
        } else {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2})));
            MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3})));
            MatcherAssert.assertThat((Object)newClient.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0})));
        }
    }

    @Test
    public void shouldAssignTasksNotPreviouslyActiveToMultipleNewClients() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3);
        c1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3}));
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_3}));
        ClientState bounce1 = this.createClient(AssignmentTestUtils.PID_3, 1);
        bounce1.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3}));
        ClientState bounce2 = this.createClient(AssignmentTestUtils.PID_4, 1);
        bounce2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0}));
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_2, AssignmentTestUtils.TASK_2_3);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        if (this.rackAwareStrategy.equals("balance_subtopology")) {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_2_3})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2})));
            MatcherAssert.assertThat((Object)bounce1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_3, AssignmentTestUtils.TASK_2_1})));
            MatcherAssert.assertThat((Object)bounce2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_2_0})));
        } else {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_2})));
            MatcherAssert.assertThat((Object)bounce1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_2_0, AssignmentTestUtils.TASK_2_1, AssignmentTestUtils.TASK_2_3})));
            MatcherAssert.assertThat((Object)bounce2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0})));
        }
    }

    @Test
    public void shouldAssignTasksToNewClient() {
        this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        this.createClient(AssignmentTestUtils.PID_2, 1);
        MatcherAssert.assertThat((Object)this.assign(AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.clients.get(AssignmentTestUtils.PID_1).activeTaskCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldAssignTasksToNewClientWithoutFlippingAssignmentBetweenExistingClients() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5);
        ClientState newClient = this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_3)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_4)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_5)));
        MatcherAssert.assertThat((Object)c1.activeTaskCount(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)c2.activeTaskCount(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)newClient.activeTaskCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAssignTasksToNewClientWithoutFlippingAssignmentBetweenExistingAndBouncedClients() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_6);
        ClientState c2 = this.createClient(AssignmentTestUtils.PID_2, 1);
        c2.addPreviousStandbyTasks(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5}));
        ClientState newClient = this.createClient(AssignmentTestUtils.PID_3, 1);
        boolean probingRebalanceNeeded = this.assign(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5, AssignmentTestUtils.TASK_0_6);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_3)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_4)));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)AssignmentTestUtils.TASK_0_5)));
        MatcherAssert.assertThat((Object)c1.activeTaskCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)c2.activeTaskCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)newClient.activeTaskCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldViolateBalanceToPreserveActiveTaskStickiness() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        ClientState c2 = this.createClient(AssignmentTestUtils.PID_2, 1);
        List<TaskId> taskIds = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        Collections.shuffle(taskIds);
        int nodeSize = 5;
        boolean topicSize = true;
        int partitionSize = 3;
        int clientSize = 2;
        Cluster cluster = AssignmentTestUtils.getRandomCluster(5, 1, 3);
        SortedMap<TaskId, Set<TopicPartition>> partitionsForTask = AssignmentTestUtils.getTaskTopicPartitionMap(1, 3, false);
        SortedMap<TaskId, Set<TopicPartition>> changelogPartitionsForTask = AssignmentTestUtils.getTaskTopicPartitionMap(1, 3, true);
        HashMap tasksForTopicGroup = new HashMap();
        Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer = AssignmentTestUtils.getRandomProcessRacks(2, 5);
        InternalTopicManager internalTopicManager = AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(5, 1, 3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = new RackAwareTaskAssignor(cluster, partitionsForTask, changelogPartitionsForTask, AssignmentTestUtils.getTasksForTopicGroup(), racksForProcessConsumer, internalTopicManager, configs, this.time);
        boolean probingRebalanceNeeded = new LegacyStickyTaskAssignor(true).assign(this.clients, new HashSet<TaskId>(taskIds), new HashSet<TaskId>(taskIds), rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldOptimizeStatefulAndStatelessTaskTraffic() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        ClientState c2 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_2, 1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_3);
        ClientState c3 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.PID_3, 1, AssignmentTestUtils.TASK_1_2);
        List<TaskId> taskIds = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2, AssignmentTestUtils.TASK_1_3);
        List<TaskId> statefulTaskIds = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1);
        Collections.shuffle(taskIds);
        Cluster cluster = AssignmentTestUtils.getClusterForAllTopics();
        Map<TaskId, Set<TopicPartition>> partitionsForTask = AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks();
        Map<TaskId, Set<TopicPartition>> changelogPartitionsForTask = AssignmentTestUtils.getTaskChangelogMapForAllTasks();
        Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer = AssignmentTestUtils.getProcessRacksForAllProcess();
        InternalTopicManager internalTopicManager = AssignmentTestUtils.mockInternalTopicManagerForChangelog();
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 10, 1, this.rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = new RackAwareTaskAssignor(cluster, partitionsForTask, changelogPartitionsForTask, AssignmentTestUtils.getTasksForTopicGroup(), racksForProcessConsumer, internalTopicManager, configs, this.time);
        boolean probingRebalanceNeeded = new LegacyStickyTaskAssignor().assign(this.clients, new HashSet<TaskId>(taskIds), new HashSet<TaskId>(statefulTaskIds), rackAwareTaskAssignor, configs);
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)false));
        if (this.rackAwareStrategy.equals("min_traffic")) {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_2})));
            MatcherAssert.assertThat((Object)c1.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1})));
            MatcherAssert.assertThat((Object)c2.standbyTasks(), (Matcher)Matchers.empty());
            MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_3})));
            MatcherAssert.assertThat((Object)c3.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1})));
        } else if (this.rackAwareStrategy.equals("balance_subtopology")) {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_2})));
            MatcherAssert.assertThat((Object)c1.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1})));
            MatcherAssert.assertThat((Object)c2.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
            MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_3})));
            MatcherAssert.assertThat((Object)c3.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1})));
        } else {
            MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_3})));
            MatcherAssert.assertThat((Object)c1.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
            MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1})));
            MatcherAssert.assertThat((Object)c2.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
            MatcherAssert.assertThat((Object)c3.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_2})));
            MatcherAssert.assertThat((Object)c3.standbyTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1})));
        }
    }

    @Test
    public void shouldAssignRandomInput() {
        int nodeSize = 50;
        int tpSize = 60;
        int partitionSize = 3;
        int clientSize = 50;
        boolean replicaCount = true;
        int maxCapacity = 3;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, false);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 10, 1, this.rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(AssignmentTestUtils.getRandomCluster(50, 60, 3), taskTopicPartitionMap, AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, true), AssignmentTestUtils.getTasksForTopicGroup(60, 3), AssignmentTestUtils.getRandomProcessRacks(50, 50), AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(50, 60, 3), configs, this.time));
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        List<Set<TaskId>> statefulAndStatelessTasks = AssignmentTestUtils.getRandomSubset(taskIds, 2);
        Set<TaskId> statefulTasks = statefulAndStatelessTasks.get(0);
        Set<TaskId> statelessTasks = statefulAndStatelessTasks.get(1);
        SortedMap<ProcessId, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(50, 60, 3, 3, false, statefulTasks);
        boolean probing = new LegacyStickyTaskAssignor().assign(clientStateMap, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, configs);
        Assert.assertFalse((boolean)probing);
        AssignmentTestUtils.assertValidAssignment(1, statefulTasks, statelessTasks, clientStateMap, new StringBuilder());
        AssignmentTestUtils.verifyTaskPlacementWithRackAwareAssignor(rackAwareTaskAssignor, taskIds, clientStateMap, true, this.enableRackAwareTaskAssignor);
        if (this.rackAwareStrategy.equals("balance_subtopology")) {
            AssignmentTestUtils.assertBalancedTasks(clientStateMap, 4);
        }
    }

    @Test
    public void shouldRemainOriginalAssignmentWithoutTrafficCostForMinCostStrategy() {
        int nodeSize = 50;
        int tpSize = 60;
        int partitionSize = 3;
        int clientSize = 50;
        boolean replicaCount = true;
        int maxCapacity = 3;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, false);
        Cluster cluster = AssignmentTestUtils.getRandomCluster(50, 60, 3);
        SortedMap<TaskId, Set<TopicPartition>> taskChangelogTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, true);
        Map<ProcessId, Map<String, Optional<String>>> processRackMap = AssignmentTestUtils.getRandomProcessRacks(50, 50);
        InternalTopicManager mockInternalTopicManager = AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(50, 60, 3);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 0, 10, this.rackAwareStrategy);
        RackAwareTaskAssignor rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(cluster, taskTopicPartitionMap, taskChangelogTopicPartitionMap, AssignmentTestUtils.getTasksForTopicGroup(60, 3), processRackMap, mockInternalTopicManager, configs, this.time));
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        List<Set<TaskId>> statefulAndStatelessTasks = AssignmentTestUtils.getRandomSubset(taskIds, 2);
        Set<TaskId> statefulTasks = statefulAndStatelessTasks.get(0);
        Set<TaskId> statelessTasks = statefulAndStatelessTasks.get(1);
        SortedMap<ProcessId, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(50, 60, 3, 3, false, statefulTasks);
        new LegacyStickyTaskAssignor().assign(clientStateMap, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, configs);
        AssignmentTestUtils.assertValidAssignment(1, statefulTasks, statelessTasks, clientStateMap, new StringBuilder());
        if (this.rackAwareStrategy.equals("none")) {
            return;
        }
        if (this.rackAwareStrategy.equals("balance_subtopology")) {
            AssignmentTestUtils.assertBalancedTasks(clientStateMap, 4);
            return;
        }
        SortedMap<ProcessId, ClientState> clientStateMapCopy = AssignmentTestUtils.copyClientStateMap(clientStateMap);
        configs = new AssignmentConfigs(0L, 1, 1, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, 0, 10, "none");
        rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(cluster, taskTopicPartitionMap, taskChangelogTopicPartitionMap, AssignmentTestUtils.getTasksForTopicGroup(60, 3), processRackMap, mockInternalTopicManager, configs, this.time));
        new LegacyStickyTaskAssignor().assign(clientStateMapCopy, (Set)taskIds, statefulTasks, rackAwareTaskAssignor, configs);
        for (Map.Entry<ProcessId, ClientState> entry : clientStateMap.entrySet()) {
            MatcherAssert.assertThat((Object)entry.getValue().statefulActiveTasks(), (Matcher)Matchers.equalTo((Object)((ClientState)clientStateMapCopy.get(entry.getKey())).statefulActiveTasks()));
            MatcherAssert.assertThat((Object)entry.getValue().standbyTasks(), (Matcher)Matchers.equalTo((Object)((ClientState)clientStateMapCopy.get(entry.getKey())).standbyTasks()));
        }
    }

    private boolean assign(TaskId ... tasks) {
        return this.assign(0, tasks);
    }

    private boolean assign(int numStandbys, TaskId ... tasks) {
        List<TaskId> taskIds = Arrays.asList(tasks);
        Collections.shuffle(taskIds);
        AssignmentConfigs configs = new AssignmentConfigs(0L, 1, numStandbys, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        return this.assign(configs, AssignmentTestUtils.getRackAwareTaskAssignor(configs, AssignmentTestUtils.getTasksForTopicGroup()), tasks);
    }

    private boolean assign(AssignmentConfigs configs, RackAwareTaskAssignor rackAwareTaskAssignor, TaskId ... tasks) {
        List<TaskId> taskIds = Arrays.asList(tasks);
        Collections.shuffle(taskIds);
        return new LegacyStickyTaskAssignor().assign(this.clients, new HashSet<TaskId>(taskIds), new HashSet<TaskId>(taskIds), rackAwareTaskAssignor, configs);
    }

    private List<TaskId> allActiveTasks() {
        ArrayList<TaskId> allActive = new ArrayList<TaskId>();
        for (ClientState client : this.clients.values()) {
            allActive.addAll(client.activeTasks());
        }
        Collections.sort(allActive);
        return allActive;
    }

    private List<TaskId> allStandbyTasks() {
        ArrayList<TaskId> tasks = new ArrayList<TaskId>();
        for (ClientState client : this.clients.values()) {
            tasks.addAll(client.standbyTasks());
        }
        Collections.sort(tasks);
        return tasks;
    }

    private ClientState createClient(ProcessId processId, int capacity) {
        return this.createClientWithPreviousActiveTasks(processId, capacity, new TaskId[0]);
    }

    private ClientState createClientWithPreviousActiveTasks(ProcessId processId, int capacity, TaskId ... taskIds) {
        ClientState clientState = new ClientState(processId, capacity);
        clientState.addPreviousActiveTasks(Utils.mkSet((Object[])taskIds));
        this.clients.put(processId, clientState);
        return clientState;
    }

    private void assertActiveTaskTopicGroupIdsEvenlyDistributed() {
        for (Map.Entry<ProcessId, ClientState> clientStateEntry : this.clients.entrySet()) {
            ArrayList<Integer> topicGroupIds = new ArrayList<Integer>();
            Set activeTasks = clientStateEntry.getValue().activeTasks();
            for (TaskId activeTask : activeTasks) {
                topicGroupIds.add(activeTask.subtopology());
            }
            Collections.sort(topicGroupIds);
            MatcherAssert.assertThat(topicGroupIds, (Matcher)Matchers.equalTo(this.expectedTopicGroupIds));
        }
    }

    private static Map<ProcessId, Set<TaskId>> sortClientAssignments(Map<ProcessId, ClientState> clients) {
        HashMap<ProcessId, Set<TaskId>> sortedAssignments = new HashMap<ProcessId, Set<TaskId>>();
        for (Map.Entry<ProcessId, ClientState> entry : clients.entrySet()) {
            TreeSet sorted = new TreeSet(entry.getValue().activeTasks());
            sortedAssignments.put(entry.getKey(), sorted);
        }
        return sortedAssignments;
    }

    private static Set<TaskId> getExpectedTaskIdAssignment(List<TaskId> tasks, int ... indices) {
        TreeSet<TaskId> sortedAssignment = new TreeSet<TaskId>();
        for (int index : indices) {
            sortedAssignment.add(tasks.get(index));
        }
        return sortedAssignment;
    }
}

