/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PositionBoundTest {
    @Test
    public void shouldCopyPosition() {
        Position position = Position.emptyPosition();
        PositionBound positionBound = PositionBound.at((Position)position);
        position.withComponent("topic", 1, 2L);
        MatcherAssert.assertThat((Object)position.getTopics(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new String[]{"topic"})));
        MatcherAssert.assertThat((Object)positionBound.position().getTopics(), (Matcher)Matchers.empty());
    }

    @Test
    public void unboundedShouldBeUnbounded() {
        PositionBound bound = PositionBound.unbounded();
        Assertions.assertTrue((boolean)bound.isUnbounded());
    }

    @Test
    public void unboundedShouldReturnEmptyPosition() {
        PositionBound bound = PositionBound.unbounded();
        MatcherAssert.assertThat((Object)bound.position(), (Matcher)Matchers.equalTo((Object)Position.emptyPosition()));
    }

    @Test
    public void shouldEqualPosition() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        PositionBound bound2 = PositionBound.at((Position)Position.emptyPosition());
        Assertions.assertEquals((Object)bound1, (Object)bound2);
    }

    @Test
    public void shouldEqualUnbounded() {
        PositionBound bound1 = PositionBound.unbounded();
        PositionBound bound2 = PositionBound.unbounded();
        Assertions.assertEquals((Object)bound1, (Object)bound2);
    }

    @Test
    public void shouldEqualSelf() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        Assertions.assertEquals((Object)bound1, (Object)bound1);
    }

    @Test
    public void shouldNotEqualNull() {
        PositionBound bound1 = PositionBound.at((Position)Position.emptyPosition());
        Assertions.assertNotEquals((Object)bound1, null);
    }

    @Test
    public void shouldNotHash() {
        PositionBound bound = PositionBound.at((Position)Position.emptyPosition());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((PositionBound)bound).hashCode());
        HashSet set = new HashSet();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.add(bound));
        HashMap map = new HashMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(bound, 5));
    }
}

