/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBuffer;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedKeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalNewProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class RocksDBTimeOrderedKeyValueBufferTest {
    public RocksDBTimeOrderedKeyValueBuffer<String, String> buffer;
    @Mock
    public SerdeGetter serdeGetter;
    public InternalProcessorContext<String, String> context;
    public StreamsMetricsImpl streamsMetrics;
    @Mock
    public Sensor sensor;
    public long offset;

    @Before
    public void setUp() {
        Mockito.when((Object)this.serdeGetter.keySerde()).thenReturn((Object)new Serdes.StringSerde());
        Mockito.when((Object)this.serdeGetter.valueSerde()).thenReturn((Object)new Serdes.StringSerde());
        Metrics metrics = new Metrics();
        this.offset = 0L;
        this.streamsMetrics = new StreamsMetricsImpl(metrics, "test-client", "latest", (Time)new MockTime());
        this.context = new MockInternalNewProcessorContext<String, String>(StreamsTestUtils.getStreamsConfig(), new TaskId(0, 0), TestUtils.tempDirectory());
    }

    private void createBuffer(Duration grace) {
        RocksDBTimeOrderedKeyValueBytesStore store = new RocksDBTimeOrderedKeyValueBytesStoreSupplier("testing").get();
        this.buffer = new RocksDBTimeOrderedKeyValueBuffer(store, grace, "testing", false);
        this.buffer.setSerdesIfNull(this.serdeGetter);
        this.buffer.init(this.context, (StateStore)store);
    }

    private boolean pipeRecord(String key, String value, long time) {
        Record record = new Record((Object)key, (Object)value, time);
        this.context.setRecordContext(new ProcessorRecordContext(time, this.offset++, 0, "testing", (Headers)new RecordHeaders()));
        return this.buffer.put(time, record, this.context.recordContext());
    }

    @Test
    public void shouldReturnIfRecordWasAdded() {
        this.createBuffer(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)this.pipeRecord("K", "V", 2L), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.pipeRecord("K", "V", 0L), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldPutInBufferAndUpdateFields() {
        this.createBuffer(Duration.ofMinutes(1L));
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 0, Long.MAX_VALUE, 0L);
        this.pipeRecord("1", "0", 0L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 0L, 42L);
        this.pipeRecord("3", "0", 2L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 2, 0L, 84L);
    }

    @Test
    public void shouldAddAndEvictRecord() {
        this.createBuffer(Duration.ZERO);
        AtomicInteger count = new AtomicInteger(0);
        this.pipeRecord("1", "0", 0L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 0L, 42L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 0, Long.MAX_VALUE, 0L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldAddAndEvictRecordTwice() {
        this.createBuffer(Duration.ZERO);
        AtomicInteger count = new AtomicInteger(0);
        this.pipeRecord("1", "0", 0L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 0L, 42L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 0, Long.MAX_VALUE, 0L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)1));
        this.pipeRecord("2", "0", 1L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 1L, 42L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 0, Long.MAX_VALUE, 0L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddAndEvictRecordTwiceWithNonZeroGrace() {
        this.createBuffer(Duration.ofMillis(1L));
        AtomicInteger count = new AtomicInteger(0);
        this.pipeRecord("1", "0", 0L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 0L, 42L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)0));
        this.pipeRecord("2", "0", 1L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 1L, 42L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldAddRecordsTwiceAndEvictRecordsOnce() {
        this.createBuffer(Duration.ZERO);
        AtomicInteger count = new AtomicInteger(0);
        this.pipeRecord("1", "0", 0L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 1, r -> count.getAndIncrement());
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)0));
        this.pipeRecord("2", "0", 1L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldDropLateRecords() {
        this.createBuffer(Duration.ZERO);
        this.pipeRecord("1", "0", 1L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 1L, 42L);
        this.pipeRecord("2", "0", 0L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 1L, 42L);
    }

    @Test
    public void shouldDropLateRecordsWithNonZeroGrace() {
        this.createBuffer(Duration.ofMillis(1L));
        this.pipeRecord("1", "0", 2L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 2L, 42L);
        this.pipeRecord("2", "0", 1L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 2, 1L, 84L);
        this.pipeRecord("3", "0", 0L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 2, 1L, 84L);
    }

    @Test
    public void shouldHandleCollidingKeys() {
        this.createBuffer(Duration.ofMillis(1L));
        AtomicInteger count = new AtomicInteger(0);
        this.pipeRecord("2", "0", 0L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)0));
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 0L, 42L);
        this.pipeRecord("2", "2", 0L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)0));
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 2, 0L, 84L);
        this.pipeRecord("1", "0", 7L);
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 3, 0L, 126L);
        this.buffer.evictWhile(() -> this.buffer.numRecords() > 0, r -> count.getAndIncrement());
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)2));
        this.assertNumSizeAndTimestamp((TimeOrderedKeyValueBuffer<String, String, String>)this.buffer, 1, 7L, 42L);
    }

    private void assertNumSizeAndTimestamp(TimeOrderedKeyValueBuffer<String, String, String> buffer, int num, long time, long size) {
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.equalTo((Object)num));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.equalTo((Object)time));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.equalTo((Object)size));
    }
}

