/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueByteStoreAdapter;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.apache.kafka.streams.state.internals.TimestampedKeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TimestampedKeyValueStoreBuilderTest {
    @Mock
    private KeyValueBytesStoreSupplier supplier;
    @Mock
    private RocksDBTimestampedStore inner;
    private TimestampedKeyValueStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)this.inner);
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)"name");
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)"metricScope");
        this.builder = new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        TimestampedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        TimestampedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldNotWrapTimestampedByteStore() {
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)new RocksDBTimestampedStore("name", "metrics-scope"));
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedStore.class));
    }

    @Test
    public void shouldWrapPlainKeyValueStoreAsTimestampStore() {
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)new RocksDBStore("name", "metrics-scope"));
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(KeyValueToTimestampedKeyValueByteStoreAdapter.class));
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedKeyValueStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldNotThrowNullPointerIfKeySerdeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldNotThrowNullPointerIfValueSerdeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier's metricsScope can't be null"));
    }
}

