/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.internals.UpgradeFromValues;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.apache.kafka.streams.state.BuiltInDslStoreSuppliers;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=600L)
public class StreamsConfigTest {
    private final Properties props = new Properties();
    private StreamsConfig streamsConfig;
    private final String groupId = "example-application";
    private final String clientId = "client";
    private final int threadIdx = 1;

    @BeforeEach
    public void setUp() {
        this.props.put("application.id", "streams-config-test");
        this.props.put("bootstrap.servers", "localhost:9092");
        this.props.put("default.key.serde", Serdes.String().getClass().getName());
        this.props.put("default.value.serde", Serdes.String().getClass().getName());
        this.props.put("key.deserializer.encoding", StandardCharsets.UTF_8.name());
        this.props.put("value.deserializer.encoding", StandardCharsets.UTF_16.name());
        this.streamsConfig = new StreamsConfig((Map)this.props);
    }

    @Test
    public void testIllegalMetricsRecordingLevel() {
        this.props.put("metrics.recording.level", "illegalConfig");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void testOsDefaultSocketBufferSizes() {
        this.props.put("send.buffer.bytes", (Object)-1);
        this.props.put("receive.buffer.bytes", (Object)-1);
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void testInvalidSocketSendBufferSize() {
        this.props.put("send.buffer.bytes", (Object)-2);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void testInvalidSocketReceiveBufferSize() {
        this.props.put("receive.buffer.bytes", (Object)-2);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldThrowExceptionIfApplicationIdIsNotSet() {
        this.props.remove("application.id");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldThrowExceptionIfBootstrapServersIsNotSet() {
        this.props.remove("bootstrap.servers");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void testGetProducerConfigs() {
        Map returnedProps = this.streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(returnedProps.get("client.id"), (Matcher)IsEqual.equalTo((Object)"client"));
        MatcherAssert.assertThat(returnedProps.get("linger.ms"), (Matcher)IsEqual.equalTo((Object)"100"));
    }

    @Test
    public void testGetConsumerConfigs() {
        Map returnedProps = this.streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(returnedProps.get("client.id"), (Matcher)IsEqual.equalTo((Object)"client"));
        MatcherAssert.assertThat(returnedProps.get("group.id"), (Matcher)IsEqual.equalTo((Object)"example-application"));
        MatcherAssert.assertThat(returnedProps.get("max.poll.records"), (Matcher)IsEqual.equalTo((Object)"1000"));
        Assertions.assertNull(returnedProps.get("group.instance.id"));
    }

    @Test
    public void testGetGroupInstanceIdConfigs() {
        this.props.put("group.instance.id", "group-instance-id");
        this.props.put(StreamsConfig.mainConsumerPrefix((String)"group.instance.id"), "group-instance-id-1");
        this.props.put(StreamsConfig.restoreConsumerPrefix((String)"group.instance.id"), "group-instance-id-2");
        this.props.put(StreamsConfig.globalConsumerPrefix((String)"group.instance.id"), "group-instance-id-3");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map returnedProps = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(returnedProps.get("group.instance.id"), (Matcher)IsEqual.equalTo((Object)"group-instance-id-1-1"));
        returnedProps = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertNull(returnedProps.get("group.instance.id"));
        returnedProps = streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertNull(returnedProps.get("group.instance.id"));
    }

    @Test
    public void consumerConfigMustContainStreamPartitionAssignorConfig() {
        this.props.put("replication.factor", (Object)42);
        this.props.put("num.standby.replicas", (Object)1);
        this.props.put("acceptable.recovery.lag", (Object)99L);
        this.props.put("max.warmup.replicas", (Object)9);
        this.props.put("probing.rebalance.interval.ms", (Object)99999L);
        this.props.put("windowstore.changelog.additional.retention.ms", (Object)7L);
        this.props.put("application.server", "dummy:host");
        this.props.put(StreamsConfig.topicPrefix((String)"segment.bytes"), (Object)100);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map returnedProps = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)42, returnedProps.get("replication.factor"));
        Assertions.assertEquals((Object)1, returnedProps.get("num.standby.replicas"));
        Assertions.assertEquals((Object)99L, returnedProps.get("acceptable.recovery.lag"));
        Assertions.assertEquals((Object)9, returnedProps.get("max.warmup.replicas"));
        Assertions.assertEquals((Object)99999L, returnedProps.get("probing.rebalance.interval.ms"));
        Assertions.assertEquals((Object)StreamsPartitionAssignor.class.getName(), returnedProps.get("partition.assignment.strategy"));
        Assertions.assertEquals((Object)7L, returnedProps.get("windowstore.changelog.additional.retention.ms"));
        Assertions.assertEquals((Object)"dummy:host", returnedProps.get("application.server"));
        Assertions.assertEquals((Object)100, returnedProps.get(StreamsConfig.topicPrefix((String)"segment.bytes")));
    }

    @Test
    public void testGetMainConsumerConfigsWithMainConsumerOverriddenPrefix() {
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "5");
        this.props.put(StreamsConfig.mainConsumerPrefix((String)"max.poll.records"), "50");
        this.props.put(StreamsConfig.mainConsumerPrefix((String)"group.id"), "another-id");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map returnedProps = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)"example-application", returnedProps.get("group.id"));
        Assertions.assertEquals((Object)"50", returnedProps.get("max.poll.records"));
    }

    @Test
    public void testGetRestoreConsumerConfigs() {
        Map returnedProps = this.streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals(returnedProps.get("client.id"), (Object)"client");
        Assertions.assertNull(returnedProps.get("group.id"));
    }

    @Test
    public void defaultSerdeShouldBeConfigured() {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", StandardCharsets.UTF_8.name());
        serializerConfigs.put("value.serializer.encoding", StandardCharsets.UTF_16.name());
        Serializer serializer = Serdes.String().serializer();
        String str = "my string for testing";
        String topic = "my topic";
        serializer.configure(serializerConfigs, true);
        Assertions.assertEquals((Object)"my string for testing", (Object)this.streamsConfig.defaultKeySerde().deserializer().deserialize("my topic", serializer.serialize("my topic", (Object)"my string for testing")), (String)"Should get the original string after serialization and deserialization with the configured encoding");
        serializer.configure(serializerConfigs, false);
        Assertions.assertEquals((Object)"my string for testing", (Object)this.streamsConfig.defaultValueSerde().deserializer().deserialize("my topic", serializer.serialize("my topic", (Object)"my string for testing")), (String)"Should get the original string after serialization and deserialization with the configured encoding");
    }

    @Test
    public void shouldSupportMultipleBootstrapServers() {
        List<String> expectedBootstrapServers = Arrays.asList("broker1:9092", "broker2:9092");
        String bootstrapServersString = String.join((CharSequence)",", expectedBootstrapServers);
        Properties props = new Properties();
        props.put("application.id", "irrelevant");
        props.put("bootstrap.servers", bootstrapServersString);
        StreamsConfig config = new StreamsConfig((Map)props);
        List actualBootstrapServers = config.getList("bootstrap.servers");
        Assertions.assertEquals(expectedBootstrapServers, (Object)actualBootstrapServers);
    }

    @Test
    public void shouldSupportPrefixedConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedRestoreConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfConsumerConfig() {
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfRestoreConsumerConfig() {
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfProducerConfig() {
        this.props.put(StreamsConfig.producerPrefix((String)"interceptor.statsd.host"), "host");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Assertions.assertEquals((Object)"host", producerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix((String)"buffer.memory"), (Object)10);
        this.props.put(StreamsConfig.producerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("client");
        Assertions.assertEquals((Object)10, configs.get("buffer.memory"));
        Assertions.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedConsumerConfigs() {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)"earliest", consumerConfigs.get("auto.offset.reset"));
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedRestoreConsumerConfigs() {
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("example-application");
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportNonPrefixedProducerConfigs() {
        this.props.put("buffer.memory", (Object)10);
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getProducerConfigs("client");
        Assertions.assertEquals((Object)10, configs.get("buffer.memory"));
        Assertions.assertEquals((Object)1, configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldForwardCustomConfigsWithNoPrefixToAllClients() {
        this.props.put("custom.property.host", "host");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Map restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Map adminConfigs = streamsConfig.getAdminConfigs("client");
        Assertions.assertEquals((Object)"host", consumerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host", restoreConsumerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host", producerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host", adminConfigs.get("custom.property.host"));
    }

    @Test
    public void shouldOverrideNonPrefixedCustomConfigsWithPrefixedConfigs() {
        this.props.put("custom.property.host", "host0");
        this.props.put(StreamsConfig.consumerPrefix((String)"custom.property.host"), "host1");
        this.props.put(StreamsConfig.producerPrefix((String)"custom.property.host"), "host2");
        this.props.put(StreamsConfig.adminClientPrefix((String)"custom.property.host"), "host3");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Map restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Map adminConfigs = streamsConfig.getAdminConfigs("client");
        Assertions.assertEquals((Object)"host1", consumerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host1", restoreConsumerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host2", producerConfigs.get("custom.property.host"));
        Assertions.assertEquals((Object)"host3", adminConfigs.get("custom.property.host"));
    }

    @Test
    public void shouldSupportNonPrefixedAdminConfigs() {
        this.props.put("default.api.timeout.ms", (Object)10);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map configs = streamsConfig.getAdminConfigs("client");
        Assertions.assertEquals((Object)10, configs.get("default.api.timeout.ms"));
    }

    @Test
    public void shouldThrowStreamsExceptionIfKeySerdeConfigFails() {
        this.props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertThrows(StreamsException.class, () -> ((StreamsConfig)streamsConfig).defaultKeySerde());
    }

    @Test
    public void shouldThrowStreamsExceptionIfValueSerdeConfigFails() {
        this.props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertThrows(StreamsException.class, () -> ((StreamsConfig)streamsConfig).defaultValueSerde());
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Assertions.assertEquals((Object)"latest", consumerConfigs.get("auto.offset.reset"));
        Assertions.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldOverrideStreamsDefaultProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix((String)"linger.ms"), "10000");
        this.props.put(StreamsConfig.producerPrefix((String)"transaction.timeout.ms"), "30000");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Assertions.assertEquals((Object)"10000", producerConfigs.get("linger.ms"));
        Assertions.assertEquals((Object)"30000", producerConfigs.get("transaction.timeout.ms"));
    }

    @Test
    public void shouldThrowIfTransactionTimeoutSmallerThanCommitIntervalForEOSAlpha() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testTransactionTimeoutSmallerThanCommitInterval("exactly_once"));
    }

    @Test
    public void shouldThrowIfTransactionTimeoutSmallerThanCommitIntervalForEOSBeta() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testTransactionTimeoutSmallerThanCommitInterval("exactly_once_beta"));
    }

    @Test
    public void shouldNotThrowIfTransactionTimeoutSmallerThanCommitIntervalForAtLeastOnce() {
        this.testTransactionTimeoutSmallerThanCommitInterval("at_least_once");
    }

    private void testTransactionTimeoutSmallerThanCommitInterval(String processingGuarantee) {
        this.props.put("processing.guarantee", processingGuarantee);
        this.props.put("commit.interval.ms", (Object)10000L);
        this.props.put(StreamsConfig.producerPrefix((String)"transaction.timeout.ms"), (Object)3000);
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConifgsOnRestoreConsumer() {
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals((Object)"10", consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldResetToDefaultIfConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("a", "b", 1);
        Assertions.assertEquals((Object)"false", consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void shouldResetToDefaultIfRestoreConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals((Object)"false", consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void testGetRestoreConsumerConfigsWithRestoreConsumerOverriddenPrefix() {
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "5");
        this.props.put(StreamsConfig.restoreConsumerPrefix((String)"max.poll.records"), "50");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map returnedProps = streamsConfig.getRestoreConsumerConfigs("client");
        Assertions.assertEquals((Object)"50", returnedProps.get("max.poll.records"));
    }

    @Test
    public void testGetGlobalConsumerConfigs() {
        Map returnedProps = this.streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertEquals(returnedProps.get("client.id"), (Object)"client-global-consumer");
        Assertions.assertNull(returnedProps.get("group.id"));
    }

    @Test
    public void shouldSupportPrefixedGlobalConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix((String)"metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfGlobalConsumerConfig() {
        this.props.put(StreamsConfig.consumerPrefix((String)"interceptor.statsd.host"), "host");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertEquals((Object)"host", consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldBeSupportNonPrefixedGlobalConsumerConfigs() {
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getGlobalConsumerConfigs("example-application");
        Assertions.assertEquals((Object)1, consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldResetToDefaultIfGlobalConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix((String)"enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertEquals((Object)"false", consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void testGetGlobalConsumerConfigsWithGlobalConsumerOverriddenPrefix() {
        this.props.put(StreamsConfig.consumerPrefix((String)"max.poll.records"), "5");
        this.props.put(StreamsConfig.globalConsumerPrefix((String)"max.poll.records"), "50");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map returnedProps = streamsConfig.getGlobalConsumerConfigs("client");
        Assertions.assertEquals((Object)"50", returnedProps.get("max.poll.records"));
    }

    @Test
    public void shouldSetInternalLeaveGroupOnCloseConfigToFalseInConsumer() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("internal.leave.group.on.close"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotSetInternalThrowOnFetchStableOffsetUnsupportedConfigToFalseInConsumerForEosDisabled() {
        Map consumerConfigs = this.streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("internal.throw.on.fetch.stable.offset.unsupported"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSetInternalThrowOnFetchStableOffsetUnsupportedConfigToFalseInConsumerForEosAlpha() {
        this.props.put("processing.guarantee", "exactly_once");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("internal.throw.on.fetch.stable.offset.unsupported"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSetInternalThrowOnFetchStableOffsetUnsupportedConfigToFalseInConsumerForEosBeta() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("internal.throw.on.fetch.stable.offset.unsupported"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotSetInternalThrowOnFetchStableOffsetUnsupportedConfigToFalseInConsumerForEosV2() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("internal.throw.on.fetch.stable.offset.unsupported"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotSetInternalAutoDowngradeTxnCommitToTrueInProducerForEosDisabled() {
        Map producerConfigs = this.streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("internal.auto.downgrade.txn.commit"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldSetInternalAutoDowngradeTxnCommitToTrueInProducerForEosAlpha() {
        this.props.put("processing.guarantee", "exactly_once");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("internal.auto.downgrade.txn.commit"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotSetInternalAutoDowngradeTxnCommitToTrueInProducerForEosBeta() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("internal.auto.downgrade.txn.commit"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSetInternalAutoDowngradeTxnCommitToTrueInProducerForEosV2() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("internal.auto.downgrade.txn.commit"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldAcceptAtLeastOnce() {
        this.props.put("processing.guarantee", "at_least_once");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldAcceptExactlyOnce() {
        this.props.put("processing.guarantee", "exactly_once");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldAcceptExactlyOnceBeta() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldThrowExceptionIfNotAtLeastOnceOrExactlyOnce() {
        this.props.put("processing.guarantee", "bad_value");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldAcceptBuiltInMetricsLatestVersion() {
        this.props.put("built.in.metrics.version", "latest");
        new StreamsConfig((Map)this.props);
    }

    @Test
    public void shouldSetDefaultBuiltInMetricsVersionIfNoneIsSpecified() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)config.getString("built.in.metrics.version"), (Matcher)CoreMatchers.is((Object)"latest"));
    }

    @Test
    public void shouldThrowIfBuiltInMetricsVersionInvalid() {
        String invalidVersion = "0.0.1";
        this.props.put("built.in.metrics.version", "0.0.1");
        Exception exception = (Exception)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid value 0.0.1 for configuration built.in.metrics.version"));
    }

    @Test
    public void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled();
    }

    @Test
    public void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled();
    }

    @Test
    public void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled();
    }

    private void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled() {
        this.props.put("isolation.level", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("isolation.level"), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.toString()));
    }

    @Test
    public void shouldAllowSettingConsumerIsolationLevelIfEosDisabled() {
        this.props.put("isolation.level", IsolationLevel.READ_UNCOMMITTED.toString());
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        MatcherAssert.assertThat(consumerConfigs.get("isolation.level"), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_UNCOMMITTED.toString()));
    }

    @Test
    public void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled();
    }

    @Test
    public void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled();
    }

    @Test
    public void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled();
    }

    private void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled() {
        this.props.put("enable.idempotence", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        Assertions.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
    }

    @Test
    public void shouldAllowSettingProducerEnableIdempotenceIfEosDisabled() {
        this.props.put("enable.idempotence", (Object)false);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("enable.idempotence"), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldSetDifferentDefaultsIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldSetDifferentDefaultsIfEosEnabled();
    }

    @Test
    public void shouldSetDifferentDefaultsIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldSetDifferentDefaultsIfEosEnabled();
    }

    @Test
    public void shouldSetDifferentDefaultsIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldSetDifferentDefaultsIfEosEnabled();
    }

    private void shouldSetDifferentDefaultsIfEosEnabled() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map consumerConfigs = streamsConfig.getMainConsumerConfigs("example-application", "client", 1);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(consumerConfigs.get("isolation.level"), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.toString()));
        Assertions.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
        MatcherAssert.assertThat(producerConfigs.get("delivery.timeout.ms"), (Matcher)IsEqual.equalTo((Object)Integer.MAX_VALUE));
        MatcherAssert.assertThat(producerConfigs.get("transaction.timeout.ms"), (Matcher)IsEqual.equalTo((Object)10000));
        MatcherAssert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)100L));
    }

    @Test
    public void shouldOverrideUserConfigTransactionalIdIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldOverrideUserConfigTransactionalIdIfEosEnable();
    }

    @Test
    public void shouldOverrideUserConfigTransactionalIdIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldOverrideUserConfigTransactionalIdIfEosEnable();
    }

    @Test
    public void shouldOverrideUserConfigTransactionalIdIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldOverrideUserConfigTransactionalIdIfEosEnable();
    }

    private void shouldOverrideUserConfigTransactionalIdIfEosEnable() {
        this.props.put("transactional.id", "user-TxId");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("transactional.id"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotOverrideUserConfigRetriesIfExactlyAlphaOnceEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled();
    }

    @Test
    public void shouldNotOverrideUserConfigRetriesIfExactlyBetaOnceEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled();
    }

    @Test
    public void shouldNotOverrideUserConfigRetriesIfExactlyV2OnceEnabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled();
    }

    private void shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled() {
        int numberOfRetries = 42;
        this.props.put("retries", (Object)42);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Map producerConfigs = streamsConfig.getProducerConfigs("client");
        MatcherAssert.assertThat(producerConfigs.get("retries"), (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled();
    }

    @Test
    public void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled();
    }

    @Test
    public void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled();
    }

    private void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled() {
        long commitIntervalMs = 73L;
        this.props.put("commit.interval.ms", (Object)73L);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)73L));
    }

    @Test
    public void shouldThrowExceptionIfCommitIntervalMsIsNegative() {
        long commitIntervalMs = -1L;
        this.props.put("commit.interval.ms", (Object)-1L);
        try {
            new StreamsConfig((Map)this.props);
            Assertions.fail((String)"Should throw ConfigException when commitIntervalMs is set to a negative value");
        }
        catch (ConfigException e) {
            Assertions.assertEquals((Object)"Invalid value -1 for configuration commit.interval.ms: Value must be at least 0", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldUseNewConfigsWhenPresent() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("default.key.serde", Serdes.Long().getClass());
        props.put("default.value.serde", Serdes.Long().getClass());
        props.put("default.timestamp.extractor", MockTimestampExtractor.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        Assertions.assertInstanceOf(Serdes.LongSerde.class, (Object)config.defaultKeySerde());
        Assertions.assertInstanceOf(Serdes.LongSerde.class, (Object)config.defaultValueSerde());
        Assertions.assertInstanceOf(MockTimestampExtractor.class, (Object)config.defaultTimestampExtractor());
    }

    @Test
    public void shouldUseCorrectDefaultsWhenNoneSpecified() {
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        Assertions.assertInstanceOf(FailOnInvalidTimestamp.class, (Object)config.defaultTimestampExtractor());
        Assertions.assertThrows(ConfigException.class, () -> ((StreamsConfig)config).defaultKeySerde());
        Assertions.assertThrows(ConfigException.class, () -> ((StreamsConfig)config).defaultValueSerde());
    }

    @Test
    public void shouldSpecifyCorrectKeySerdeClassOnError() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.defaultKeySerde();
            Assertions.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assertions.assertEquals((Object)"Failed to configure key serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectValueSerdeClassOnError() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig((Map)props);
        try {
            config.defaultValueSerde();
            Assertions.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assertions.assertEquals((Object)"Failed to configure value serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosEnabled();
    }

    @Test
    public void shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosEnabled();
    }

    @Test
    public void shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosEnabled();
    }

    private void shouldThrowExceptionIfMaxInFlightRequestsGreaterThanFiveIfEosEnabled() {
        this.props.put("max.in.flight.requests.per.connection", (Object)7);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        try {
            streamsConfig.getProducerConfigs("client");
            Assertions.fail((String)"Should throw ConfigException when ESO is enabled and maxInFlight requests exceeds 5");
        }
        catch (ConfigException e) {
            Assertions.assertEquals((Object)"Invalid value 7 for configuration max.in.flight.requests.per.connection: Can't exceed 5 when exactly-once processing is enabled", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosEnabled();
    }

    @Test
    public void shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosEnabled();
    }

    @Test
    public void shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosEnabled();
    }

    private void shouldAllowToSpecifyMaxInFlightRequestsPerConnectionAsStringIfEosEnabled() {
        this.props.put("max.in.flight.requests.per.connection", "3");
        new StreamsConfig((Map)this.props).getProducerConfigs("client");
    }

    @Test
    public void shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosAlphaEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosEnabled();
    }

    @Test
    public void shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosBetaEnabled() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        this.shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosEnabled();
    }

    @Test
    public void shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosV2Enabled() {
        this.props.put("processing.guarantee", "exactly_once_v2");
        this.shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosEnabled();
    }

    private void shouldThrowConfigExceptionIfMaxInFlightRequestsPerConnectionIsInvalidStringIfEosEnabled() {
        this.props.put("max.in.flight.requests.per.connection", "not-a-number");
        try {
            new StreamsConfig((Map)this.props).getProducerConfigs("client");
            Assertions.fail((String)"Should throw ConfigException when EOS is enabled and maxInFlight cannot be paresed into an integer");
        }
        catch (ConfigException e) {
            Assertions.assertEquals((Object)"Invalid value not-a-number for configuration max.in.flight.requests.per.connection: String value could not be parsed as 32-bit integer", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldStateDirStartsWithJavaIOTmpDir() {
        String expectedPrefix = System.getProperty("java.io.tmpdir") + File.separator;
        String actual = this.streamsConfig.getString("state.dir");
        Assertions.assertTrue((boolean)actual.startsWith(expectedPrefix));
    }

    @Test
    public void shouldSpecifyNoOptimizationWhenNotExplicitlyAddedToConfigs() {
        String expectedOptimizeConfig = "none";
        String actualOptimizedConifig = this.streamsConfig.getString("topology.optimization");
        Assertions.assertEquals((Object)"none", (Object)actualOptimizedConifig, (String)"Optimization should be \"none\"");
    }

    @Test
    public void shouldSpecifyOptimizationWhenExplicitlyAddedToConfigs() {
        String expectedOptimizeConfig = "all";
        this.props.put("topology.optimization", "all");
        StreamsConfig config = new StreamsConfig((Map)this.props);
        String actualOptimizedConifig = config.getString("topology.optimization");
        Assertions.assertEquals((Object)"all", (Object)actualOptimizedConifig, (String)"Optimization should be \"all\"");
    }

    @Test
    public void shouldThrowConfigExceptionWhenOptimizationConfigNotValueInRange() {
        this.props.put("topology.optimization", "maybe");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSpecifyRocksdbWhenNotExplicitlyAddedToConfigs() {
        String expectedDefaultStoreType = "rocksDB";
        String actualDefaultStoreType = this.streamsConfig.getString("default.dsl.store");
        Assertions.assertEquals((Object)"rocksDB", (Object)actualDefaultStoreType, (String)"default.dsl.store should be \"rocksDB\"");
    }

    @Test
    public void shouldSpecifyInMemoryWhenExplicitlyAddedToConfigs() {
        String expectedDefaultStoreType = "in_memory";
        this.props.put("default.dsl.store", "in_memory");
        StreamsConfig config = new StreamsConfig((Map)this.props);
        String actualDefaultStoreType = config.getString("default.dsl.store");
        Assertions.assertEquals((Object)"in_memory", (Object)actualDefaultStoreType, (String)"default.dsl.store should be \"in_memory\"");
    }

    @Test
    public void shouldThrowConfigExceptionWhenStoreTypeConfigNotValueInRange() {
        this.props.put("default.dsl.store", "bad_config");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSpecifyRocksdbDslSupplierWhenNotExplicitlyAddedToConfigs() {
        Class<BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers> expectedDefaultStoreType = BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class;
        Class actualDefaultStoreType = this.streamsConfig.getClass("dsl.store.suppliers.class");
        Assertions.assertEquals(expectedDefaultStoreType, (Object)actualDefaultStoreType, (String)("default dsl.store.suppliers.class should be " + expectedDefaultStoreType));
    }

    @Test
    public void shouldSpecifyInMemoryDslSupplierWhenExplicitlyAddedToConfigs() {
        Class<BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers> expectedDefaultStoreType = BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class;
        this.props.put("dsl.store.suppliers.class", BuiltInDslStoreSuppliers.InMemoryDslStoreSuppliers.class);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Class actualDefaultStoreType = config.getClass("dsl.store.suppliers.class");
        Assertions.assertEquals(expectedDefaultStoreType, (Object)actualDefaultStoreType, (String)("default dsl.store.suppliers.class should be " + expectedDefaultStoreType));
    }

    @Test
    public void shouldLogWarningWhenEosAlphaIsUsed() {
        this.props.put("processing.guarantee", "exactly_once");
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(StreamsConfig.class);){
            appender.setClassLogger(StreamsConfig.class, Level.DEBUG);
            new StreamsConfig((Map)this.props);
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Configuration parameter `exactly_once` is deprecated and will be removed in the 4.0.0 release. Please use `exactly_once_v2` instead. Note that this requires broker version 2.5+ so you should prepare to upgrade your brokers if necessary."));
        }
    }

    @Test
    public void shouldLogWarningWhenEosBetaIsUsed() {
        this.props.put("processing.guarantee", "exactly_once_beta");
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(StreamsConfig.class);){
            appender.setClassLogger(StreamsConfig.class, Level.DEBUG);
            new StreamsConfig((Map)this.props);
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Configuration parameter `exactly_once_beta` is deprecated and will be removed in the 4.0.0 release. Please use `exactly_once_v2` instead."));
        }
    }

    @Test
    public void shouldLogWarningWhenRetriesIsUsed() {
        this.props.put("retries", (Object)0);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(StreamsConfig.class);){
            appender.setClassLogger(StreamsConfig.class, Level.DEBUG);
            new StreamsConfig((Map)this.props);
            MatcherAssert.assertThat((Object)appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Configuration parameter `retries` is deprecated and will be removed in the 4.0.0 release."));
        }
    }

    @Test
    public void shouldSetDefaultAcceptableRecoveryLag() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)config.getLong("acceptable.recovery.lag"), (Matcher)CoreMatchers.is((Object)10000L));
    }

    @Test
    public void shouldThrowConfigExceptionIfAcceptableRecoveryLagIsOutsideBounds() {
        this.props.put("acceptable.recovery.lag", (Object)-1L);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSetDefaultNumStandbyReplicas() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)config.getInt("num.standby.replicas"), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldThrowConfigExceptionIfNumStandbyReplicasIsOutsideBounds() {
        this.props.put("num.standby.replicas", (Object)-1L);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSetDefaultMaxWarmupReplicas() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)config.getInt("max.warmup.replicas"), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldThrowConfigExceptionIfMaxWarmupReplicasIsOutsideBounds() {
        this.props.put("max.warmup.replicas", (Object)0L);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSetDefaultProbingRebalanceInterval() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        MatcherAssert.assertThat((Object)config.getLong("probing.rebalance.interval.ms"), (Matcher)CoreMatchers.is((Object)600000L));
    }

    @Test
    public void shouldThrowConfigExceptionIfProbingRebalanceIntervalIsOutsideBounds() {
        this.props.put("probing.rebalance.interval.ms", (Object)59999L);
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldDefaultToEmptyListIfRackAwareAssignmentTagsIsNotSet() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertTrue((boolean)config.getList("rack.aware.assignment.tags").isEmpty());
    }

    @Test
    public void shouldThrowExceptionWhenClientTagsExceedTheLimit() {
        int limit = 6;
        for (int i = 0; i < 6; ++i) {
            this.props.put(StreamsConfig.clientTagPrefix((String)("k" + i)), "v" + i);
        }
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertEquals((Object)String.format("At most %s client tags can be specified using %s prefix.", 5, "client.tag."), (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowExceptionWhenRackAwareAssignmentTagsExceedsMaxListSize() {
        int limit = 6;
        ArrayList<String> rackAwareAssignmentTags = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            String clientTagKey = "k" + i;
            rackAwareAssignmentTags.add(clientTagKey);
            this.props.put(StreamsConfig.clientTagPrefix((String)clientTagKey), "v" + i);
        }
        this.props.put("rack.aware.assignment.tags", String.join((CharSequence)",", rackAwareAssignmentTags));
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertEquals((Object)String.format("Invalid value %s for configuration %s: exceeds maximum list size of [%s].", rackAwareAssignmentTags, "rack.aware.assignment.tags", 5), (Object)exception.getMessage());
    }

    @Test
    public void shouldSetRackAwareAssignmentTags() {
        this.props.put(StreamsConfig.clientTagPrefix((String)"cluster"), "cluster-1");
        this.props.put(StreamsConfig.clientTagPrefix((String)"zone"), "eu-central-1a");
        this.props.put("rack.aware.assignment.tags", "cluster,zone");
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals(new HashSet(config.getList("rack.aware.assignment.tags")), (Object)Utils.mkSet((Object[])new String[]{"cluster", "zone"}));
    }

    @Test
    public void shouldGetEmptyMapIfClientTagsAreNotSet() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertTrue((boolean)config.getClientTags().isEmpty());
    }

    @Test
    public void shouldGetClientTagsMapWhenSet() {
        this.props.put(StreamsConfig.clientTagPrefix((String)"zone"), "eu-central-1a");
        this.props.put(StreamsConfig.clientTagPrefix((String)"cluster"), "cluster-1");
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Map clientTags = config.getClientTags();
        Assertions.assertEquals((int)clientTags.size(), (int)2);
        Assertions.assertEquals(clientTags.get("zone"), (Object)"eu-central-1a");
        Assertions.assertEquals(clientTags.get("cluster"), (Object)"cluster-1");
    }

    @Test
    public void shouldThrowExceptionWhenClientTagRackAwarenessIsConfiguredWithUnknownTags() {
        this.props.put("rack.aware.assignment.tags", "cluster");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldThrowExceptionWhenClientTagKeyExceedMaxLimit() {
        String key = String.join((CharSequence)"", Collections.nCopies(21, "k"));
        this.props.put(StreamsConfig.clientTagPrefix((String)key), "eu-central-1a");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertEquals((Object)String.format("Invalid value %s for configuration %s: Tag key exceeds maximum length of %s.", key, "client.tag.", 20), (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowExceptionWhenClientTagValueExceedMaxLimit() {
        String value = String.join((CharSequence)"", Collections.nCopies(31, "v"));
        this.props.put(StreamsConfig.clientTagPrefix((String)"x"), value);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertEquals((Object)String.format("Invalid value %s for configuration %s: Tag value exceeds maximum length of %s.", value, "client.tag.", 30), (Object)exception.getMessage());
    }

    @Test
    public void shouldUseStateStoreCacheMaxBytesWhenBothOldAndNewConfigsAreSet() {
        this.props.put("statestore.cache.max.bytes", (Object)100);
        this.props.put("cache.max.bytes.buffering", (Object)10);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((long)StreamsConfigUtils.getTotalCacheSize((StreamsConfig)config), (long)100L);
    }

    @Test
    public void shouldUseCacheMaxBytesBufferingConfigWhenOnlyDeprecatedConfigIsSet() {
        this.props.put("cache.max.bytes.buffering", (Object)10);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((long)StreamsConfigUtils.getTotalCacheSize((StreamsConfig)config), (long)10L);
    }

    @Test
    public void shouldUseStateStoreCacheMaxBytesWhenNewConfigIsSet() {
        this.props.put("statestore.cache.max.bytes", (Object)10);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((long)StreamsConfigUtils.getTotalCacheSize((StreamsConfig)config), (long)10L);
    }

    @Test
    public void shouldUseDefaultStateStoreCacheMaxBytesConfigWhenNoConfigIsSet() {
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((long)StreamsConfigUtils.getTotalCacheSize((StreamsConfig)config), (long)0xA00000L);
    }

    @Test
    public void testCaseInsensitiveSecurityProtocol() {
        String saslSslLowerCase = SecurityProtocol.SASL_SSL.name.toLowerCase(Locale.ROOT);
        this.props.put("security.protocol", saslSslLowerCase);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((Object)saslSslLowerCase, config.originalsStrings().get("security.protocol"));
    }

    @Test
    public void testInvalidSecurityProtocol() {
        this.props.put("security.protocol", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void shouldThrowExceptionWhenTopologyOptimizationOnAndOff() {
        String value = String.join((CharSequence)",", "all", "none");
        this.props.put("topology.optimization", value);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("is not a valid optimization config"));
    }

    @Test
    public void shouldThrowExceptionWhenTopologyOptimizationOffAndSet() {
        String value = String.join((CharSequence)",", "none", "reuse.ktable.source.topics");
        this.props.put("topology.optimization", value);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("is not a valid optimization config"));
    }

    @Test
    public void shouldThrowExceptionWhenOptimizationDoesNotExistInList() {
        String value = String.join((CharSequence)",", "reuse.ktable.source.topics", "topology.optimization.does.not.exist", "merge.repartition.topics");
        this.props.put("topology.optimization", value);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unrecognized config."));
    }

    @Test
    public void shouldThrowExceptionWhenTopologyOptimizationDoesNotExist() {
        String value = String.join((CharSequence)",", "topology.optimization.does.not.exist");
        this.props.put("topology.optimization", value);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unrecognized config."));
    }

    @Test
    public void shouldEnableSelfJoin() {
        String value = "single.store.self.join";
        this.props.put("topology.optimization", "single.store.self.join");
        StreamsConfig config = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((Object)config.getString("topology.optimization"), (Object)"single.store.self.join");
    }

    @Test
    public void shouldAllowMultipleOptimizations() {
        String value = String.join((CharSequence)",", "single.store.self.join", "reuse.ktable.source.topics", "merge.repartition.topics");
        this.props.put("topology.optimization", value);
        StreamsConfig config = new StreamsConfig((Map)this.props);
        List<String> configs = Arrays.asList(config.getString("topology.optimization").split(","));
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertTrue((boolean)configs.contains("single.store.self.join"));
        Assertions.assertTrue((boolean)configs.contains("reuse.ktable.source.topics"));
        Assertions.assertTrue((boolean)configs.contains("merge.repartition.topics"));
    }

    @Test
    public void shouldEnableAllOptimizationsWithOptimizeConfig() {
        Set configs = StreamsConfig.verifyTopologyOptimizationConfigs((String)"all");
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertTrue((boolean)configs.contains("reuse.ktable.source.topics"));
        Assertions.assertTrue((boolean)configs.contains("merge.repartition.topics"));
        Assertions.assertTrue((boolean)configs.contains("single.store.self.join"));
    }

    @Test
    public void shouldNotEnableAnyOptimizationsWithNoOptimizationConfig() {
        Set configs = StreamsConfig.verifyTopologyOptimizationConfigs((String)"none");
        Assertions.assertEquals((int)0, (int)configs.size());
    }

    @Test
    public void shouldReturnDefaultRackAwareAssignmentConfig() {
        String strategy = this.streamsConfig.getString("rack.aware.assignment.strategy");
        Assertions.assertEquals((Object)"none", (Object)strategy);
    }

    @Test
    public void shouldtSetMinTrafficRackAwareAssignmentConfig() {
        this.props.put("rack.aware.assignment.strategy", "min_traffic");
        Assertions.assertEquals((Object)"min_traffic", (Object)new StreamsConfig((Map)this.props).getString("rack.aware.assignment.strategy"));
    }

    @Test
    public void shouldtSetBalanceSubtopologyRackAwareAssignmentConfig() {
        this.props.put("rack.aware.assignment.strategy", "balance_subtopology");
        Assertions.assertEquals((Object)"balance_subtopology", (Object)new StreamsConfig((Map)this.props).getString("rack.aware.assignment.strategy"));
    }

    @Test
    public void shouldThrowIfNotSetCorrectRackAwareAssignmentConfig() {
        this.props.put("rack.aware.assignment.strategy", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldReturnDefaultRackAwareAssignmentTrafficCost() {
        Integer cost = this.streamsConfig.getInt("rack.aware.assignment.traffic_cost");
        Assertions.assertNull((Object)cost);
    }

    @Test
    public void shouldReturnRackAwareAssignmentTrafficCost() {
        this.props.put("rack.aware.assignment.traffic_cost", "10");
        Assertions.assertEquals((Integer)10, (Integer)new StreamsConfig((Map)this.props).getInt("rack.aware.assignment.traffic_cost"));
    }

    @Test
    public void shouldReturnDefaultRackAwareAssignmentNonOverlapCost() {
        Integer cost = this.streamsConfig.getInt("rack.aware.assignment.non_overlap_cost");
        Assertions.assertNull((Object)cost);
    }

    @Test
    public void shouldReturnRackAwareAssignmentNonOverlapCost() {
        this.props.put("rack.aware.assignment.non_overlap_cost", "10");
        Assertions.assertEquals((Integer)10, (Integer)new StreamsConfig((Map)this.props).getInt("rack.aware.assignment.non_overlap_cost"));
    }

    @Test
    public void shouldReturnTaskAssignorClass() {
        this.props.put("task.assignor.class", "LegacyStickyTaskAssignor");
        Assertions.assertEquals((Object)"LegacyStickyTaskAssignor", (Object)new StreamsConfig((Map)this.props).getString("task.assignor.class"));
    }

    @Test
    public void shouldReturnDefaultClientSupplier() {
        KafkaClientSupplier supplier = this.streamsConfig.getKafkaClientSupplier();
        Assertions.assertInstanceOf(DefaultKafkaClientSupplier.class, (Object)supplier);
    }

    @Test
    public void shouldThrowOnInvalidClientSupplier() {
        this.props.put("default.client.supplier", "invalid.class");
        Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
    }

    @Test
    public void shouldSupportAllUpgradeFromValues() {
        for (UpgradeFromValues upgradeFrom : UpgradeFromValues.values()) {
            this.props.put("upgrade.from", upgradeFrom.toString());
            try {
                new StreamsConfig((Map)this.props);
            }
            catch (Exception fatal) {
                throw new AssertionError((Object)("StreamsConfig did not accept `upgrade.from` config value `" + upgradeFrom + "`"));
            }
        }
    }

    @Test
    public void shouldNotSetEnableMetricCollectionByDefault() {
        Assertions.assertNull(this.streamsConfig.getMainConsumerConfigs("groupId", "clientId", 0).get("enable.metrics.push"));
        Assertions.assertNull(this.streamsConfig.getRestoreConsumerConfigs("clientId").get("enable.metrics.push"));
        Assertions.assertNull(this.streamsConfig.getGlobalConsumerConfigs("clientId").get("enable.metrics.push"));
        Assertions.assertNull(this.streamsConfig.getProducerConfigs("clientId").get("enable.metrics.push"));
        Assertions.assertNull(this.streamsConfig.getAdminConfigs("clientId").get("enable.metrics.push"));
    }

    @Test
    public void shouldEnableMetricCollectionForAllInternalClientsByDefault() {
        this.props.put("enable.metrics.push", (Object)true);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertTrue((boolean)((Boolean)streamsConfig.getMainConsumerConfigs("groupId", "clientId", 0).get("enable.metrics.push")));
        Assertions.assertTrue((boolean)((Boolean)streamsConfig.getRestoreConsumerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertTrue((boolean)((Boolean)streamsConfig.getGlobalConsumerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertTrue((boolean)((Boolean)streamsConfig.getProducerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertTrue((boolean)((Boolean)streamsConfig.getAdminConfigs("clientId").get("enable.metrics.push")));
    }

    @Test
    public void shouldDisableMetricCollectionForAllInternalClients() {
        this.props.put("enable.metrics.push", (Object)false);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getMainConsumerConfigs("groupId", "clientId", 0).get("enable.metrics.push")));
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getRestoreConsumerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getGlobalConsumerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getProducerConfigs("clientId").get("enable.metrics.push")));
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getAdminConfigs("clientId").get("enable.metrics.push")));
    }

    @Test
    public void shouldDisableMetricCollectionOnMainConsumerOnly() {
        this.props.put(StreamsConfig.mainConsumerPrefix((String)"enable.metrics.push"), (Object)false);
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertFalse((boolean)((Boolean)streamsConfig.getMainConsumerConfigs("groupId", "clientId", 0).get("enable.metrics.push")));
        Assertions.assertNull(streamsConfig.getRestoreConsumerConfigs("clientId").get("enable.metrics.push"));
        Assertions.assertNull(streamsConfig.getGlobalConsumerConfigs("clientId").get("enable.metrics.push"));
    }

    @Test
    public void shouldGetDefaultValueProcessingExceptionHandler() {
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((Object)"org.apache.kafka.streams.errors.LogAndFailProcessingExceptionHandler", (Object)streamsConfig.processingExceptionHandler().getClass().getName());
    }

    @Test
    public void shouldOverrideDefaultProcessingExceptionHandler() {
        this.props.put("processing.exception.handler", "org.apache.kafka.streams.errors.LogAndContinueProcessingExceptionHandler");
        StreamsConfig streamsConfig = new StreamsConfig((Map)this.props);
        Assertions.assertEquals((Object)"org.apache.kafka.streams.errors.LogAndContinueProcessingExceptionHandler", (Object)streamsConfig.processingExceptionHandler().getClass().getName());
    }

    @Test
    public void testInvalidProcessingExceptionHandler() {
        this.props.put("processing.exception.handler", "org.apache.kafka.streams.errors.InvalidProcessingExceptionHandler");
        Exception exception = (Exception)Assertions.assertThrows(ConfigException.class, () -> new StreamsConfig((Map)this.props));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid value org.apache.kafka.streams.errors.InvalidProcessingExceptionHandler for configuration processing.exception.handler: Class org.apache.kafka.streams.errors.InvalidProcessingExceptionHandler could not be found."));
    }

    public static class MockTimestampExtractor
    implements TimestampExtractor {
        public long extract(ConsumerRecord<Object, Object> record, long partitionTime) {
            return 0L;
        }
    }

    static class MisconfiguredSerde
    implements Serde<Object> {
        MisconfiguredSerde() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            throw new RuntimeException("boom");
        }

        public Serializer<Object> serializer() {
            return null;
        }

        public Deserializer<Object> deserializer() {
            return null;
        }
    }
}

