/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;

public abstract class AbstractJoinIntegrationTest {
    private final MockTime time = new MockTime();
    private static final Long COMMIT_INTERVAL = 100L;
    static final String INPUT_TOPIC_RIGHT = "inputTopicRight";
    static final String INPUT_TOPIC_LEFT = "inputTopicLeft";
    static final String OUTPUT_TOPIC = "outputTopic";
    static final long ANY_UNIQUE_KEY = 0L;
    protected final List<Input<String>> input = Arrays.asList(new Input<Object>("inputTopicLeft", null, 1L), new Input<Object>("inputTopicRight", null, 2L), new Input<String>("inputTopicLeft", "A", 3L), new Input<String>("inputTopicRight", "a", 4L), new Input<String>("inputTopicLeft", "B", 5L), new Input<String>("inputTopicRight", "b", 6L), new Input<Object>("inputTopicLeft", null, 7L), new Input<Object>("inputTopicRight", null, 8L), new Input<String>("inputTopicLeft", "C", 9L), new Input<String>("inputTopicRight", "c", 10L), new Input<Object>("inputTopicRight", null, 11L), new Input<Object>("inputTopicLeft", null, 12L), new Input<Object>("inputTopicRight", null, 13L), new Input<String>("inputTopicRight", "d", 7L), new Input<String>("inputTopicLeft", "D", 6L), new Input<Object>("inputTopicLeft", null, 2L), new Input<Object>("inputTopicRight", null, 3L), new Input<String>("inputTopicRight", "e", 14L), new Input<String>("inputTopicLeft", "E", 15L), new Input<Object>("inputTopicLeft", null, 10L), new Input<Object>("inputTopicRight", null, 9L), new Input<String>("inputTopicLeft", "F", 4L), new Input<String>("inputTopicRight", "f", 3L));
    protected final List<Input<String>> inputWithoutOutOfOrderData = Arrays.asList(new Input<Object>("inputTopicLeft", null, 1L), new Input<Object>("inputTopicRight", null, 2L), new Input<String>("inputTopicLeft", "A", 3L), new Input<String>("inputTopicRight", "a", 4L), new Input<String>("inputTopicLeft", "B", 5L), new Input<String>("inputTopicRight", "b", 6L), new Input<Object>("inputTopicLeft", null, 7L), new Input<Object>("inputTopicRight", null, 8L), new Input<String>("inputTopicLeft", "C", 9L), new Input<String>("inputTopicRight", "c", 10L), new Input<Object>("inputTopicRight", null, 11L), new Input<Object>("inputTopicLeft", null, 12L), new Input<Object>("inputTopicRight", null, 13L), new Input<String>("inputTopicRight", "d", 14L), new Input<String>("inputTopicLeft", "D", 15L), new Input<String>("inputTopicLeft", null, "E", 16L), new Input<String>("inputTopicRight", null, "e", 17L));
    private final List<Input<String>> leftInput = Arrays.asList(new Input<Object>("inputTopicLeft", null, 1L), new Input<String>("inputTopicLeft", "A", 2L), new Input<String>("inputTopicLeft", "B", 3L), new Input<Object>("inputTopicLeft", null, 4L), new Input<String>("inputTopicLeft", "C", 5L), new Input<Object>("inputTopicLeft", null, 6L), new Input<String>("inputTopicLeft", "D", 7L));
    final ValueJoiner<String, String, String> valueJoiner = (value1, value2) -> value1 + "-" + value2;

    Properties setupConfigsAndUtils(boolean cacheEnabled) {
        return this.setupConfigsAndUtils(cacheEnabled, true);
    }

    Properties setupConfigsAndUtils(boolean cacheEnabled, boolean setSerdes) {
        Properties streamsConfig = new Properties();
        streamsConfig.put("auto.offset.reset", "earliest");
        if (setSerdes) {
            streamsConfig.put("default.key.serde", Serdes.LongSerde.class);
            streamsConfig.put("default.value.serde", Serdes.StringSerde.class);
        }
        streamsConfig.put("commit.interval.ms", COMMIT_INTERVAL);
        if (!cacheEnabled) {
            streamsConfig.put("statestore.cache.max.bytes", (Object)0);
        }
        streamsConfig.put("state.dir", TestUtils.tempDirectory().getPath());
        return streamsConfig;
    }

    void runTestWithDriver(List<Input<String>> input, List<List<TestRecord<Long, String>>> expectedResult, Properties properties, Topology topology) {
        this.runTestWithDriver(input, expectedResult, null, properties, topology);
    }

    void runTestWithDriver(List<Input<String>> input, List<List<TestRecord<Long, String>>> expectedResult, String storeName, Properties properties, Topology topology) {
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, properties);){
            TestInputTopic right = driver.createInputTopic(INPUT_TOPIC_RIGHT, (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(INPUT_TOPIC_LEFT, (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT_TOPIC, (Deserializer)new LongDeserializer(), (Deserializer)new StringDeserializer());
            HashMap<String, TestInputTopic> testInputTopicMap = new HashMap<String, TestInputTopic>();
            testInputTopicMap.put(INPUT_TOPIC_RIGHT, right);
            testInputTopicMap.put(INPUT_TOPIC_LEFT, left);
            TestRecord expectedFinalResult = null;
            long baseTimestamp = this.time.milliseconds();
            Iterator<List<TestRecord<Long, String>>> resultIterator = expectedResult.iterator();
            for (Input<String> singleInputRecord : input) {
                ((TestInputTopic)testInputTopicMap.get(singleInputRecord.topic)).pipeInput(singleInputRecord.record.key, singleInputRecord.record.value, baseTimestamp + singleInputRecord.timestamp);
                List<TestRecord<Long, String>> expected = resultIterator.next();
                if (expected != null) {
                    LinkedList<TestRecord> updatedExpected = new LinkedList<TestRecord>();
                    for (TestRecord<Long, String> record : expected) {
                        updatedExpected.add(new TestRecord(record.key(), record.value(), null, Long.valueOf(baseTimestamp + record.timestamp())));
                    }
                    List output = outputTopic.readRecordsToList();
                    MatcherAssert.assertThat((Object)output, (Matcher)IsEqual.equalTo(updatedExpected));
                    expectedFinalResult = (TestRecord)updatedExpected.get(expected.size() - 1);
                    continue;
                }
                List output = outputTopic.readRecordsToList();
                MatcherAssert.assertThat((Object)output, (Matcher)IsEqual.equalTo(Collections.emptyList()));
            }
            if (storeName != null) {
                this.checkQueryableStore(storeName, expectedFinalResult, driver);
            }
        }
    }

    void runTestWithDriver(List<Input<String>> input, TestRecord<Long, String> expectedFinalResult, String storeName, Properties streamsConfig, Topology topology) {
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, streamsConfig);){
            TestInputTopic right = driver.createInputTopic(INPUT_TOPIC_RIGHT, (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(INPUT_TOPIC_LEFT, (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT_TOPIC, (Deserializer)new LongDeserializer(), (Deserializer)new StringDeserializer());
            HashMap<String, TestInputTopic> testInputTopicMap = new HashMap<String, TestInputTopic>();
            testInputTopicMap.put(INPUT_TOPIC_RIGHT, right);
            testInputTopicMap.put(INPUT_TOPIC_LEFT, left);
            long baseTimestamp = this.time.milliseconds();
            for (Input<String> singleInputRecord : input) {
                ((TestInputTopic)testInputTopicMap.get(singleInputRecord.topic)).pipeInput(singleInputRecord.record.key, singleInputRecord.record.value, baseTimestamp + singleInputRecord.timestamp);
            }
            TestRecord updatedExpectedFinalResult = new TestRecord(expectedFinalResult.key(), expectedFinalResult.value(), null, Long.valueOf(baseTimestamp + expectedFinalResult.timestamp()));
            List output = outputTopic.readRecordsToList();
            MatcherAssert.assertThat(output.get(output.size() - 1), (Matcher)IsEqual.equalTo((Object)updatedExpectedFinalResult));
            if (storeName != null) {
                this.checkQueryableStore(storeName, (TestRecord<Long, String>)updatedExpectedFinalResult, driver);
            }
        }
    }

    void runSelfJoinTestWithDriver(List<List<TestRecord<Long, String>>> expectedResult, Properties streamsConfig, Topology topology) {
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, streamsConfig);){
            long firstTimestamp;
            TestInputTopic left = driver.createInputTopic(INPUT_TOPIC_LEFT, (Serializer)new LongSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT_TOPIC, (Deserializer)new LongDeserializer(), (Deserializer)new StringDeserializer());
            long eventTimestamp = firstTimestamp = this.time.milliseconds();
            Iterator<List<TestRecord<Long, String>>> resultIterator = expectedResult.iterator();
            for (Input<String> singleInputRecord : this.leftInput) {
                left.pipeInput(singleInputRecord.record.key, singleInputRecord.record.value, ++eventTimestamp);
                List<TestRecord<Long, String>> expected = resultIterator.next();
                if (expected == null) continue;
                LinkedList<TestRecord> updatedExpected = new LinkedList<TestRecord>();
                for (TestRecord<Long, String> record : expected) {
                    updatedExpected.add(new TestRecord(record.key(), record.value(), null, Long.valueOf(firstTimestamp + record.timestamp())));
                }
                List output = outputTopic.readRecordsToList();
                MatcherAssert.assertThat((Object)output, (Matcher)IsEqual.equalTo(updatedExpected));
            }
        }
    }

    private void checkQueryableStore(String queryableName, TestRecord<Long, String> expectedFinalResult, TopologyTestDriver driver) {
        KeyValueStore store = driver.getTimestampedKeyValueStore(queryableName);
        try (KeyValueIterator all = store.all();){
            KeyValue onlyEntry = (KeyValue)all.next();
            MatcherAssert.assertThat((Object)onlyEntry.key, (Matcher)Is.is((Object)expectedFinalResult.key()));
            MatcherAssert.assertThat((Object)((ValueAndTimestamp)onlyEntry.value).value(), (Matcher)Is.is((Object)expectedFinalResult.value()));
            MatcherAssert.assertThat((Object)((ValueAndTimestamp)onlyEntry.value).timestamp(), (Matcher)Is.is((Object)expectedFinalResult.timestamp()));
            MatcherAssert.assertThat((Object)all.hasNext(), (Matcher)Is.is((Object)false));
        }
    }

    protected static final class Input<V> {
        String topic;
        KeyValue<Long, V> record;
        long timestamp;

        Input(String topic, V value, long timestamp) {
            this.topic = topic;
            this.record = KeyValue.pair((Object)0L, value);
            this.timestamp = timestamp;
        }

        Input(String topic, Long key, V value, long timestamp) {
            this.topic = topic;
            this.record = KeyValue.pair((Object)key, value);
            this.timestamp = timestamp;
        }
    }
}

