/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

@Tag(value="integration")
@Timeout(value=600L)
public class KTableKTableForeignKeyJoinMaterializationIntegrationTest {
    private static final String LEFT_TABLE = "left_table";
    private static final String RIGHT_TABLE = "right_table";
    private static final String OUTPUT = "output-topic";
    private Properties streamsConfig;

    @BeforeEach
    public void before() {
        this.streamsConfig = Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath())}));
    }

    @ParameterizedTest
    @CsvSource(value={"false, false", "true, false", "true, true"})
    public void shouldEmitTombstoneWhenDeletingNonJoiningRecords(boolean materialized, boolean queryable) {
        Topology topology = this.getTopology(this.streamsConfig, "store", materialized, queryable);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            if (materialized && queryable) {
                MatcherAssert.assertThat(KTableKTableForeignKeyJoinMaterializationIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            }
            left.pipeInput((Object)"lhs1", (Object)null);
            if (materialized && queryable) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                MatcherAssert.assertThat(KTableKTableForeignKeyJoinMaterializationIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            } else {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null)})));
            }
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            if (materialized && queryable) {
                MatcherAssert.assertThat(KTableKTableForeignKeyJoinMaterializationIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            }
        }
    }

    private static Map<String, String> asMap(KeyValueStore<String, String> store) {
        HashMap<String, String> result = new HashMap<String, String>();
        store.all().forEachRemaining(kv -> {
            String cfr_ignored_0 = (String)result.put((String)kv.key, (String)kv.value);
        });
        return result;
    }

    private Topology getTopology(Properties streamsConfig, String queryableStoreName, boolean materialized, boolean queryable) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable left = builder.table(LEFT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable right = builder.table(RIGHT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        Function<String, String> extractor = value -> value.split("\\|")[1];
        ValueJoiner joiner = (value1, value2) -> "(" + value1 + "," + value2 + ")";
        Materialized materializedStore = queryable ? Materialized.as((String)queryableStoreName).withValueSerde(Serdes.String()) : Materialized.with(null, (Serde)Serdes.String());
        KTable joinResult = materialized ? left.join(right, extractor, joiner, materializedStore) : left.join(right, extractor, joiner);
        joinResult.toStream().to(OUTPUT, Produced.with(null, (Serde)Serdes.String()));
        return builder.build(streamsConfig);
    }
}

