/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.MockMapper;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
@Timeout(value=600L)
public class StreamStreamJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private static final String APP_ID = "stream-stream-join-integration-test";

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSelfJoin(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-selfJoin");
        streamsConfig.put("topology.optimization", "all");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-A", null, Long.valueOf(2L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-A", null, Long.valueOf(3L)), new TestRecord((Object)0L, (Object)"A-B", null, Long.valueOf(3L)), new TestRecord((Object)0L, (Object)"B-B", null, Long.valueOf(3L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-A", null, Long.valueOf(5L)), new TestRecord((Object)0L, (Object)"C-B", null, Long.valueOf(5L)), new TestRecord((Object)0L, (Object)"A-C", null, Long.valueOf(5L)), new TestRecord((Object)0L, (Object)"B-C", null, Long.valueOf(5L)), new TestRecord((Object)0L, (Object)"C-C", null, Long.valueOf(5L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"D-A", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"D-B", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"D-C", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"A-D", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"B-D", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"C-D", null, Long.valueOf(7L)), new TestRecord((Object)0L, (Object)"D-D", null, Long.valueOf(7L))));
        leftStream.join(leftStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runSelfJoinTestWithDriver(expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-inner");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), null, null);
        leftStream.join(rightStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInnerRepartitioned(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-inner-repartitioned");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), null, null);
        leftStream.map(MockMapper.noOpKeyValueMapper()).join(rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeft(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-left");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), Arrays.asList(new TestRecord(null, (Object)"E-null", null, Long.valueOf(16L))), null);
        leftStream.leftJoin(rightStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLeftRepartitioned(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-left-repartitioned");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), Arrays.asList(new TestRecord(null, (Object)"E-null", null, Long.valueOf(16L))), null);
        leftStream.map(MockMapper.noOpKeyValueMapper()).leftJoin(rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuter(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-outer");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), Arrays.asList(new TestRecord(null, (Object)"E-null", null, Long.valueOf(16L))), Arrays.asList(new TestRecord(null, (Object)"null-e", null, Long.valueOf(17L))));
        leftStream.outerJoin(rightStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOuterRepartitioned(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-outer");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))), Arrays.asList(new TestRecord(null, (Object)"E-null", null, Long.valueOf(16L))), Arrays.asList(new TestRecord(null, (Object)"null-e", null, Long.valueOf(17L))));
        leftStream.map(MockMapper.noOpKeyValueMapper()).outerJoin(rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiInner(boolean cacheEnabled) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream leftStream = builder.stream("inputTopicLeft");
        KStream rightStream = builder.stream("inputTopicRight");
        Properties streamsConfig = this.setupConfigsAndUtils(cacheEnabled);
        streamsConfig.put("application.id", "stream-stream-join-integration-test-multi-inner");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-b-a", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-a", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"A-a-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-a-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"A-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-a-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-a-b", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b-a", null, Long.valueOf(9L)), new TestRecord((Object)0L, (Object)"C-b-b", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-c-a", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"A-c-b", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c-a", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c-b", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-a", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-b", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"A-a-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-a-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"A-b-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-b-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-a-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-b-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"A-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"B-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-d-a", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-d-b", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-d-c", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d-a", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d-b", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d-c", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d-a", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d-b", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d-c", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-a-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-a-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-b-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-b-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-a-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-b-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-c-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-c-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-c-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"A-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"B-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"C-d-d", null, Long.valueOf(14L))), Arrays.asList(new TestRecord((Object)0L, (Object)"D-a-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-a-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-a-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-a-d", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-b-d", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-c-d", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d-a", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d-b", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d-c", null, Long.valueOf(15L)), new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))), null, null);
        leftStream.join(rightStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).join(rightStream, this.valueJoiner, JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofHours(24L))).to("outputTopic");
        this.runTestWithDriver(this.inputWithoutOutOfOrderData, expectedResult, streamsConfig, builder.build(streamsConfig));
    }
}

