/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeWindowedSerializerTest {
    private final TimeWindowedSerializer<?> timeWindowedSerializer = new TimeWindowedSerializer(Serdes.String().serializer());
    private final Map<String, String> props = new HashMap<String, String>();

    @Test
    public void testTimeWindowedSerializerConstructor() {
        this.timeWindowedSerializer.configure(this.props, true);
        Serializer inner = this.timeWindowedSerializer.innerSerializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner serializer should be not null");
        Assertions.assertInstanceOf(StringSerializer.class, (Object)inner, (String)"Inner serializer type should be StringSerializer");
    }

    @Test
    public void shouldSetWindowedInnerClassSerialiserThroughConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        TimeWindowedSerializer serializer = new TimeWindowedSerializer();
        serializer.configure(this.props, false);
        Assertions.assertInstanceOf(ByteArraySerializer.class, (Object)serializer.innerSerializer());
    }

    @Test
    public void shouldThrowErrorIfWindowedInnerClassSerialiserIsNotSet() {
        TimeWindowedSerializer serializer = new TimeWindowedSerializer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> serializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfWindowedInnerClassSerialisersConflictInConstructorAndConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.timeWindowedSerializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowConfigExceptionWhenInvalidWindowedInnerClassSerialiserSupplied() {
        this.props.put("windowed.inner.class.serde", "some.non.existent.class");
        Assertions.assertThrows(ConfigException.class, () -> this.timeWindowedSerializer.configure(this.props, false));
    }
}

