/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.FullChangeSerde;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

public class FullChangeSerdeTest {
    private final FullChangeSerde<String> serde = FullChangeSerde.wrap((Serde)Serdes.String());

    private static byte[] mergeChangeArraysIntoSingleLegacyFormattedArray(Change<byte[]> serialChange) {
        if (serialChange == null) {
            return null;
        }
        int oldSize = serialChange.oldValue == null ? -1 : ((byte[])serialChange.oldValue).length;
        int newSize = serialChange.newValue == null ? -1 : ((byte[])serialChange.newValue).length;
        ByteBuffer buffer = ByteBuffer.allocate(8 + Math.max(0, oldSize) + Math.max(0, newSize));
        buffer.putInt(oldSize);
        if (serialChange.oldValue != null) {
            buffer.put((byte[])serialChange.oldValue);
        }
        buffer.putInt(newSize);
        if (serialChange.newValue != null) {
            buffer.put((byte[])serialChange.newValue);
        }
        return buffer.array();
    }

    @Test
    public void shouldRoundTripNull() {
        MatcherAssert.assertThat((Object)this.serde.serializeParts(null, null), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)FullChangeSerdeTest.mergeChangeArraysIntoSingleLegacyFormattedArray(null), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays(null), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.serde.deserializeParts(null, null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldRoundTripNullChange() {
        MatcherAssert.assertThat((Object)this.serde.serializeParts(null, new Change(null, null)), (Matcher)Is.is((Object)new Change(null, null)));
        MatcherAssert.assertThat((Object)this.serde.deserializeParts(null, new Change(null, null)), (Matcher)Is.is((Object)new Change(null, null)));
        byte[] legacyFormat = FullChangeSerdeTest.mergeChangeArraysIntoSingleLegacyFormattedArray((Change<byte[]>)new Change(null, null));
        MatcherAssert.assertThat((Object)FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays((byte[])legacyFormat), (Matcher)Is.is((Object)new Change(null, null)));
    }

    @Test
    public void shouldRoundTripOldNull() {
        Change serialized = this.serde.serializeParts(null, new Change((Object)"new", null));
        byte[] legacyFormat = FullChangeSerdeTest.mergeChangeArraysIntoSingleLegacyFormattedArray((Change<byte[]>)serialized);
        Change decomposedLegacyFormat = FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays((byte[])legacyFormat);
        MatcherAssert.assertThat((Object)this.serde.deserializeParts(null, decomposedLegacyFormat), (Matcher)Is.is((Object)new Change((Object)"new", null)));
    }

    @Test
    public void shouldRoundTripNewNull() {
        Change serialized = this.serde.serializeParts(null, new Change(null, (Object)"old"));
        byte[] legacyFormat = FullChangeSerdeTest.mergeChangeArraysIntoSingleLegacyFormattedArray((Change<byte[]>)serialized);
        Change decomposedLegacyFormat = FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays((byte[])legacyFormat);
        MatcherAssert.assertThat((Object)this.serde.deserializeParts(null, decomposedLegacyFormat), (Matcher)Is.is((Object)new Change(null, (Object)"old")));
    }

    @Test
    public void shouldRoundTripChange() {
        Change serialized = this.serde.serializeParts(null, new Change((Object)"new", (Object)"old"));
        byte[] legacyFormat = FullChangeSerdeTest.mergeChangeArraysIntoSingleLegacyFormattedArray((Change<byte[]>)serialized);
        Change decomposedLegacyFormat = FullChangeSerde.decomposeLegacyFormattedArrayIntoChangeArrays((byte[])legacyFormat);
        MatcherAssert.assertThat((Object)this.serde.deserializeParts(null, decomposedLegacyFormat), (Matcher)Is.is((Object)new Change((Object)"new", (Object)"old")));
    }
}

