/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KGroupedTableImplTest {
    private final StreamsBuilder builder = new StreamsBuilder();
    private static final String INVALID_STORE_NAME = "~foo bar~";
    private KGroupedTable<String, String> groupedTable;
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.Integer());
    private final String topic = "input";

    @BeforeEach
    public void before() {
        this.groupedTable = this.builder.table("blah", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper());
    }

    @Test
    public void shouldNotAllowInvalidStoreNameOnAggregate() {
        Assertions.assertThrows(TopologyException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)INVALID_STORE_NAME)));
    }

    @Test
    public void shouldNotAllowNullInitializerOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldNotAllowNullAdderOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldNotAllowNullSubtractorOnAggregate() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldNotAllowNullAdderOnReduce() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldNotAllowNullSubtractorOnReduce() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.reduce(MockReducer.STRING_ADDER, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldNotAllowInvalidStoreNameOnReduce() {
        Assertions.assertThrows(TopologyException.class, () -> this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, Materialized.as((String)INVALID_STORE_NAME)));
    }

    private MockApiProcessorSupplier<String, Integer, Void, Void> getReducedResults(KTable<String, Integer> inputKTable) {
        MockApiProcessorSupplier<String, Integer, Void, Void> supplier = new MockApiProcessorSupplier<String, Integer, Void, Void>();
        inputKTable.toStream().process(supplier, new String[0]);
        return supplier;
    }

    private void assertReduced(Map<String, ValueAndTimestamp<Integer>> reducedResults, String topic, TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(topic, (Serializer)new StringSerializer(), (Serializer)new DoubleSerializer());
        inputTopic.pipeInput((Object)"A", (Object)1.1, 10L);
        inputTopic.pipeInput((Object)"B", (Object)2.2, 11L);
        Assertions.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)10L), reducedResults.get("A"));
        Assertions.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)11L), reducedResults.get("B"));
        inputTopic.pipeInput((Object)"A", (Object)2.6, 30L);
        inputTopic.pipeInput((Object)"B", (Object)1.3, 30L);
        inputTopic.pipeInput((Object)"A", (Object)5.7, 50L);
        inputTopic.pipeInput((Object)"B", (Object)6.2, 20L);
        Assertions.assertEquals((Object)ValueAndTimestamp.make((Object)5, (long)50L), reducedResults.get("A"));
        Assertions.assertEquals((Object)ValueAndTimestamp.make((Object)6, (long)30L), reducedResults.get("B"));
    }

    @Test
    public void shouldReduce() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double()), Materialized.as((String)"store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, Materialized.as((String)"reduced"));
        MockApiProcessorSupplier<String, Integer, Void, Void> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            Assertions.assertEquals((Object)reduced.queryableStoreName(), (Object)"reduced");
        }
    }

    @Test
    public void shouldReduceWithInternalStoreName() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double()), Materialized.as((String)"store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR);
        MockApiProcessorSupplier<String, Integer, Void, Void> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            Assertions.assertNull((Object)reduced.queryableStoreName());
        }
    }

    @Test
    public void shouldReduceAndMaterializeResults() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, Materialized.as((String)"reduce").withKeySerde(Serdes.String()).withValueSerde(Serdes.Integer()));
        MockApiProcessorSupplier<String, Integer, Void, Void> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            KeyValueStore reduce = driver.getKeyValueStore("reduce");
            MatcherAssert.assertThat((Object)reduce.get((Object)"A"), (Matcher)CoreMatchers.equalTo((Object)5));
            MatcherAssert.assertThat((Object)reduce.get((Object)"B"), (Matcher)CoreMatchers.equalTo((Object)6));
            reduce = driver.getTimestampedKeyValueStore("reduce");
            MatcherAssert.assertThat((Object)reduce.get((Object)"A"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)5, (long)50L)));
            MatcherAssert.assertThat((Object)reduce.get((Object)"B"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)6, (long)30L)));
        }
    }

    @Test
    public void shouldCountAndMaterializeResults() {
        this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper(), Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).count(Materialized.as((String)"count").withKeySerde(Serdes.String()).withValueSerde(Serdes.Long()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData("input", driver);
            KeyValueStore counts = driver.getKeyValueStore("count");
            MatcherAssert.assertThat((Object)counts.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)3L));
            MatcherAssert.assertThat((Object)counts.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)2L));
            counts = driver.getTimestampedKeyValueStore("count");
            MatcherAssert.assertThat((Object)counts.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)3L, (long)50L)));
            MatcherAssert.assertThat((Object)counts.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)60L)));
        }
    }

    @Test
    public void shouldAggregateAndMaterializeResults() {
        this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper(), Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"aggregate").withValueSerde(Serdes.String()).withKeySerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData("input", driver);
            KeyValueStore aggregate = driver.getKeyValueStore("aggregate");
            MatcherAssert.assertThat((Object)aggregate.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)"0+1+1+1"));
            MatcherAssert.assertThat((Object)aggregate.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)"0+2+2"));
            aggregate = driver.getTimestampedKeyValueStore("aggregate");
            MatcherAssert.assertThat((Object)aggregate.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+1+1+1", (long)50L)));
            MatcherAssert.assertThat((Object)aggregate.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+2+2", (long)60L)));
        }
    }

    @Test
    public void shouldThrowNullPointOnCountWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.count((Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnReduceWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, null));
    }

    @Test
    public void shouldThrowNullPointerOnReduceWhenAdderIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnReduceWhenSubtractorIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.reduce(MockReducer.STRING_ADDER, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateWhenInitializerIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateWhenAdderIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateWhenSubtractorIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateWhenMaterializedIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, (Materialized)null));
    }

    private void processData(String topic, TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(topic, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        inputTopic.pipeInput((Object)"A", (Object)"1", 10L);
        inputTopic.pipeInput((Object)"B", (Object)"1", 50L);
        inputTopic.pipeInput((Object)"C", (Object)"1", 30L);
        inputTopic.pipeInput((Object)"D", (Object)"2", 40L);
        inputTopic.pipeInput((Object)"E", (Object)"2", 60L);
    }
}

