/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KStreamForeachTest {
    private final String topicName = "topic";
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testForeach() {
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        List<KeyValue> expectedRecords = Arrays.asList(new KeyValue((Object)0, (Object)"ZERO"), new KeyValue((Object)2, (Object)"ONE"), new KeyValue((Object)4, (Object)"TWO"), new KeyValue((Object)6, (Object)"THREE"));
        ArrayList actualRecords = new ArrayList();
        ForeachAction action = (key, value) -> actualRecords.add(new KeyValue((Object)(key * 2), (Object)value.toUpperCase(Locale.ROOT)));
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.foreach(action);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
            for (KeyValue record : inputRecords) {
                inputTopic.pipeInput(record.key, record.value);
            }
        }
        Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecords.size());
        for (int i = 0; i < expectedRecords.size(); ++i) {
            KeyValue expectedRecord = expectedRecords.get(i);
            KeyValue actualRecord = (KeyValue)actualRecords.get(i);
            Assertions.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
    }

    @Test
    public void testTypeVariance() {
        ForeachAction consume = (key, value) -> {};
        new StreamsBuilder().stream("emptyTopic").foreach(consume);
    }
}

