/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KStreamSelectKeyTest {
    private final String topicName = "topic_key_select";
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.Integer());

    @Test
    public void testSelectKey() {
        StreamsBuilder builder = new StreamsBuilder();
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        KeyValueTimestamp[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<String, Integer>("ONE", 1, 0L), new KeyValueTimestamp<String, Integer>("TWO", 2, 0L), new KeyValueTimestamp<String, Integer>("THREE", 3, 0L)};
        int[] expectedValues = new int[]{1, 2, 3};
        KStream stream = builder.stream("topic_key_select", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        stream.selectKey((key, value) -> (String)keyMap.get(value)).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic_key_select", (Serializer)new StringSerializer(), (Serializer)new IntegerSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            for (int expectedValue : expectedValues) {
                inputTopic.pipeInput((Object)expectedValue);
            }
        }
        Assertions.assertEquals((int)3, (int)supplier.theCapturedProcessor().processed().size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], supplier.theCapturedProcessor().processed().get(i));
        }
    }

    @Test
    public void testTypeVariance() {
        new StreamsBuilder().stream("empty").foreach((key, value) -> {});
    }
}

