/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.KStreamTransformValues;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.NoOpValueTransformerWithKeySupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KStreamTransformValuesTest {
    private final String topicName = "topic";
    private final MockProcessorSupplier<Integer, Integer, Void, Void> supplier = new MockProcessorSupplier();
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.Integer());
    private InternalProcessorContext context = (InternalProcessorContext)Mockito.mock(InternalProcessorContext.class);

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerSupplier valueTransformerSupplier = () -> new ValueTransformer<Number, Integer>(){
            private int total = 0;

            public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            }

            public Integer transform(Number value) {
                this.total += value.intValue();
                return this.total;
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
                inputTopic.pipeInput((Object)expectedKey, (Object)(expectedKey * 10), (long)expectedKey / 2L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, Integer>(1, 10, 0L), new KeyValueTimestamp<Integer, Integer>(10, 110, 5L), new KeyValueTimestamp<Integer, Integer>(100, 1110, 50L), new KeyValueTimestamp<Integer, Integer>(1000, 11110, 500L)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed().toArray());
    }

    @Test
    public void testTransformWithKey() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerWithKeySupplier valueTransformerSupplier = () -> new ValueTransformerWithKey<Integer, Number, Integer>(){
            private int total = 0;

            public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            }

            public Integer transform(Integer readOnlyKey, Number value) {
                this.total += value.intValue() + readOnlyKey;
                return this.total;
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
            for (int expectedKey : expectedKeys) {
                inputTopic.pipeInput((Object)expectedKey, (Object)(expectedKey * 10), (long)expectedKey / 2L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, Integer>(1, 11, 0L), new KeyValueTimestamp<Integer, Integer>(10, 121, 5L), new KeyValueTimestamp<Integer, Integer>(100, 1221, 50L), new KeyValueTimestamp<Integer, Integer>(1000, 12221, 500L)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed().toArray());
    }

    @Test
    public void shouldInitializeTransformerWithForwardDisabledProcessorContext() {
        NoOpValueTransformerWithKeySupplier transformer = new NoOpValueTransformerWithKeySupplier();
        KStreamTransformValues transformValues = new KStreamTransformValues(transformer);
        Processor processor = transformValues.get();
        processor.init((ProcessorContext)this.context);
        MatcherAssert.assertThat((Object)transformer.context, (Matcher)CoreMatchers.isA(ForwardingDisabledProcessorContext.class));
    }
}

