/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NamedInternalTest {
    private static final String TEST_PREFIX = "prefix-";
    private static final String TEST_VALUE = "default-value";
    private static final String TEST_SUFFIX = "-suffix";

    @Test
    public void shouldSuffixNameOrReturnProviderValue() {
        String name = "foo";
        TestNameProvider provider = new TestNameProvider();
        Assertions.assertEquals((Object)"foo-suffix", (Object)NamedInternal.with((String)"foo").suffixWithOrElseGet(TEST_SUFFIX, (InternalNameProvider)provider, TEST_PREFIX));
        Assertions.assertEquals((Object)"prefix-PROCESSOR-1", (Object)NamedInternal.with(null).suffixWithOrElseGet(TEST_SUFFIX, (InternalNameProvider)provider, TEST_PREFIX));
    }

    @Test
    public void shouldGenerateWithPrefixGivenEmptyName() {
        String prefix = "KSTREAM-MAP-";
        Assertions.assertEquals((Object)"KSTREAM-MAP-PROCESSOR-0", (Object)NamedInternal.with(null).orElseGenerateWithPrefix((InternalNameProvider)new TestNameProvider(), "KSTREAM-MAP-"));
    }

    @Test
    public void shouldNotGenerateWithPrefixGivenValidName() {
        String validName = "validName";
        Assertions.assertEquals((Object)"validName", (Object)NamedInternal.with((String)"validName").orElseGenerateWithPrefix((InternalNameProvider)new TestNameProvider(), "KSTREAM-MAP-"));
    }

    private static class TestNameProvider
    implements InternalNameProvider {
        int index = 0;

        private TestNameProvider() {
        }

        public String newProcessorName(String prefix) {
            return prefix + "PROCESSOR-" + this.index++;
        }

        public String newStoreName(String prefix) {
            return prefix + "STORE-" + this.index++;
        }
    }
}

