/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnlimitedWindowTest {
    private long start = 50L;
    private final UnlimitedWindow window = new UnlimitedWindow(this.start);
    private final SessionWindow sessionWindow = new SessionWindow(this.start, this.start);

    @Test
    public void shouldAlwaysOverlap() {
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start - 1L)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start)));
        Assertions.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start + 1L)));
    }

    @Test
    public void cannotCompareUnlimitedWindowWithDifferentWindowType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.sessionWindow));
    }
}

