/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ResponseJoinProcessorSupplierTest;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionSendProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.apache.kafka.test.MockInternalNewProcessorContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubscriptionSendProcessorSupplierTest {
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> leftJoinProcessor = new SubscriptionSendProcessorSupplier(LeftValue::getForeignKey, () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), true).get();
    private final Processor<String, Change<LeftValue>, String, SubscriptionWrapper<String>> innerJoinProcessor = new SubscriptionSendProcessorSupplier(LeftValue::getForeignKey, () -> "subscription-topic-fk", () -> "value-serde-topic", Serdes.String(), (Serializer)new LeftValueSerializer(), false).get();
    private final String pk = "pk";
    private final String fk1 = "fk1";
    private final String fk2 = "fk2";

    @Test
    public void leftJoinShouldPropagateNewPrimaryKeyWithNonNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNewPrimaryKeyWithNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeOfFKFromNonNullToNonNullValue() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNewRecordOfUnchangedFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeOfFKFromNonNullToNullValue() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeFromNullFKToNonNullFKValue() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateChangeFromNullFKToNullFKValue() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateDeletionOfAPrimaryKey() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateDeletionOfAPrimaryKeyThatHadNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record(null, (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void leftJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.leftJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.leftJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateNewPrimaryKey() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldNotPropagateNewPrimaryKeyWithNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
        Assertions.assertEquals((Object)1.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsTotalMetric(context));
        Assertions.assertNotEquals((Object)0.0, (Object)ResponseJoinProcessorSupplierTest.getDroppedRecordsRateMetric(context));
    }

    @Test
    public void innerJoinShouldDeleteOldAndPropagateNewFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk2");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(1)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk2", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateNothingWhenOldAndNewFKIsNull() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateChangeFromNullFKToNonNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldDeleteAndPropagateChangeFromNonNullFKToNullFK() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue(null);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateUnchangedFKOnlyIfFKExistsInRightTable() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        LeftValue leftRecordValue = new LeftValue("fk1");
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change((Object)leftRecordValue, (Object)leftRecordValue), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(SubscriptionSendProcessorSupplierTest.hash(leftRecordValue), SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldPropagateDeletionOfPrimaryKey() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue("fk1")), 0L));
        MatcherAssert.assertThat((Object)context.forwarded().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MockProcessorContext.CapturedForward)context.forwarded().get(0)).record(), (Matcher)Matchers.is((Object)new Record((Object)"fk1", (Object)new SubscriptionWrapper(null, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk", Integer.valueOf(0)), 0L)));
    }

    @Test
    public void innerJoinShouldNotPropagateDeletionOfPrimaryKeyWhenPreviousFKIsNull() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, (Object)new LeftValue(null)), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    @Test
    public void innerJoinShouldPropagateNothingWhenOldAndNewLeftValueIsNull() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.innerJoinProcessor.init(context);
        context.setRecordMetadata("topic", 0, 0L);
        this.innerJoinProcessor.process(new Record((Object)"pk", (Object)new Change(null, null), 0L));
        MatcherAssert.assertThat((Object)context.forwarded(), (Matcher)Matchers.empty());
    }

    private static long[] hash(LeftValue value) {
        return Murmur3.hash128((byte[])new LeftValueSerializer().serialize("value-serde-topic", value));
    }

    private static final class LeftValue {
        private final String foreignKey;

        public LeftValue(String value) {
            this.foreignKey = value;
        }

        public String getForeignKey() {
            return this.foreignKey;
        }
    }

    private static class LeftValueSerializer
    implements Serializer<LeftValue> {
        private LeftValueSerializer() {
        }

        public byte[] serialize(String topic, LeftValue data) {
            if (data == null) {
                return null;
            }
            if (data.foreignKey == null) {
                return "null".getBytes();
            }
            return new StringSerializer().serialize(topic, data.getForeignKey());
        }
    }
}

