/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.TableSourceNode;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class TableSourceNodeTest {
    private static final String STORE_NAME = "store-name";
    private static final String TOPIC = "input-topic";
    private InternalTopologyBuilder topologyBuilder = (InternalTopologyBuilder)Mockito.mock(InternalTopologyBuilder.class);

    @Test
    public void shouldConnectStateStoreToInputTopicIfInputTopicIsUsedAsChangelog() {
        boolean shouldReuseSourceTopicForChangelog = true;
        this.buildTableSourceNode(true);
        ((InternalTopologyBuilder)Mockito.verify((Object)this.topologyBuilder)).connectSourceStoreAndTopic(STORE_NAME, TOPIC);
    }

    @Test
    public void shouldConnectStateStoreToChangelogTopic() {
        boolean shouldReuseSourceTopicForChangelog = false;
        this.buildTableSourceNode(false);
        ((InternalTopologyBuilder)Mockito.verify((Object)this.topologyBuilder, (VerificationMode)Mockito.never())).connectSourceStoreAndTopic(STORE_NAME, TOPIC);
    }

    private void buildTableSourceNode(boolean shouldReuseSourceTopicForChangelog) {
        TableSourceNode.TableSourceNodeBuilder tableSourceNodeBuilder = TableSourceNode.tableSourceNodeBuilder();
        TableSourceNode tableSourceNode = tableSourceNodeBuilder.withTopic(TOPIC).withMaterializedInternal(new MaterializedInternal(Materialized.as((String)STORE_NAME))).withConsumedInternal(new ConsumedInternal(Consumed.as((String)"node-name"))).withProcessorParameters(new ProcessorParameters((ProcessorSupplier)new KTableSource(STORE_NAME, STORE_NAME), null)).build();
        tableSourceNode.reuseSourceTopicForChangeLog(shouldReuseSourceTopicForChangelog);
        tableSourceNode.writeToTopology(this.topologyBuilder);
    }
}

