/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManagerUtil;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.test.MockKeyValueStore;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StateManagerUtilTest {
    @Mock
    private ProcessorStateManager stateManager;
    @Mock
    private StateDirectory stateDirectory;
    @Mock
    private ProcessorTopology topology;
    @Mock
    private InternalProcessorContext processorContext;
    private Logger logger = new LogContext("test").logger(AbstractTask.class);
    private final TaskId taskId = new TaskId(0, 0);

    @Test
    public void testRegisterStateStoreWhenTopologyEmpty() {
        Mockito.when((Object)this.topology.stateStores()).thenReturn(Collections.emptyList());
        StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext);
    }

    @Test
    public void testRegisterStateStoreFailToLockStateDirectory() {
        Mockito.when((Object)this.topology.stateStores()).thenReturn(Collections.singletonList(new MockKeyValueStore("store", false)));
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)false);
        LockException thrown = (LockException)Assertions.assertThrows(LockException.class, () -> StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext));
        Assertions.assertEquals((Object)"logPrefix:Failed to lock the state directory for task 0_0", (Object)thrown.getMessage());
    }

    @Test
    public void testRegisterStateStores() {
        MockKeyValueStore store1 = new MockKeyValueStore("store1", false);
        MockKeyValueStore store2 = new MockKeyValueStore("store2", false);
        List<StateStore> stateStores = Arrays.asList(store1, store2);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager});
        Mockito.when((Object)this.topology.stateStores()).thenReturn(stateStores);
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        Mockito.when((Object)this.stateDirectory.directoryForTaskIsEmpty(this.taskId)).thenReturn((Object)true);
        Mockito.when((Object)this.topology.stateStores()).thenReturn(stateStores);
        StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).registerStateStores(stateStores, this.processorContext);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).initializeStoreOffsetsFromCheckpoint(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager});
    }

    @Test
    public void testCloseStateManagerClean() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager, this.stateDirectory});
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).close();
        ((StateDirectory)inOrder.verify((Object)this.stateDirectory)).unlock(this.taskId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager, this.stateDirectory});
    }

    @Test
    public void testCloseStateManagerThrowsExceptionWhenClean() {
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        ((ProcessorStateManager)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessorStateException("state manager failed to close")}).when((Object)this.stateManager)).close();
        ProcessorStateException thrown = (ProcessorStateException)Assertions.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        Assertions.assertEquals((Object)"state manager failed to close", (Object)thrown.getMessage());
        ((StateDirectory)Mockito.verify((Object)this.stateDirectory)).unlock(this.taskId);
    }

    @Test
    public void testCloseStateManagerThrowsExceptionWhenDirty() {
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        ((ProcessorStateManager)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessorStateException("state manager failed to close")}).when((Object)this.stateManager)).close();
        Assertions.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        ((StateDirectory)Mockito.verify((Object)this.stateDirectory)).unlock(this.taskId);
    }

    @Test
    public void testCloseStateManagerWithStateStoreWipeOut() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager, this.stateDirectory});
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        Mockito.when((Object)this.stateManager.baseDir()).thenReturn((Object)TestUtils.tempDirectory((String)"state_store"));
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).close();
        ((StateDirectory)inOrder.verify((Object)this.stateDirectory)).unlock(this.taskId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager, this.stateDirectory});
    }

    @Test
    public void shouldStillWipeStateStoresIfCloseThrowsException() {
        File randomFile = new File("/random/path");
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        ((ProcessorStateManager)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessorStateException("Close failed")}).when((Object)this.stateManager)).close();
        Mockito.when((Object)this.stateManager.baseDir()).thenReturn((Object)randomFile);
        try (MockedStatic utils = Mockito.mockStatic(Utils.class);){
            Assertions.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        }
        ((StateDirectory)Mockito.verify((Object)this.stateDirectory)).unlock(this.taskId);
    }

    @Test
    public void testCloseStateManagerWithStateStoreWipeOutRethrowWrappedIOException() {
        File unknownFile = new File("/unknown/path");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager, this.stateDirectory});
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)true);
        Mockito.when((Object)this.stateManager.baseDir()).thenReturn((Object)unknownFile);
        try (MockedStatic utils = Mockito.mockStatic(Utils.class);){
            utils.when(() -> Utils.delete((File)unknownFile)).thenThrow(new Throwable[]{new IOException("Deletion failed")});
            ProcessorStateException thrown = (ProcessorStateException)Assertions.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
            Assertions.assertEquals(IOException.class, thrown.getCause().getClass());
        }
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).close();
        ((StateDirectory)inOrder.verify((Object)this.stateDirectory)).unlock(this.taskId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager, this.stateDirectory});
    }

    @Test
    public void shouldNotCloseStateManagerIfUnableToLockTaskDirectory() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager, this.stateDirectory});
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)false);
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).taskId();
        ((StateDirectory)inOrder.verify((Object)this.stateDirectory)).lock(this.taskId);
        ((ProcessorStateManager)Mockito.verify((Object)this.stateManager, (VerificationMode)Mockito.never())).close();
        ((ProcessorStateManager)Mockito.verify((Object)this.stateManager, (VerificationMode)Mockito.never())).baseDir();
        ((StateDirectory)Mockito.verify((Object)this.stateDirectory, (VerificationMode)Mockito.never())).unlock(this.taskId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager, this.stateDirectory});
    }

    @Test
    public void shouldNotWipeStateStoresIfUnableToLockTaskDirectory() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.stateManager, this.stateDirectory});
        Mockito.when((Object)this.stateManager.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.stateDirectory.lock(this.taskId)).thenReturn((Object)false);
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        ((ProcessorStateManager)inOrder.verify((Object)this.stateManager)).taskId();
        ((StateDirectory)inOrder.verify((Object)this.stateDirectory)).lock(this.taskId);
        ((ProcessorStateManager)Mockito.verify((Object)this.stateManager, (VerificationMode)Mockito.never())).close();
        ((ProcessorStateManager)Mockito.verify((Object)this.stateManager, (VerificationMode)Mockito.never())).baseDir();
        ((StateDirectory)Mockito.verify((Object)this.stateDirectory, (VerificationMode)Mockito.never())).unlock(this.taskId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateManager, this.stateDirectory});
    }
}

