/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskAndAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TaskAndActionTest {
    TaskAndActionTest() {
    }

    @Test
    public void shouldCreateAddTaskAction() {
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        TaskAndAction addTask = TaskAndAction.createAddTask((Task)task);
        Assertions.assertEquals((Object)TaskAndAction.Action.ADD, (Object)addTask.action());
        Assertions.assertEquals((Object)task, (Object)addTask.task());
        Exception exceptionForTaskId = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((TaskAndAction)addTask).taskId());
        Assertions.assertEquals((Object)"Action type ADD cannot have a task ID!", (Object)exceptionForTaskId.getMessage());
        Exception exceptionForFutureForRemove = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((TaskAndAction)addTask).futureForRemove());
        Assertions.assertEquals((Object)"Action type ADD cannot have a future with a single result!", (Object)exceptionForFutureForRemove.getMessage());
    }

    @Test
    public void shouldCreateRemoveTaskAction() {
        TaskId taskId = new TaskId(0, 0);
        CompletableFuture future = new CompletableFuture();
        TaskAndAction removeTask = TaskAndAction.createRemoveTask((TaskId)taskId, future);
        Assertions.assertEquals((Object)TaskAndAction.Action.REMOVE, (Object)removeTask.action());
        Assertions.assertEquals((Object)taskId, (Object)removeTask.taskId());
        Assertions.assertEquals(future, (Object)removeTask.futureForRemove());
        Exception exceptionForTask = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((TaskAndAction)removeTask).task());
        Assertions.assertEquals((Object)"Action type REMOVE cannot have a task!", (Object)exceptionForTask.getMessage());
    }

    @Test
    public void shouldThrowIfAddTaskActionIsCreatedWithNullTask() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TaskAndAction.createAddTask(null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Task to add is null!"));
    }

    @Test
    public void shouldThrowIfRemoveTaskActionIsCreatedWithNullTaskId() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TaskAndAction.createRemoveTask(null, new CompletableFuture()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Task ID of task to remove is null!"));
    }

    @Test
    public void shouldThrowIfRemoveTaskActionIsCreatedWithNullFuture() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TaskAndAction.createRemoveTask((TaskId)new TaskId(0, 0), null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Future for task to remove is null!"));
    }
}

