/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.state.HostInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentInfoTest {
    private final List<TaskId> activeTasks = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_0);
    private final Map<TaskId, Set<TopicPartition>> standbyTasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});
    private static final List<TaskId> NAMED_ACTIVE_TASKS = Arrays.asList(AssignmentTestUtils.NAMED_TASK_T0_0_1, AssignmentTestUtils.NAMED_TASK_T0_1_0, AssignmentTestUtils.NAMED_TASK_T0_1_0, AssignmentTestUtils.NAMED_TASK_T1_0_1, AssignmentTestUtils.NAMED_TASK_T1_0_1, AssignmentTestUtils.NAMED_TASK_T2_0_0, AssignmentTestUtils.NAMED_TASK_T2_2_0);
    private static final Map<TaskId, Set<TopicPartition>> NAMED_STANDBY_TASKS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0-1", 0), new TopicPartition("t0-2", 0)})), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0-1", 1), new TopicPartition("t0-2", 1)})), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T1_0_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1-1", 0), new TopicPartition("t1-2", 0)}))});
    private final Map<HostInfo, Set<TopicPartition>> activeAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new HostInfo("localhost", 8088), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0", 0), new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)new HostInfo("localhost", 8089), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0", 1), new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});
    private final Map<HostInfo, Set<TopicPartition>> standbyAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new HostInfo("localhost", 8088), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)new HostInfo("localhost", 8089), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});

    @Test
    public void shouldUseLatestSupportedVersionByDefault() {
        AssignmentInfo info = new AssignmentInfo(11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assertions.assertEquals((int)11, (int)info.version());
    }

    @Test
    public void shouldThrowForUnknownVersion1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AssignmentInfo(0, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0));
    }

    @Test
    public void shouldThrowForUnknownVersion2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AssignmentInfo(12, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0));
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        AssignmentInfo info = new AssignmentInfo(1, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(1, -1, this.activeTasks, this.standbyTasks, Collections.emptyMap(), Collections.emptyMap(), 0);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        AssignmentInfo info = new AssignmentInfo(2, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(2, -1, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion3() {
        AssignmentInfo info = new AssignmentInfo(3, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(3, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion4() {
        AssignmentInfo info = new AssignmentInfo(4, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(4, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion5() {
        AssignmentInfo info = new AssignmentInfo(5, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(5, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion6() {
        AssignmentInfo info = new AssignmentInfo(6, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(6, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion7() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(7, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion8() {
        AssignmentInfo info = new AssignmentInfo(8, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(8, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion9() {
        AssignmentInfo info = new AssignmentInfo(9, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(9, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion10() {
        AssignmentInfo info = new AssignmentInfo(10, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(10, 11, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion10WithNamedTopologies() {
        AssignmentInfo info = new AssignmentInfo(10, 11, NAMED_ACTIVE_TASKS, NAMED_STANDBY_TASKS, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertEquals((Object)info, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldNotEncodeAndDecodeNamedTopologiesWithOlderVersion() {
        AssignmentInfo info = new AssignmentInfo(9, 11, NAMED_ACTIVE_TASKS, NAMED_STANDBY_TASKS, this.activeAssignment, this.standbyAssignment, 2);
        Assertions.assertThrows(TaskAssignmentException.class, () -> AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeSmallerCommonlySupportedVersion() {
        int usedVersion = 5;
        int commonlySupportedVersion = 5;
        AssignmentInfo info = new AssignmentInfo(5, 5, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(5, 5, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assertions.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void nextRebalanceTimeShouldBeMaxValueByDefault() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assertions.assertEquals((long)info.nextRebalanceMs(), (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldDecodeDefaultNextRebalanceTime() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assertions.assertEquals((long)info.nextRebalanceMs(), (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldEncodeAndDecodeNextRebalanceTime() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        info.setNextRebalanceTime(1000L);
        Assertions.assertEquals((long)1000L, (long)AssignmentInfo.decode((ByteBuffer)info.encode()).nextRebalanceMs());
    }
}

