/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.DefaultStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StandbyTaskAssignorFactoryTest {
    private static final long ACCEPTABLE_RECOVERY_LAG = 0L;
    private static final int MAX_WARMUP_REPLICAS = 1;
    private static final int NUMBER_OF_STANDBY_REPLICAS = 1;
    private static final long PROBING_REBALANCE_INTERVAL_MS = 60000L;
    private RackAwareTaskAssignor rackAwareTaskAssignor;

    public void setUp(State state, boolean needValidRack) {
        if (state == State.ENABLED || state == State.DISABLED) {
            this.rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.mock(RackAwareTaskAssignor.class);
            if (needValidRack) {
                Mockito.when((Object)this.rackAwareTaskAssignor.validClientRack()).thenReturn((Object)state.equals((Object)State.ENABLED));
            }
        } else {
            this.rackAwareTaskAssignor = null;
        }
    }

    @ParameterizedTest
    @EnumSource(value=State.class)
    public void shouldReturnClientTagAwareStandbyTaskAssignorWhenRackAwareAssignmentTagsIsSet(State state) {
        this.setUp(state, false);
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.singletonList("az")), (RackAwareTaskAssignor)this.rackAwareTaskAssignor);
        Assertions.assertInstanceOf(ClientTagAwareStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
        if (state != State.NULL) {
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).validClientRack();
        }
    }

    @ParameterizedTest
    @EnumSource(value=State.class)
    public void shouldReturnDefaultOrRackAwareStandbyTaskAssignorWhenRackAwareAssignmentTagsIsEmpty(State state) {
        this.setUp(state, true);
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.emptyList()), (RackAwareTaskAssignor)this.rackAwareTaskAssignor);
        if (state == State.ENABLED) {
            Assertions.assertInstanceOf(ClientTagAwareStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).validClientRack();
        } else if (state == State.DISABLED) {
            Assertions.assertInstanceOf(DefaultStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).validClientRack();
        } else {
            Assertions.assertInstanceOf(DefaultStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
        }
    }

    private static AssignmentConfigs newAssignmentConfigs(List<String> rackAwareAssignmentTags) {
        return new AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(1), Long.valueOf(60000L), rackAwareAssignmentTags);
    }

    static enum State {
        DISABLED,
        ENABLED,
        NULL;

    }
}

