/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ApplicationState;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsAssignment;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsState;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.assignment.TaskAssignmentUtils;
import org.apache.kafka.streams.processor.assignment.TaskAssignor;
import org.apache.kafka.streams.processor.assignment.TaskInfo;
import org.apache.kafka.streams.processor.assignment.TaskTopicPartition;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.DefaultKafkaStreamsState;
import org.apache.kafka.streams.processor.internals.assignment.DefaultTaskInfo;
import org.apache.kafka.streams.processor.internals.assignment.DefaultTaskTopicPartition;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TaskAssignmentUtilsTest {
    @Timeout(value=30L)
    @ParameterizedTest
    @ValueSource(strings={"min_traffic", "balance_subtopology"})
    public void shouldOptimizeActiveTaskSimple(String strategy) {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs(strategy, 100, 1, 1, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true, Utils.mkSet((Object[])new String[]{"rack-2"})), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true, Utils.mkSet((Object[])new String[]{"rack-1"}))});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 1, Optional.of("rack-1")), TaskAssignmentUtilsTest.mkStreamState(2, 1, Optional.of("rack-2"))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 1, AssignmentTestUtils.TASK_0_0), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 2, AssignmentTestUtils.TASK_0_1)});
        TaskAssignmentUtils.optimizeRackAwareActiveTasks((TaskAssignmentUtils.RackAwareOptimizationParams)TaskAssignmentUtils.RackAwareOptimizationParams.of((ApplicationState)applicationState), (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        TaskAssignmentUtils.optimizeRackAwareActiveTasks((TaskAssignmentUtils.RackAwareOptimizationParams)TaskAssignmentUtils.RackAwareOptimizationParams.of((ApplicationState)applicationState), (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    @Timeout(value=30L)
    @ParameterizedTest
    @ValueSource(strings={"min_traffic", "balance_subtopology"})
    public void shouldOptimizeStandbyTasksBasic(String strategy) {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs(strategy, 100, 1, 1, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true, Utils.mkSet((Object[])new String[]{"rack-2"})), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true, Utils.mkSet((Object[])new String[]{"rack-3"}))});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.of("rack-1")), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.of("rack-2")), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.of("rack-3"))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.STANDBY, 2, AssignmentTestUtils.TASK_0_1), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.STANDBY, 3, AssignmentTestUtils.TASK_0_0)});
        TaskAssignmentUtils.optimizeRackAwareStandbyTasks((TaskAssignmentUtils.RackAwareOptimizationParams)TaskAssignmentUtils.RackAwareOptimizationParams.of((ApplicationState)applicationState), (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
    }

    @Timeout(value=30L)
    @Test
    public void shouldAssignStandbyTasksWithClientTags() {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs("none", 100, 1, 2, Collections.singletonList("az"));
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true)});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"1")})), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"1")})), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"2")})), TaskAssignmentUtilsTest.mkStreamState(4, 2, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"3")}))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 1, AssignmentTestUtils.TASK_0_0)});
        TaskAssignmentUtils.defaultStandbyTaskAssignment((ApplicationState)applicationState, (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)((KafkaStreamsAssignment.AssignedTask)((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().get(AssignmentTestUtils.TASK_0_0)).type(), (Matcher)CoreMatchers.equalTo((Object)KafkaStreamsAssignment.AssignedTask.Type.ACTIVE));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(4))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    @Timeout(value=30L)
    @Test
    public void shouldAssignStandbyTasksByClientLoad() {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs("none", 100, 1, 3, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_3, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_4, false), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_5, false)});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(3, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(5, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 2, AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5)});
        TaskAssignmentUtils.defaultStandbyTaskAssignment((ApplicationState)applicationState, (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_3, AssignmentTestUtils.TASK_0_4, AssignmentTestUtils.TASK_0_5})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(4))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(5))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    @Timeout(value=30L)
    @ParameterizedTest
    @ValueSource(strings={"min_traffic", "balance_subtopology"})
    public void shouldNotViolateClientTagsAssignmentDuringStandbyOptimization(String strategy) {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs(strategy, 100, 1, 2, Collections.singletonList("az"));
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true, Utils.mkSet((Object[])new String[]{"r1"})), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true, Utils.mkSet((Object[])new String[]{"r1"}))});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.of("r1"), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"1")})), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.of("r1"), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"2")})), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.of("r1"), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"3")})), TaskAssignmentUtilsTest.mkStreamState(4, 2, Optional.of("r1"), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"az", (Object)"2")}))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(1, new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE), new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.STANDBY)), TaskAssignmentUtilsTest.mkAssignment(2, new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.STANDBY), new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)), TaskAssignmentUtilsTest.mkAssignment(3, new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_0, KafkaStreamsAssignment.AssignedTask.Type.STANDBY), new KafkaStreamsAssignment.AssignedTask(AssignmentTestUtils.TASK_0_1, KafkaStreamsAssignment.AssignedTask.Type.STANDBY)), TaskAssignmentUtilsTest.mkAssignment(4, new KafkaStreamsAssignment.AssignedTask[0])});
        TaskAssignmentUtils.optimizeRackAwareStandbyTasks((TaskAssignmentUtils.RackAwareOptimizationParams)TaskAssignmentUtils.RackAwareOptimizationParams.of((ApplicationState)applicationState), (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(4))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
    }

    @Timeout(value=30L)
    @ParameterizedTest
    @ValueSource(strings={"min_traffic", "balance_subtopology"})
    public void shouldOptimizeStandbyTasksWithMultipleRacks(String strategy) {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs(strategy, 100, 1, 1, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true, Utils.mkSet((Object[])new String[]{"rack-1", "rack-2"})), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true, Utils.mkSet((Object[])new String[]{"rack-2", "rack-3"})), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true, Utils.mkSet((Object[])new String[]{"rack-3", "rack-4"}))});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 2, Optional.of("rack-1")), TaskAssignmentUtilsTest.mkStreamState(2, 2, Optional.of("rack-2")), TaskAssignmentUtilsTest.mkStreamState(3, 2, Optional.of("rack-3"))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 1, AssignmentTestUtils.TASK_0_0), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 2, AssignmentTestUtils.TASK_0_1), TaskAssignmentUtilsTest.mkAssignment(KafkaStreamsAssignment.AssignedTask.Type.ACTIVE, 3, AssignmentTestUtils.TASK_0_2)});
        TaskAssignmentUtils.optimizeRackAwareActiveTasks((TaskAssignmentUtils.RackAwareOptimizationParams)TaskAssignmentUtils.RackAwareOptimizationParams.of((ApplicationState)applicationState).forTasks(new TreeSet(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}))), (Map)assignments);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
    }

    @Timeout(value=30L)
    @Test
    public void shouldCorrectlyReturnIdentityAssignment() {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs("none", 100, 1, 1, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_0, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_1, true), TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_0_2, true)});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2}), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(2, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})), TaskAssignmentUtilsTest.mkStreamState(3, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(4, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0])), TaskAssignmentUtilsTest.mkStreamState(5, 5, Optional.empty(), Utils.mkSet((Object[])new TaskId[0]), Utils.mkSet((Object[])new TaskId[0]))});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        Map assignments = TaskAssignmentUtils.identityAssignment((ApplicationState)applicationState);
        MatcherAssert.assertThat((Object)assignments.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(1))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(2))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(3))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(4))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat(((KafkaStreamsAssignment)assignments.get(TaskAssignmentUtilsTest.processId(5))).tasks().keySet(), (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new Object[0])));
    }

    @Timeout(value=30L)
    @Test
    public void testValidateTaskAssignment() {
        AssignmentConfigs assignmentConfigs = this.defaultAssignmentConfigs("none", 100, 1, 1, Collections.emptyList());
        Map tasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkTaskInfo(AssignmentTestUtils.TASK_1_1, false)});
        Map kafkaStreamsStates = Utils.mkMap((Map.Entry[])new Map.Entry[]{TaskAssignmentUtilsTest.mkStreamState(1, 5, Optional.empty()), TaskAssignmentUtilsTest.mkStreamState(2, 5, Optional.empty())});
        TestApplicationState applicationState = new TestApplicationState(assignmentConfigs, kafkaStreamsStates, tasks);
        TaskAssignor.TaskAssignment noError = new TaskAssignor.TaskAssignment((Collection)Utils.mkSet((Object[])new KafkaStreamsAssignment[]{KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(1), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)})), KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(2), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[0]))}));
        TaskAssignor.AssignmentError error = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)noError);
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.equalTo((Object)TaskAssignor.AssignmentError.NONE));
        TaskAssignor.TaskAssignment missingProcessId = new TaskAssignor.TaskAssignment((Collection)Utils.mkSet((Object[])new KafkaStreamsAssignment[]{KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(1), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)}))}));
        error = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)missingProcessId);
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.equalTo((Object)TaskAssignor.AssignmentError.MISSING_PROCESS_ID));
        TaskAssignor.TaskAssignment unknownProcessId = new TaskAssignor.TaskAssignment((Collection)Utils.mkSet((Object[])new KafkaStreamsAssignment[]{KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(1), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)})), KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(2), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[0])), KafkaStreamsAssignment.of((ProcessId)ProcessId.randomProcessId(), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[0]))}));
        error = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)unknownProcessId);
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.equalTo((Object)TaskAssignor.AssignmentError.UNKNOWN_PROCESS_ID));
        TaskAssignor.TaskAssignment unknownTaskId = new TaskAssignor.TaskAssignment((Collection)Utils.mkSet((Object[])new KafkaStreamsAssignment[]{KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(1), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)})), KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(2), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(13, 13), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)}))}));
        error = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)unknownTaskId);
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.equalTo((Object)TaskAssignor.AssignmentError.UNKNOWN_TASK_ID));
        TaskAssignor.TaskAssignment activeTaskDuplicated = new TaskAssignor.TaskAssignment((Collection)Utils.mkSet((Object[])new KafkaStreamsAssignment[]{KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(1), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)})), KafkaStreamsAssignment.of((ProcessId)TaskAssignmentUtilsTest.processId(2), (Set)Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[]{new KafkaStreamsAssignment.AssignedTask(new TaskId(1, 1), KafkaStreamsAssignment.AssignedTask.Type.ACTIVE)}))}));
        error = TaskAssignmentUtils.validateTaskAssignment((ApplicationState)applicationState, (TaskAssignor.TaskAssignment)activeTaskDuplicated);
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.equalTo((Object)TaskAssignor.AssignmentError.ACTIVE_TASK_ASSIGNED_MULTIPLE_TIMES));
    }

    public static Map.Entry<ProcessId, KafkaStreamsState> mkStreamState(int id, int numProcessingThreads, Optional<String> rackId) {
        return TaskAssignmentUtilsTest.mkStreamState(id, numProcessingThreads, rackId, new HashSet<TaskId>(), new HashSet<TaskId>(), Utils.mkMap((Map.Entry[])new Map.Entry[0]));
    }

    public static Map.Entry<ProcessId, KafkaStreamsState> mkStreamState(int id, int numProcessingThreads, Optional<String> rackId, Set<TaskId> previousActiveTasks, Set<TaskId> previousStandbyTasks) {
        return TaskAssignmentUtilsTest.mkStreamState(id, numProcessingThreads, rackId, previousActiveTasks, previousStandbyTasks, Utils.mkMap((Map.Entry[])new Map.Entry[0]));
    }

    public static Map.Entry<ProcessId, KafkaStreamsState> mkStreamState(int id, int numProcessingThreads, Optional<String> rackId, Set<TaskId> previousActiveTasks, Set<TaskId> previousStandbyTasks, Map<String, String> clientTags) {
        ProcessId processId = AssignmentTestUtils.processIdForInt(id);
        return Utils.mkEntry((Object)processId, (Object)new DefaultKafkaStreamsState(processId, numProcessingThreads, clientTags, new TreeSet<TaskId>(previousActiveTasks), new TreeSet<TaskId>(previousStandbyTasks), new TreeMap(), Optional.empty(), Optional.empty(), rackId));
    }

    public static ProcessId processId(int id) {
        return AssignmentTestUtils.processIdForInt(id);
    }

    public static Map.Entry<ProcessId, KafkaStreamsAssignment> mkAssignment(KafkaStreamsAssignment.AssignedTask.Type taskType, int client, TaskId ... taskIds) {
        ProcessId processId = TaskAssignmentUtilsTest.processId(client);
        Set assignedTasks = Utils.mkSet((Object[])new KafkaStreamsAssignment.AssignedTask[0]);
        for (TaskId taskId : taskIds) {
            assignedTasks.add(new KafkaStreamsAssignment.AssignedTask(taskId, taskType));
        }
        return Utils.mkEntry((Object)processId, (Object)KafkaStreamsAssignment.of((ProcessId)processId, (Set)assignedTasks));
    }

    public static Map.Entry<ProcessId, KafkaStreamsAssignment> mkAssignment(int client, KafkaStreamsAssignment.AssignedTask ... tasks) {
        ProcessId processId = TaskAssignmentUtilsTest.processId(client);
        return Utils.mkEntry((Object)processId, (Object)KafkaStreamsAssignment.of((ProcessId)processId, Arrays.stream(tasks).collect(Collectors.toSet())));
    }

    public static Map.Entry<TaskId, TaskInfo> mkTaskInfo(TaskId taskId, boolean isStateful) {
        return TaskAssignmentUtilsTest.mkTaskInfo(taskId, isStateful, null);
    }

    public static Map.Entry<TaskId, TaskInfo> mkTaskInfo(TaskId taskId, boolean isStateful, Set<String> rackIds) {
        if (!isStateful) {
            return Utils.mkEntry((Object)taskId, (Object)new DefaultTaskInfo(taskId, false, Utils.mkSet((Object[])new String[0]), Utils.mkSet((Object[])new TaskTopicPartition[0])));
        }
        HashSet<DefaultTaskTopicPartition> partitions = new HashSet<DefaultTaskTopicPartition>();
        partitions.add(new DefaultTaskTopicPartition(new TopicPartition(String.format("test-topic-%d", taskId.subtopology()), taskId.partition()), true, true, () -> partitions.forEach(partition -> {
            if (partition != null && rackIds != null) {
                partition.annotateWithRackIds(rackIds);
            }
        })));
        return Utils.mkEntry((Object)taskId, (Object)new DefaultTaskInfo(taskId, true, Utils.mkSet((Object[])new String[]{String.format("test-statestore-%d", taskId.subtopology())}), partitions.stream().map(p -> p).collect(Collectors.toSet())));
    }

    public AssignmentConfigs defaultAssignmentConfigs(String rackAwareStrategy, int trafficCost, int nonOverlapCost, int numStandbys, List<String> rackAwareAssignmentTags) {
        return new AssignmentConfigs(0L, 1, numStandbys, 60000L, rackAwareAssignmentTags, OptionalInt.of(trafficCost), OptionalInt.of(nonOverlapCost), rackAwareStrategy);
    }

    public static class TestApplicationState
    implements ApplicationState {
        private final AssignmentConfigs assignmentConfigs;
        private final Map<ProcessId, KafkaStreamsState> kafkaStreamsStates;
        private final Map<TaskId, TaskInfo> tasks;

        TestApplicationState(AssignmentConfigs assignmentConfigs, Map<ProcessId, KafkaStreamsState> kafkaStreamsStates, Map<TaskId, TaskInfo> tasks) {
            this.kafkaStreamsStates = kafkaStreamsStates;
            this.assignmentConfigs = assignmentConfigs;
            this.tasks = tasks;
        }

        public Map<ProcessId, KafkaStreamsState> kafkaStreamsStates(boolean computeTaskLags) {
            return this.kafkaStreamsStates;
        }

        public AssignmentConfigs assignmentConfigs() {
            return this.assignmentConfigs;
        }

        public Map<TaskId, TaskInfo> allTasks() {
            return this.tasks;
        }
    }
}

