/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TopicMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TopicMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String PROCESSOR_NODE_ID = "test-processor";
    private static final String TOPIC = "topic";
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private static final MockedStatic<StreamsMetricsImpl> STREAMS_METRICS_STATIC_MOCK = Mockito.mockStatic(StreamsMetricsImpl.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);

    @AfterAll
    public static void cleanUp() {
        STREAMS_METRICS_STATIC_MOCK.close();
    }

    @Test
    public void shouldGetRecordsAndBytesConsumedSensor() {
        String recordsMetricNamePrefix = "records-consumed";
        String bytesMetricNamePrefix = "bytes-consumed";
        String descriptionOfRecordsTotal = "The total number of records consumed from this topic";
        String descriptionOfBytesTotal = "The total number of bytes consumed from this topic";
        Mockito.when((Object)this.streamsMetrics.topicLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC, "consumed", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.topicLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC, "consumed", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.topicLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC)).thenReturn(this.tagMap);
        this.verifySensor(() -> TopicMetrics.consumedSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (String)TOPIC, (StreamsMetricsImpl)this.streamsMetrics));
        STREAMS_METRICS_STATIC_MOCK.verify(() -> StreamsMetricsImpl.addTotalCountAndSumMetricsToSensor((Sensor)this.expectedSensor, (String)"stream-topic-metrics", this.tagMap, (String)"records-consumed", (String)"bytes-consumed", (String)"The total number of records consumed from this topic", (String)"The total number of bytes consumed from this topic"));
    }

    @Test
    public void shouldGetRecordsAndBytesProducedSensor() {
        String recordsMetricNamePrefix = "records-produced";
        String bytesMetricNamePrefix = "bytes-produced";
        String descriptionOfRecordsTotal = "The total number of records produced to this topic";
        String descriptionOfBytesTotal = "The total number of bytes produced to this topic";
        Mockito.when((Object)this.streamsMetrics.topicLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC, "produced", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.topicLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC, "produced", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.topicLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, TOPIC)).thenReturn(this.tagMap);
        this.verifySensor(() -> TopicMetrics.producedSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (String)TOPIC, (StreamsMetricsImpl)this.streamsMetrics));
        STREAMS_METRICS_STATIC_MOCK.verify(() -> StreamsMetricsImpl.addTotalCountAndSumMetricsToSensor((Sensor)this.expectedSensor, (String)"stream-topic-metrics", this.tagMap, (String)"records-produced", (String)"bytes-produced", (String)"The total number of records produced to this topic", (String)"The total number of bytes produced to this topic"));
    }

    private void verifySensor(Supplier<Sensor> sensorSupplier) {
        Sensor sensor = sensorSupplier.get();
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

