/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StateSerdesTest {
    @Test
    public void shouldThrowIfTopicNameIsNullForBuiltinTypes() {
        Assertions.assertThrows(NullPointerException.class, () -> StateSerdes.withBuiltinTypes(null, byte[].class, byte[].class));
    }

    @Test
    public void shouldThrowIfKeyClassIsNullForBuiltinTypes() {
        Assertions.assertThrows(NullPointerException.class, () -> StateSerdes.withBuiltinTypes((String)"anyName", null, byte[].class));
    }

    @Test
    public void shouldThrowIfValueClassIsNullForBuiltinTypes() {
        Assertions.assertThrows(NullPointerException.class, () -> StateSerdes.withBuiltinTypes((String)"anyName", byte[].class, null));
    }

    @Test
    public void shouldReturnSerdesForBuiltInKeyAndValueTypesForBuiltinTypes() {
        Class[] supportedBuildInTypes;
        for (Class keyClass : supportedBuildInTypes = new Class[]{String.class, Short.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, ByteBuffer.class, Bytes.class}) {
            for (Class valueClass : supportedBuildInTypes) {
                Assertions.assertNotNull((Object)StateSerdes.withBuiltinTypes((String)"anyName", (Class)keyClass, (Class)valueClass));
            }
        }
    }

    @Test
    public void shouldThrowForUnknownKeyTypeForBuiltinTypes() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StateSerdes.withBuiltinTypes((String)"anyName", Class.class, byte[].class));
    }

    @Test
    public void shouldThrowForUnknownValueTypeForBuiltinTypes() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StateSerdes.withBuiltinTypes((String)"anyName", byte[].class, Class.class));
    }

    @Test
    public void shouldThrowIfTopicNameIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new StateSerdes(null, Serdes.ByteArray(), Serdes.ByteArray()));
    }

    @Test
    public void shouldThrowIfKeyClassIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new StateSerdes("anyName", null, Serdes.ByteArray()));
    }

    @Test
    public void shouldThrowIfValueClassIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new StateSerdes("anyName", Serdes.ByteArray(), null));
    }

    @Test
    public void shouldThrowIfIncompatibleSerdeForValue() throws ClassNotFoundException {
        Class<?> myClass = Class.forName("java.lang.String");
        StateSerdes stateSerdes = new StateSerdes("anyName", Serdes.serdeFrom(myClass), Serdes.serdeFrom(myClass));
        Integer myInt = 123;
        Exception e = (Exception)Assertions.assertThrows(StreamsException.class, () -> stateSerdes.rawValue((Object)myInt));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"A serializer (org.apache.kafka.common.serialization.StringSerializer) is not compatible to the actual value type (value type: java.lang.Integer). Change the default Serdes in StreamConfig or provide correct Serdes via method parameters."));
    }

    @Test
    public void shouldSkipValueAndTimestampeInformationForErrorOnTimestampAndValueSerialization() throws ClassNotFoundException {
        Class<?> myClass = Class.forName("java.lang.String");
        StateSerdes stateSerdes = new StateSerdes("anyName", Serdes.serdeFrom(myClass), (Serde)new ValueAndTimestampSerde(Serdes.serdeFrom(myClass)));
        Integer myInt = 123;
        Exception e = (Exception)Assertions.assertThrows(StreamsException.class, () -> stateSerdes.rawValue((Object)ValueAndTimestamp.make((Object)myInt, (long)0L)));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"A serializer (org.apache.kafka.common.serialization.StringSerializer) is not compatible to the actual value type (value type: java.lang.Integer). Change the default Serdes in StreamConfig or provide correct Serdes via method parameters."));
    }

    @Test
    public void shouldThrowIfIncompatibleSerdeForKey() throws ClassNotFoundException {
        Class<?> myClass = Class.forName("java.lang.String");
        StateSerdes stateSerdes = new StateSerdes("anyName", Serdes.serdeFrom(myClass), Serdes.serdeFrom(myClass));
        Integer myInt = 123;
        Exception e = (Exception)Assertions.assertThrows(StreamsException.class, () -> stateSerdes.rawKey((Object)myInt));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"A serializer (org.apache.kafka.common.serialization.StringSerializer) is not compatible to the actual key type (key type: java.lang.Integer). Change the default Serdes in StreamConfig or provide correct Serdes via method parameters."));
    }
}

