/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.streams.state.internals.RocksDbTimeOrderedSessionBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractSessionBytesStoreTest {
    static final long SEGMENT_INTERVAL = 60000L;
    static final long RETENTION_PERIOD = 10000L;
    private static final String IN_MEMORY_STORE_NAME = "in-memory session store";
    private static final String ROCK_DB_STORE_NAME = "rocksDB session store";
    SessionStore<String, Long> sessionStore;
    private MockRecordCollector recordCollector;
    InternalMockProcessorContext context;

    <K, V> SessionStore<K, V> buildSessionStore(long retentionPeriod, Serde<K> keySerde, Serde<V> valueSerde) {
        switch (this.storeType()) {
            case RocksDBSessionStore: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)ROCK_DB_STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod)), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedSessionStoreWithIndex: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)new RocksDbTimeOrderedSessionBytesStoreSupplier(ROCK_DB_STORE_NAME, retentionPeriod, true), keySerde, valueSerde).build();
            }
            case RocksDBTimeOrderedSessionStoreWithoutIndex: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)new RocksDbTimeOrderedSessionBytesStoreSupplier(ROCK_DB_STORE_NAME, retentionPeriod, false), keySerde, valueSerde).build();
            }
            case InMemoryStore: {
                return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.inMemorySessionStore((String)IN_MEMORY_STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod)), keySerde, valueSerde).build();
            }
        }
        throw new IllegalStateException("Unknown StoreType: " + (Object)((Object)this.storeType()));
    }

    abstract StoreType storeType();

    @BeforeEach
    public void setUp() {
        this.sessionStore = this.buildSessionStore(10000L, Serdes.String(), Serdes.Long());
        this.recordCollector = new MockRecordCollector();
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), this.recordCollector, new ThreadCache(new LogContext("testCache"), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.context.setTime(1L);
        this.sessionStore.init((StateStoreContext)this.context, this.sessionStore);
    }

    @AfterEach
    public void after() {
        this.sessionStore.close();
    }

    @Test
    public void shouldPutAndFindSessionsInRange() {
        String key = "a";
        Windowed a1 = new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L));
        Windowed a2 = new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, (Object)1L);
        this.sessionStore.put(a2, (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)a1, (Object)1L), KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        List<KeyValue> expected2 = Collections.singletonList(KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values2 = this.sessionStore.findSessions((Object)"a", 400L, 600L);){
            Assertions.assertEquals(expected2, (Object)Utils.toList((Iterator)values2));
        }
    }

    @Test
    public void shouldPutAndBackwardFindSessionsInRange() {
        String key = "a";
        Windowed a1 = new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L));
        Windowed a2 = new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, (Object)1L);
        this.sessionStore.put(a2, (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L)), (Object)2L);
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)a1, (Object)1L));
        expected.add(KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values = this.sessionStore.backwardFindSessions((Object)"a", 0L, 1000L);){
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        List<KeyValue> expected2 = Collections.singletonList(KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values2 = this.sessionStore.backwardFindSessions((Object)"a", 400L, 600L);){
            Assertions.assertEquals(expected2, (Object)Utils.toList((Iterator)values2));
        }
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() {
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"a");){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
    }

    @Test
    public void shouldFindSessionsForTimeRange() {
        List<KeyValue> expected;
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        if (this.storeType() == StoreType.RocksDBSessionStore) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.sessionStore.findSessions(0L, 0L), (String)"This API is not supported by this implementation of SessionStore.");
            return;
        }
        try (KeyValueIterator values = this.sessionStore.findSessions(0L, 0L);){
            expected = Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)5L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        this.sessionStore.put(new Windowed((Object)"b", (Window)new SessionWindow(10L, 20L)), (Object)10L);
        this.sessionStore.put(new Windowed((Object)"c", (Window)new SessionWindow(30L, 40L)), (Object)20L);
        values = this.sessionStore.findSessions(0L, 20L);
        var2_2 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)5L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(10L, 20L)), (Object)10L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable expected2) {
            var2_2 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var2_2 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var2_2.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.sessionStore.findSessions(0L, 19L);
        var2_2 = null;
        try {
            expected = Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)5L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable expected3) {
            var2_2 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var2_2 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var2_2.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.sessionStore.findSessions(1L, 20L);
        var2_2 = null;
        try {
            expected = Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(10L, 20L)), (Object)10L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable expected4) {
            var2_2 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var2_2 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var2_2.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.sessionStore.findSessions(19L, 41L);
        var2_2 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(10L, 20L)), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new SessionWindow(30L, 40L)), (Object)20L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable expected5) {
            var2_2 = expected5;
            throw expected5;
        }
        finally {
            if (values != null) {
                if (var2_2 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected5) {
                        var2_2.addSuppressed(expected5);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.sessionStore.findSessions(0L, 40L);
        var2_2 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)5L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(10L, 20L)), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"c", (Window)new SessionWindow(30L, 40L)), (Object)20L));
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var2_2 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldBackwardFetchAllSessionsWithSameRecordKey() {
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        try (KeyValueIterator values = this.sessionStore.backwardFetch((Object)"a");){
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
    }

    @Test
    public void shouldFetchAllSessionsWithinKeyRange() {
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)new SessionWindow(10L, 10L)), (Object)2L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)new SessionWindow(100L, 100L)), (Object)3L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aaaa", (Window)new SessionWindow(100L, 100L)), (Object)6L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"bb", (Window)new SessionWindow(1500L, 2000L)), (Object)5L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"bbb", (Window)new SessionWindow(2500L, 3000L)), (Object)6L);
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"aa", (Object)"bb");){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        values = this.sessionStore.findSessions((Object)"aa", (Object)"bb", 0L, Long.MAX_VALUE);
        var3_3 = null;
        try {
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.add(0, KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        values = this.sessionStore.fetch(null, (Object)"bb");
        var3_3 = null;
        try {
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.remove(0);
        expected.add(KeyValue.pair((Object)new Windowed((Object)"bbb", (Window)new SessionWindow(2500L, 3000L)), (Object)6L));
        values = this.sessionStore.fetch((Object)"aa", null);
        var3_3 = null;
        try {
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.add(0, KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        values = this.sessionStore.fetch(null, null);
        var3_3 = null;
        try {
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldBackwardFetchAllSessionsWithinKeyRange() {
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)new SessionWindow(10L, 10L)), (Object)2L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)new SessionWindow(100L, 100L)), (Object)3L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"aaaa", (Window)new SessionWindow(100L, 100L)), (Object)6L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"bb", (Window)new SessionWindow(1500L, 2000L)), (Object)5L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"bbb", (Window)new SessionWindow(2500L, 3000L)), (Object)6L);
        try (KeyValueIterator values = this.sessionStore.backwardFetch((Object)"aa", (Object)"bb");){
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        values = this.sessionStore.backwardFindSessions((Object)"aa", (Object)"bb", 0L, Long.MAX_VALUE);
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.add(0, KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        values = this.sessionStore.backwardFetch(null, (Object)"bb");
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.remove(0);
        expected.add(KeyValue.pair((Object)new Windowed((Object)"bbb", (Window)new SessionWindow(2500L, 3000L)), (Object)6L));
        values = this.sessionStore.backwardFetch((Object)"aa", null);
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        expected.add(0, KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        values = this.sessionStore.backwardFetch(null, null);
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldFetchExactSession() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 4L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 3L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 4L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(1L, 4L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"aaa", (Window)new SessionWindow(0L, 4L)), (Object)5L);
        long result = (Long)this.sessionStore.fetchSession((Object)"aa", 0L, 4L);
        Assertions.assertEquals((long)3L, (long)result);
    }

    @Test
    public void shouldReturnNullOnSessionNotFound() {
        Assertions.assertNull((Object)this.sessionStore.fetchSession((Object)"any key", 0L, 5L));
    }

    @Test
    public void shouldFindValuesWithinMergingSessionWindowRange() {
        String key = "a";
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", -1L, 1000L);){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)results));
        }
    }

    @Test
    public void shouldBackwardFindValuesWithinMergingSessionWindowRange() {
        String key = "a";
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L);
        LinkedList<KeyValue> expected = new LinkedList<KeyValue>();
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L));
        expected.add(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L));
        try (KeyValueIterator results = this.sessionStore.backwardFindSessions((Object)"a", -1L, 1000L);){
            Assertions.assertEquals((Object)Utils.toList(expected.descendingIterator()), (Object)Utils.toList((Iterator)results));
        }
    }

    @Test
    public void shouldRemove() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assertions.assertFalse((boolean)results.hasNext());
        }
        results = this.sessionStore.findSessions((Object)"a", 1500L, 2500L);
        var2_2 = null;
        try {
            Assertions.assertTrue((boolean)results.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (results != null) {
                if (var2_2 != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    results.close();
                }
            }
        }
    }

    @Test
    public void shouldRemoveOnNullAggValue() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), null);
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assertions.assertFalse((boolean)results.hasNext());
        }
        results = this.sessionStore.findSessions((Object)"a", 1500L, 2500L);
        var2_2 = null;
        try {
            Assertions.assertTrue((boolean)results.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (results != null) {
                if (var2_2 != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    results.close();
                }
            }
        }
    }

    @Test
    public void shouldFindSessionsToMerge() {
        Windowed session1 = new Windowed((Object)"a", (Window)new SessionWindow(0L, 100L));
        Windowed session2 = new Windowed((Object)"a", (Window)new SessionWindow(101L, 200L));
        Windowed session3 = new Windowed((Object)"a", (Window)new SessionWindow(201L, 300L));
        Windowed session4 = new Windowed((Object)"a", (Window)new SessionWindow(301L, 400L));
        Windowed session5 = new Windowed((Object)"a", (Window)new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, (Object)1L);
        this.sessionStore.put(session2, (Object)2L);
        this.sessionStore.put(session3, (Object)3L);
        this.sessionStore.put(session4, (Object)4L);
        this.sessionStore.put(session5, (Object)5L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)session2, (Object)2L), KeyValue.pair((Object)session3, (Object)3L));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 150L, 300L);){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)results));
        }
    }

    @Test
    public void shouldBackwardFindSessionsToMerge() {
        Windowed session1 = new Windowed((Object)"a", (Window)new SessionWindow(0L, 100L));
        Windowed session2 = new Windowed((Object)"a", (Window)new SessionWindow(101L, 200L));
        Windowed session3 = new Windowed((Object)"a", (Window)new SessionWindow(201L, 300L));
        Windowed session4 = new Windowed((Object)"a", (Window)new SessionWindow(301L, 400L));
        Windowed session5 = new Windowed((Object)"a", (Window)new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, (Object)1L);
        this.sessionStore.put(session2, (Object)2L);
        this.sessionStore.put(session3, (Object)3L);
        this.sessionStore.put(session4, (Object)4L);
        this.sessionStore.put(session5, (Object)5L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)session3, (Object)3L), KeyValue.pair((Object)session2, (Object)2L));
        try (KeyValueIterator results = this.sessionStore.backwardFindSessions((Object)"a", 150L, 300L);){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)results));
        }
    }

    @Test
    public void shouldFetchExactKeys() {
        this.sessionStore.close();
        this.sessionStore = this.buildSessionStore(0x7A00000000000000L, Serdes.String(), Serdes.Long());
        this.sessionStore.init((StateStoreContext)this.context, this.sessionStore);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(8791026472627208190L, 0x79FFFFFFFFFFFFFFL)), (Object)5L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 3L, 5L))));
        }
        iterator = this.sessionStore.findSessions((Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(2L, 4L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"a", (Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"a", (Object)"aa", 10L, 0L);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(2L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions(null, (Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"a", null, 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions(null, null, 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
    }

    @Test
    public void shouldBackwardFetchExactKeys() {
        this.sessionStore.close();
        this.sessionStore = this.buildSessionStore(0x7A00000000000000L, Serdes.String(), Serdes.Long());
        this.sessionStore.init((StateStoreContext)this.context, this.sessionStore);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(8791026472627208190L, 0x79FFFFFFFFFFFFFFL)), (Object)5L);
        try (KeyValueIterator iterator = this.sessionStore.backwardFindSessions((Object)"a", 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 3L, 5L))));
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(2L, 4L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"a", (Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"a", (Object)"aa", 10L, 0L);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(2L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions(null, (Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"a", null, 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions(null, null, 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
    }

    @Test
    public void shouldFetchAndIterateOverExactBinaryKeys() {
        SessionStore sessionStore = this.buildSessionStore(10000L, Serdes.Bytes(), Serdes.String());
        sessionStore.init((StateStoreContext)this.context, sessionStore);
        Bytes key1 = Bytes.wrap((byte[])new byte[]{0});
        Bytes key2 = Bytes.wrap((byte[])new byte[]{0, 0});
        Bytes key3 = Bytes.wrap((byte[])new byte[]{0, 0, 0});
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(1L, 100L)), (Object)"1");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(2L, 100L)), (Object)"2");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(3L, 100L)), (Object)"3");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(4L, 100L)), (Object)"4");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(5L, 100L)), (Object)"5");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(6L, 100L)), (Object)"6");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(7L, 100L)), (Object)"7");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(8L, 100L)), (Object)"8");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(9L, 100L)), (Object)"9");
        List<String> expectedKey1 = Arrays.asList("1", "4", "7");
        try (KeyValueIterator iterator = sessionStore.findSessions((Object)key1, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey1)));
        }
        List<String> expectedKey2 = Arrays.asList("2", "5", "8");
        try (KeyValueIterator iterator = sessionStore.findSessions((Object)key2, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey2)));
        }
        List<String> expectedKey3 = Arrays.asList("3", "6", "9");
        try (KeyValueIterator iterator = sessionStore.findSessions((Object)key3, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey3)));
        }
        sessionStore.close();
    }

    @Test
    public void shouldBackwardFetchAndIterateOverExactBinaryKeys() {
        SessionStore sessionStore = this.buildSessionStore(10000L, Serdes.Bytes(), Serdes.String());
        sessionStore.init((StateStoreContext)this.context, sessionStore);
        Bytes key1 = Bytes.wrap((byte[])new byte[]{0});
        Bytes key2 = Bytes.wrap((byte[])new byte[]{0, 0});
        Bytes key3 = Bytes.wrap((byte[])new byte[]{0, 0, 0});
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(1L, 100L)), (Object)"1");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(2L, 100L)), (Object)"2");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(3L, 100L)), (Object)"3");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(4L, 100L)), (Object)"4");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(5L, 100L)), (Object)"5");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(6L, 100L)), (Object)"6");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(7L, 100L)), (Object)"7");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(8L, 100L)), (Object)"8");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(9L, 100L)), (Object)"9");
        List<String> expectedKey1 = Arrays.asList("7", "4", "1");
        try (KeyValueIterator iterator = sessionStore.backwardFindSessions((Object)key1, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey1)));
        }
        List<String> expectedKey2 = Arrays.asList("8", "5", "2");
        try (KeyValueIterator iterator = sessionStore.backwardFindSessions((Object)key2, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey2)));
        }
        List<String> expectedKey3 = Arrays.asList("9", "6", "3");
        try (KeyValueIterator iterator = sessionStore.backwardFindSessions((Object)key3, 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(StreamsTestUtils.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<String>(expectedKey3)));
        }
        sessionStore.close();
    }

    @Test
    public void testIteratorPeek() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", 0L, 20L);){
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)));
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testIteratorPeekBackward() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        try (KeyValueIterator iterator = this.sessionStore.backwardFindSessions((Object)"a", 0L, 20L);){
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)));
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
            Assertions.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldRestore() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue keyValue : expected) {
            this.sessionStore.put((Windowed)keyValue.key, keyValue.value);
        }
        Throwable throwable = null;
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"a");){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        this.sessionStore.close();
        values = this.sessionStore.fetch((Object)"a");
        Throwable throwable4 = null;
        try {
            Assertions.assertEquals(Collections.emptyList(), (Object)Utils.toList((Iterator)values));
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        finally {
            if (values != null) {
                if (throwable4 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable7) {
                        throwable4.addSuppressed(throwable7);
                    }
                } else {
                    values.close();
                }
            }
        }
        ArrayList<KeyValue<byte[], byte[]>> changeLog = new ArrayList<KeyValue<byte[], byte[]>>();
        for (ProducerRecord<Object, Object> producerRecord : this.recordCollector.collected()) {
            changeLog.add((KeyValue<byte[], byte[]>)new KeyValue((Object)((Bytes)producerRecord.key()).get(), (Object)((byte[])producerRecord.value())));
        }
        this.context.restore(this.sessionStore.name(), changeLog);
        Throwable throwable8 = null;
        try (KeyValueIterator keyValueIterator = this.sessionStore.fetch((Object)"a");){
            Assertions.assertEquals(expected, (Object)Utils.toList((Iterator)keyValueIterator));
        }
        catch (Throwable throwable9) {
            Throwable throwable10 = throwable9;
            throw throwable9;
        }
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreIsClosedAndNotThrowInvalidStateStoreExceptionOnHasNext() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"b", (Window)new SessionWindow(10L, 50L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"c", (Window)new SessionWindow(100L, 500L)), (Object)3L);
        try (KeyValueIterator iterator = this.sessionStore.fetch((Object)"a");){
            Assertions.assertTrue((boolean)iterator.hasNext());
            this.sessionStore.close();
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldReturnSameResultsForSingleKeyFindSessionsAndEqualKeyRangeFindSessions() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1L)), (Object)0L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(2L, 3L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(4L, 5L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"aaa", (Window)new SessionWindow(6L, 7L)), (Object)3L);
        try (KeyValueIterator singleKeyIterator = this.sessionStore.findSessions((Object)"aa", 0L, 10L);
             KeyValueIterator rangeIterator = this.sessionStore.findSessions((Object)"aa", (Object)"aa", 0L, 10L);){
            Assertions.assertEquals((Object)singleKeyIterator.next(), (Object)rangeIterator.next());
            Assertions.assertEquals((Object)singleKeyIterator.next(), (Object)rangeIterator.next());
            Assertions.assertFalse((boolean)singleKeyIterator.hasNext());
            Assertions.assertFalse((boolean)rangeIterator.hasNext());
        }
    }

    @Test
    public void shouldMeasureExpiredRecords() {
        Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
        SessionStore sessionStore = this.buildSessionStore(10000L, Serdes.String(), Serdes.Long());
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), new StreamsConfig((Map)streamsConfig), this.recordCollector);
        Time time = Time.SYSTEM;
        context.setTime(1L);
        context.setSystemTimeMs(time.milliseconds());
        sessionStore.init(context, sessionStore);
        sessionStore.put(new Windowed((Object)"initial record", (Window)new SessionWindow(0L, 120000L)), (Object)0L);
        sessionStore.put(new Windowed((Object)"late record", (Window)new SessionWindow(0L, 0L)), (Object)0L);
        sessionStore.put(new Windowed((Object)"another on-time record", (Window)new SessionWindow(0L, 120000L)), (Object)0L);
        Map metrics = context.metrics().metrics();
        String threadId = Thread.currentThread().getName();
        Metric dropTotal = (Metric)metrics.get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Metric dropRate = (Metric)metrics.get(new MetricName("dropped-records-rate", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Assertions.assertEquals((Object)1.0, (Object)dropTotal.metricValue());
        Assertions.assertNotEquals((Object)0.0, (Object)dropRate.metricValue());
        sessionStore.close();
    }

    @Test
    public void shouldNotThrowExceptionRemovingNonexistentKey() {
        this.sessionStore.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1L)));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnFindSessionsNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sessionStore.findSessions(null, 1L, 2L));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sessionStore.fetch(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRemoveNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sessionStore.remove(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sessionStore.put(null, (Object)1L));
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey() {
        String keyFrom = (String)Serdes.String().deserializer().deserialize("", Serdes.Integer().serializer().serialize("", (Object)-1));
        String keyTo = (String)Serdes.String().deserializer().deserialize("", Serdes.Integer().serializer().serialize("", (Object)1));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
             KeyValueIterator iterator = this.sessionStore.findSessions((Object)keyFrom, (Object)keyTo, 0L, 10L);){
            Assertions.assertFalse((boolean)iterator.hasNext());
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldRemoveExpired() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        if (this.storeType() == StoreType.InMemoryStore) {
            this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
            this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
            this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 10000L)), (Object)4L);
        } else {
            this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 60000L)), (Object)2L);
            this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 60000L)), (Object)3L);
            this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 120000L)), (Object)4L);
        }
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, Long.MAX_VALUE);){
            if (this.storeType() == StoreType.InMemoryStore) {
                Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), new HashSet<Long>(Arrays.asList(2L, 3L, 4L)));
            } else {
                Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), new HashSet<Long>(Collections.singletonList(4L)));
            }
        }
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        MeteredSessionStore meteredSessionStore = (MeteredSessionStore)this.sessionStore;
        ChangeLoggingSessionBytesStore changeLoggingSessionBytesStore = (ChangeLoggingSessionBytesStore)meteredSessionStore.wrapped();
        SessionStore wrapped = (SessionStore)changeLoggingSessionBytesStore.wrapped();
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)3L)}))}));
        Position actual = this.sessionStore.getPosition();
        MatcherAssert.assertThat((Object)expected, (Matcher)Matchers.is((Object)actual));
    }

    @Test
    public void shouldNotFetchExpiredSessions() {
        long systemTime = Time.SYSTEM.milliseconds();
        this.sessionStore.put(new Windowed((Object)"p", (Window)new SessionWindow(systemTime - 30000L, systemTime - 20000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"q", (Window)new SessionWindow(systemTime - 20000L, systemTime - 10000L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"r", (Window)new SessionWindow(systemTime - 10000L, systemTime - 5000L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"p", (Window)new SessionWindow(systemTime - 10000L, systemTime - 5000L)), (Object)2L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"p", systemTime - 20000L, systemTime - 10000L);){
            Assertions.assertEquals((Object)Utils.mkSet((Object[])new Long[]{2L}), StreamsTestUtils.valuesToSet(iterator));
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"p", systemTime - 50000L, systemTime - 40000L);
        var4_3 = null;
        try {
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_3 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"p", (Object)"r", systemTime - 50000L, systemTime - 40000L);
        var4_3 = null;
        try {
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_3 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"p", (Object)"r", systemTime - 10000L, systemTime - 5000L);
        var4_3 = null;
        try {
            Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), (Object)Utils.mkSet((Object[])new Long[]{2L, 3L, 4L}));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_3 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"p", (Object)"r", systemTime - 20000L, systemTime - 10000L);
        var4_3 = null;
        try {
            Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), (Object)Utils.mkSet((Object[])new Long[]{2L, 3L, 4L}));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_3 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.backwardFindSessions((Object)"p", (Object)"r", systemTime - 20000L, systemTime - 10000L);
        var4_3 = null;
        try {
            Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), (Object)Utils.mkSet((Object[])new Long[]{2L, 3L, 4L}));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_3 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
    }

    static enum StoreType {
        RocksDBSessionStore,
        RocksDBTimeOrderedSessionStoreWithIndex,
        RocksDBTimeOrderedSessionStoreWithoutIndex,
        InMemoryStore;

    }
}

