/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingVersionedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDbVersionedKeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerializer;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ChangeLoggingVersionedKeyValueBytesStoreTest {
    private static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    private static final Serializer<ValueAndTimestamp<String>> VALUE_AND_TIMESTAMP_SERIALIZER = new ValueAndTimestampSerializer(STRING_SERIALIZER);
    private static final long HISTORY_RETENTION = 1000L;
    private final MockRecordCollector collector = new MockRecordCollector();
    private InternalMockProcessorContext context;
    private VersionedBytesStore inner;
    private ChangeLoggingVersionedKeyValueBytesStore store;

    @BeforeEach
    public void before() {
        this.inner = (VersionedBytesStore)new RocksDbVersionedKeyValueBytesStoreSupplier("bytes_store", 1000L).get();
        this.store = new ChangeLoggingVersionedKeyValueBytesStore((KeyValueStore)this.inner);
        this.context = this.mockContext();
        this.context.setTime(0L);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    private InternalMockProcessorContext mockContext() {
        return new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), this.collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
    }

    @AfterEach
    public void after() {
        this.store.close();
    }

    @Test
    public void shouldThrowIfInnerIsNotVersioned() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChangeLoggingVersionedKeyValueBytesStore((KeyValueStore)new InMemoryKeyValueStore("kv")));
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        this.store.close();
        VersionedBytesStore mockInner = (VersionedBytesStore)Mockito.mock(VersionedBytesStore.class);
        this.store = new ChangeLoggingVersionedKeyValueBytesStore((KeyValueStore)mockInner);
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
        ((VersionedBytesStore)Mockito.verify((Object)mockInner)).init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateInit() {
        this.store.close();
        VersionedBytesStore mockInner = (VersionedBytesStore)Mockito.mock(VersionedBytesStore.class);
        this.store = new ChangeLoggingVersionedKeyValueBytesStore((KeyValueStore)mockInner);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
        ((VersionedBytesStore)Mockito.verify((Object)mockInner)).init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldPropagateAndLogOnPut() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        String value = "foo";
        long timestamp = 10L;
        long validTo = this.store.put(rawKey, ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("foo"), 10L);
        MatcherAssert.assertThat((Object)validTo, (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)this.inner.get((Object)rawKey), (Matcher)CoreMatchers.equalTo((Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("foo", 10L)));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)rawKey));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("foo")));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)10L));
    }

    @Test
    public void shouldPropagateAndLogOnPutNull() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        long timestamp = 10L;
        this.inner.put(rawKey, ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("foo"), 9L);
        MatcherAssert.assertThat((Object)this.inner.get((Object)rawKey), (Matcher)CoreMatchers.equalTo((Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("foo", 9L)));
        long validTo = this.store.put(rawKey, null, 10L);
        MatcherAssert.assertThat((Object)validTo, (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)this.inner.get((Object)rawKey), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)rawKey));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)10L));
    }

    @Test
    public void shouldPropagateAndLogOnDeleteWithTimestamp() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        long timestamp = 10L;
        byte[] rawValueAndTimestamp = ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("foo", 9L);
        this.inner.put(rawKey, ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("foo"), 9L);
        MatcherAssert.assertThat((Object)this.inner.get((Object)rawKey), (Matcher)CoreMatchers.equalTo((Object)rawValueAndTimestamp));
        byte[] result = this.store.delete(rawKey, 10L);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)rawValueAndTimestamp));
        MatcherAssert.assertThat((Object)this.inner.get((Object)rawKey), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)rawKey));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)10L));
    }

    @Test
    public void shouldNotLogOnDeleteIfInnerStoreThrows() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            byte[] cfr_ignored_0 = (byte[])this.inner.delete((Object)rawKey);
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.store.delete(rawKey));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldNotLogOnPutAllIfInnerStoreThrows() {
        List<KeyValue> entries = Collections.singletonList(KeyValue.pair((Object)Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k")), (Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("v", 12L)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.inner.putAll(entries));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.store.putAll(entries));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldNotLogOnPutIfAbsentIfInnerStoreThrows() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        byte[] rawValue = ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("v");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            byte[] cfr_ignored_0 = (byte[])this.inner.putIfAbsent((Object)rawKey, (Object)rawValue);
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.store.putIfAbsent(rawKey, rawValue));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldDelegateGet() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        this.inner.put(rawKey, ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("v"), 8L);
        MatcherAssert.assertThat((Object)this.store.get(rawKey), (Matcher)CoreMatchers.equalTo((Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("v", 8L)));
    }

    @Test
    public void shouldDelegateGetWithTimestamp() {
        Bytes rawKey = Bytes.wrap((byte[])ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("k"));
        this.inner.put(rawKey, ChangeLoggingVersionedKeyValueBytesStoreTest.rawBytes("v"), 8L);
        MatcherAssert.assertThat((Object)this.store.get(rawKey, 10L), (Matcher)CoreMatchers.equalTo((Object)ChangeLoggingVersionedKeyValueBytesStoreTest.rawValueAndTimestamp("v", 8L)));
    }

    private static byte[] rawBytes(String s) {
        return STRING_SERIALIZER.serialize(null, (Object)s);
    }

    private static byte[] rawValueAndTimestamp(String value, long timestamp) {
        return VALUE_AND_TIMESTAMP_SERIALIZER.serialize(null, (Object)ValueAndTimestamp.makeAllowNullable((Object)value, (long)timestamp));
    }
}

