/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.Map;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ChangeLoggingWindowBytesStoreTest {
    private final byte[] value = new byte[]{0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value);
    @Mock
    private WindowStore<Bytes, byte[]> inner;
    @Mock
    private ProcessorContextImpl context;
    private ChangeLoggingWindowBytesStore store;
    private static final Position POSITION = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)1L)}))}));

    @BeforeEach
    public void setUp() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, false, WindowKeySchema::toStoreKeyBinary);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @AfterEach
    public void tearDown() {
        ((WindowStore)Mockito.verify(this.inner)).init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
        ((WindowStore)Mockito.verify(this.inner)).init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateInit() {
    }

    @Test
    public void shouldLogPuts() {
        Bytes key = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        this.store.put(this.bytesKey, this.value, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner)).put((Object)this.bytesKey, (Object)this.value, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key, this.value, 0L, Position.emptyPosition());
    }

    @Test
    public void shouldLogPutsWithPosition() {
        Bytes key = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)POSITION);
        this.store.put(this.bytesKey, this.value, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner)).put((Object)this.bytesKey, (Object)this.value, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key, this.value, 0L, POSITION);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        this.store.fetch((Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));
        ((WindowStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey, 0L, 10L);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFetching() {
        this.store.backwardFetch((Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));
        ((WindowStore)Mockito.verify(this.inner)).backwardFetch((Object)this.bytesKey, 0L, 10L);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        this.store.fetch((Object)this.bytesKey, (Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L));
        ((WindowStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFetchingRange() {
        this.store.backwardFetch((Object)this.bytesKey, (Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L));
        ((WindowStore)Mockito.verify(this.inner)).backwardFetch((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L);
    }

    @Test
    public void shouldRetainDuplicatesWhenSet() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, true, WindowKeySchema::toStoreKeyBinary);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        Bytes key1 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)1);
        Bytes key2 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)2);
        this.store.put(this.bytesKey, this.value, this.context.timestamp());
        this.store.put(this.bytesKey, this.value, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner, (VerificationMode)Mockito.times((int)2))).put((Object)this.bytesKey, (Object)this.value, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key1, this.value, 0L, Position.emptyPosition());
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key2, this.value, 0L, Position.emptyPosition());
    }
}

