/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.test.GenericInMemoryKeyValueStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DelegatingPeekingKeyValueIteratorTest {
    private final String name = "name";
    private KeyValueStore<String, String> store;

    @BeforeEach
    public void setUp() {
        this.store = new GenericInMemoryKeyValueStore<String, String>("name");
    }

    @Test
    public void shouldPeekNextKey() {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assertions.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assertions.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assertions.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekNext() {
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        Assertions.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assertions.assertEquals((Object)KeyValue.pair((Object)"A", (Object)"A"), (Object)peekingIterator.peekNext());
        Assertions.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekAndIterate() {
        String[] kvs;
        for (String kv : kvs = new String[]{"a", "b", "c", "d", "e", "f"}) {
            this.store.put((Object)kv, (Object)kv);
        }
        DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());
        int index = 0;
        while (peekingIterator.hasNext()) {
            String peekNext = (String)peekingIterator.peekNextKey();
            String key = (String)peekingIterator.next().key;
            Assertions.assertEquals((Object)kvs[index], (Object)peekNext);
            Assertions.assertEquals((Object)kvs[index], (Object)key);
            ++index;
        }
        Assertions.assertEquals((int)kvs.length, (int)index);
        peekingIterator.close();
    }

    @Test
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndNextCalled() {
        try (DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());){
            Assertions.assertThrows(NoSuchElementException.class, () -> ((DelegatingPeekingKeyValueIterator)peekingIterator).next());
        }
    }

    @Test
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndPeekNextCalled() {
        try (DelegatingPeekingKeyValueIterator peekingIterator = new DelegatingPeekingKeyValueIterator("name", this.store.all());){
            Assertions.assertThrows(NoSuchElementException.class, () -> ((DelegatingPeekingKeyValueIterator)peekingIterator).peekNextKey());
        }
    }
}

