/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.PrefixedSessionKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SessionKeySchemaTest {
    private static final Map<SchemaType, SegmentedBytesStore.KeySchema> SCHEMA_TYPE_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), (Object)new SessionKeySchema()), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), (Object)new PrefixedSessionKeySchemas.KeyFirstSessionKeySchema()), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), (Object)new PrefixedSessionKeySchemas.TimeFirstSessionKeySchema())});
    private static final Map<SchemaType, Function<Windowed<Bytes>, Bytes>> WINDOW_TO_STORE_BINARY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::toBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::toBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::toBinary)});
    private static final Map<SchemaType, Function<byte[], Long>> EXTRACT_END_TS_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::extractEndTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::extractEndTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::extractEndTimestamp)});
    private static final Map<SchemaType, Function<byte[], Long>> EXTRACT_START_TS_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::extractStartTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::extractStartTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::extractStartTimestamp)});
    private static final Map<SchemaType, TriFunction<Windowed<String>, Serializer<String>, String, byte[]>> SERDE_TO_STORE_BINARY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::toBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::toBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::toBinary)});
    private static final Map<SchemaType, TriFunction<byte[], Deserializer<String>, String, Windowed<String>>> SERDE_FROM_BYTES_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::from), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::from), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from)});
    private static final Map<SchemaType, Function<Bytes, Windowed<Bytes>>> FROM_BYTES_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::from), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::from), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from)});
    private static final Map<SchemaType, Function<byte[], Window>> EXTRACT_WINDOW = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::extractWindow), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::extractWindow), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::extractWindow)});
    private static final Map<SchemaType, Function<byte[], byte[]>> EXTRACT_KEY_BYTES = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.SessionKeySchema), SessionKeySchema::extractKeyBytes), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedSessionKeySchemas.KeyFirstSessionKeySchema::extractKeyBytes), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::extractKeyBytes)});
    private final String key = "key";
    private final String topic = "topic";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Serde<String> serde = Serdes.String();
    private final Window window = new SessionWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final Serde<Windowed<String>> keySerde = new WindowedSerdes.SessionWindowedSerde(this.serde);
    private SegmentedBytesStore.KeySchema keySchema;
    private DelegatingPeekingKeyValueIterator<Bytes, Integer> iterator;
    private SchemaType schemaType;
    private Function<Windowed<Bytes>, Bytes> toBinary;
    private TriFunction<Windowed<String>, Serializer<String>, String, byte[]> serdeToBinary;
    private TriFunction<byte[], Deserializer<String>, String, Windowed<String>> serdeFromBytes;
    private Function<Bytes, Windowed<Bytes>> fromBytes;
    private Function<byte[], Long> extractStartTS;
    private Function<byte[], Long> extractEndTS;
    private Function<byte[], byte[]> extractKeyBytes;
    private Function<byte[], Window> extractWindow;

    private void setUp(SchemaType type) {
        this.schemaType = type;
        this.keySchema = SCHEMA_TYPE_MAP.get((Object)type);
        this.toBinary = WINDOW_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
        this.serdeToBinary = SERDE_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
        this.serdeFromBytes = SERDE_FROM_BYTES_MAP.get((Object)this.schemaType);
        this.fromBytes = FROM_BYTES_MAP.get((Object)this.schemaType);
        this.extractStartTS = EXTRACT_START_TS_MAP.get((Object)this.schemaType);
        this.extractEndTS = EXTRACT_END_TS_MAP.get((Object)this.schemaType);
        this.extractKeyBytes = EXTRACT_KEY_BYTES.get((Object)this.schemaType);
        this.extractWindow = EXTRACT_WINDOW.get((Object)this.schemaType);
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)1), KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(0L, 0L))), (Object)2), KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)3), KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(10L, 20L))), (Object)4), KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)5), KeyValue.pair((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)6));
        this.iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));
    }

    @AfterEach
    public void after() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldFetchExactKeysSkippingLongerKeys(SchemaType type) {
        this.setUp(type);
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        List<Integer> result = this.getValues(this.keySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE, true));
        MatcherAssert.assertThat(result, (Matcher)IsEqual.equalTo(Arrays.asList(2, 4)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldFetchExactKeySkippingShorterKeys(SchemaType type) {
        this.setUp(type);
        Bytes key = Bytes.wrap((byte[])new byte[]{0, 0});
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE, true);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 5)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldFetchAllKeysUsingNullKeys(SchemaType type) {
        this.setUp(type);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE, true);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void testUpperBoundWithLargeTimestamps(SchemaType type) {
        this.setUp(type);
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
        }
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte(SchemaType type) {
        this.setUp(type);
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113, -97}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void testUpperBoundWithZeroTimestamp(SchemaType type) {
        this.setUp(type);
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        Function<Windowed<Bytes>, Bytes> toBinary = WINDOW_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, Long.MAX_VALUE)))));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(0L, Long.MAX_VALUE)))));
        }
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void testLowerBoundWithZeroTimestamp(SchemaType type) {
        this.setUp(type);
        Bytes lower = this.keySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void testLowerBoundMatchesTrailingZeros(SchemaType type) {
        this.setUp(type);
        Bytes lower = this.keySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) < 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, Long.MAX_VALUE)))));
        } else {
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)this.toBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
        }
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldSerializeDeserialize(SchemaType type) {
        this.setUp(type);
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = (Windowed)this.keySerde.deserializer().deserialize("topic", bytes);
        Assertions.assertEquals(this.windowedKey, (Object)result);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldSerializeNullToNull(SchemaType type) {
        this.setUp(type);
        Assertions.assertNull((Object)this.keySerde.serializer().serialize("topic", null));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldDeSerializeEmptyByteArrayToNull(SchemaType type) {
        this.setUp(type);
        Assertions.assertNull((Object)this.keySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldDeSerializeNullToNull(SchemaType type) {
        this.setUp(type);
        Assertions.assertNull((Object)this.keySerde.deserializer().deserialize("topic", null));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldConvertToBinaryAndBack(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Windowed<String> result = this.serdeFromBytes.apply(serialized, (Deserializer<String>)Serdes.String().deserializer(), "dummy");
        Assertions.assertEquals(this.windowedKey, result);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractEndTimeFromBinary(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Assertions.assertEquals((long)100L, (long)this.extractEndTS.apply(serialized));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractStartTimeFromBinary(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Assertions.assertEquals((long)50L, (long)this.extractStartTS.apply(serialized));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractWindowFromBindary(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Assertions.assertEquals((Object)this.window, (Object)this.extractWindow.apply(serialized));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractKeyBytesFromBinary(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Assertions.assertArrayEquals((byte[])"key".getBytes(), (byte[])this.extractKeyBytes.apply(serialized));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractKeyFromBinary(SchemaType type) {
        this.setUp(type);
        byte[] serialized = this.serdeToBinary.apply(this.windowedKey, (Serializer<String>)this.serde.serializer(), "dummy");
        Assertions.assertEquals(this.windowedKey, this.serdeFromBytes.apply(serialized, (Deserializer<String>)this.serde.deserializer(), "dummy"));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldExtractBytesKeyFromBinary(SchemaType type) {
        this.setUp(type);
        Bytes bytesKey = Bytes.wrap((byte[])"key".getBytes());
        Windowed windowedBytesKey = new Windowed((Object)bytesKey, this.window);
        Bytes serialized = this.toBinary.apply((Windowed<Bytes>)windowedBytesKey);
        Assertions.assertEquals((Object)windowedBytesKey, this.fromBytes.apply(serialized));
    }

    private List<Integer> getValues(HasNextCondition hasNextCondition) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (hasNextCondition.hasNext(this.iterator)) {
            results.add((Integer)this.iterator.next().value);
        }
        return results;
    }

    private static enum SchemaType {
        SessionKeySchema,
        PrefixedTimeFirstSchema,
        PrefixedKeyFirstSchema;

    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

