/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.StandbyUpdateListener;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogRegister;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StoreChangelogReader;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockStandbyUpdateListener;
import org.apache.kafka.test.MockStateRestoreListener;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StreamThreadStateStoreProviderTest {
    private StreamTask taskOne;
    private StreamThreadStateStoreProvider provider;
    private StateDirectory stateDirectory;
    private File stateDir;
    private final String topicName = "topic";
    @Mock
    private StreamThread threadMock;
    private Map<TaskId, Task> tasks;

    @BeforeEach
    public void before() {
        TopologyWrapper topology = new TopologyWrapper();
        topology.addSource("the-source", new String[]{"topic"});
        topology.addProcessor("the-processor", new MockApiProcessorSupplier(), new String[]{"the-source"});
        topology.addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"the-processor"});
        topology.addStateStore(Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"timestamped-kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"the-processor"});
        topology.addStateStore(Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"window-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"the-processor"});
        topology.addStateStore(Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"timestamped-window-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"the-processor"});
        topology.addStateStore(Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.inMemorySessionStore((String)"session-store", (Duration)Duration.ofMillis(10L)), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"the-processor"});
        Properties properties = new Properties();
        String applicationId = "applicationId";
        properties.put("application.id", "applicationId");
        properties.put("bootstrap.servers", "localhost:9092");
        this.stateDir = TestUtils.tempDirectory();
        properties.put("state.dir", this.stateDir.getPath());
        StreamsConfig streamsConfig = new StreamsConfig((Map)properties);
        MockClientSupplier clientSupplier = new MockClientSupplier();
        this.configureClients(clientSupplier, "applicationId-kv-store-changelog");
        this.configureClients(clientSupplier, "applicationId-window-store-changelog");
        InternalTopologyBuilder internalTopologyBuilder = topology.getInternalBuilder("applicationId");
        ProcessorTopology processorTopology = internalTopologyBuilder.buildTopology();
        this.tasks = new HashMap<TaskId, Task>();
        this.stateDirectory = new StateDirectory(streamsConfig, (Time)new MockTime(), true, false);
        this.taskOne = this.createStreamsTask(streamsConfig, clientSupplier, processorTopology, new TaskId(0, 0));
        this.taskOne.initializeIfNeeded();
        this.tasks.put(new TaskId(0, 0), (Task)this.taskOne);
        StreamTask taskTwo = this.createStreamsTask(streamsConfig, clientSupplier, processorTopology, new TaskId(0, 1));
        taskTwo.initializeIfNeeded();
        this.tasks.put(new TaskId(0, 1), (Task)taskTwo);
        this.provider = new StreamThreadStateStoreProvider(this.threadMock);
    }

    @AfterEach
    public void cleanUp() throws IOException {
        Utils.delete((File)this.stateDir);
    }

    @Test
    public void shouldFindKeyValueStores() {
        this.mockThread(true);
        List kvStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        Assertions.assertEquals((int)2, (int)kvStores.size());
        for (ReadOnlyKeyValueStore store : kvStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldFindTimestampedKeyValueStores() {
        this.mockThread(true);
        List tkvStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-kv-store", (QueryableStoreType)QueryableStoreTypes.timestampedKeyValueStore()));
        Assertions.assertEquals((int)2, (int)tkvStores.size());
        for (ReadOnlyKeyValueStore store : tkvStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class));
        }
    }

    @Test
    public void shouldNotFindKeyValueStoresAsTimestampedStore() {
        this.mockThread(true);
        InvalidStateStoreException exception = (InvalidStateStoreException)Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.timestampedKeyValueStore())));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Cannot get state store kv-store because the queryable store type [class org.apache.kafka.streams.state.QueryableStoreTypes$TimestampedKeyValueStoreType] does not accept the actual store type [class org.apache.kafka.streams.state.internals.MeteredKeyValueStore]."));
    }

    @Test
    public void shouldFindTimestampedKeyValueStoresAsKeyValueStores() {
        this.mockThread(true);
        List tkvStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        Assertions.assertEquals((int)2, (int)tkvStores.size());
        for (ReadOnlyKeyValueStore store : tkvStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldFindWindowStores() {
        this.mockThread(true);
        List windowStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore()));
        Assertions.assertEquals((int)2, (int)windowStores.size());
        for (ReadOnlyWindowStore store : windowStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldFindTimestampedWindowStores() {
        this.mockThread(true);
        List windowStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-window-store", (QueryableStoreType)QueryableStoreTypes.timestampedWindowStore()));
        Assertions.assertEquals((int)2, (int)windowStores.size());
        for (ReadOnlyWindowStore store : windowStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(TimestampedWindowStore.class));
        }
    }

    @Test
    public void shouldNotFindWindowStoresAsTimestampedStore() {
        this.mockThread(true);
        InvalidStateStoreException exception = (InvalidStateStoreException)Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.timestampedWindowStore())));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Cannot get state store window-store because the queryable store type [class org.apache.kafka.streams.state.QueryableStoreTypes$TimestampedWindowStoreType] does not accept the actual store type [class org.apache.kafka.streams.state.internals.MeteredWindowStore]."));
    }

    @Test
    public void shouldFindTimestampedWindowStoresAsWindowStore() {
        this.mockThread(true);
        List windowStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-window-store", (QueryableStoreType)QueryableStoreTypes.windowStore()));
        Assertions.assertEquals((int)2, (int)windowStores.size());
        for (ReadOnlyWindowStore store : windowStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }

    @Test
    public void shouldFindSessionStores() {
        this.mockThread(true);
        List sessionStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"session-store", (QueryableStoreType)QueryableStoreTypes.sessionStore()));
        Assertions.assertEquals((int)2, (int)sessionStores.size());
        for (ReadOnlySessionStore store : sessionStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlySessionStore.class));
        }
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfKVStoreClosed() {
        this.mockThread(true);
        this.taskOne.getStore("kv-store").close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfTsKVStoreClosed() {
        this.mockThread(true);
        this.taskOne.getStore("timestamped-kv-store").close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-kv-store", (QueryableStoreType)QueryableStoreTypes.timestampedKeyValueStore())));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfWindowStoreClosed() {
        this.mockThread(true);
        this.taskOne.getStore("window-store").close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfTsWindowStoreClosed() {
        this.mockThread(true);
        this.taskOne.getStore("timestamped-window-store").close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"timestamped-window-store", (QueryableStoreType)QueryableStoreTypes.timestampedWindowStore())));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfSessionStoreClosed() {
        this.mockThread(true);
        this.taskOne.getStore("session-store").close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"session-store", (QueryableStoreType)QueryableStoreTypes.sessionStore())));
    }

    @Test
    public void shouldReturnEmptyListIfNoStoresFoundWithName() {
        this.mockThread(true);
        Assertions.assertEquals(Collections.emptyList(), (Object)this.provider.stores(StoreQueryParameters.fromNameAndType((String)"not-a-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    @Test
    public void shouldReturnSingleStoreForPartition() {
        this.mockThread(true);
        List kvStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(0)));
        Assertions.assertEquals((int)1, (int)kvStores.size());
        for (ReadOnlyKeyValueStore store : kvStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
        kvStores = this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(1)));
        Assertions.assertEquals((int)1, (int)kvStores.size());
        for (ReadOnlyKeyValueStore store : kvStores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnEmptyListForInvalidPartitions() {
        this.mockThread(true);
        Assertions.assertEquals(Collections.emptyList(), (Object)this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(2))));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfNotAllStoresAvailable() {
        Mockito.when((Object)this.threadMock.state()).thenReturn((Object)StreamThread.State.PARTITIONS_ASSIGNED);
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.provider.stores(StoreQueryParameters.fromNameAndType((String)"kv-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    private StreamTask createStreamsTask(StreamsConfig streamsConfig, MockClientSupplier clientSupplier, ProcessorTopology topology, TaskId taskId) {
        Metrics metrics = new Metrics();
        LogContext logContext = new LogContext("test-stream-task ");
        Set<TopicPartition> partitions = Collections.singleton(new TopicPartition("topic", taskId.partition()));
        ProcessorStateManager stateManager = new ProcessorStateManager(taskId, Task.TaskType.ACTIVE, StreamsConfigUtils.eosEnabled((StreamsConfig)streamsConfig), logContext, this.stateDirectory, (ChangelogRegister)new StoreChangelogReader((Time)new MockTime(), streamsConfig, logContext, (Admin)clientSupplier.adminClient, clientSupplier.restoreConsumer, (StateRestoreListener)new MockStateRestoreListener(), (StandbyUpdateListener)new MockStandbyUpdateListener()), topology.storeToChangelogTopic(), partitions, false);
        RecordCollectorImpl recordCollector = new RecordCollectorImpl(logContext, taskId, new StreamsProducer(streamsConfig, "threadId", (KafkaClientSupplier)clientSupplier, new TaskId(0, 0), UUID.randomUUID(), logContext, Time.SYSTEM), streamsConfig.defaultProductionExceptionHandler(), (StreamsMetricsImpl)new MockStreamsMetrics(metrics), topology);
        MockStreamsMetrics streamsMetrics = new MockStreamsMetrics(metrics);
        ProcessorContextImpl context = new ProcessorContextImpl(taskId, streamsConfig, stateManager, (StreamsMetricsImpl)streamsMetrics, null);
        return new StreamTask(taskId, partitions, topology, clientSupplier.consumer, new TopologyConfig(null, streamsConfig, new Properties()).getTaskConfig(), (StreamsMetricsImpl)streamsMetrics, this.stateDirectory, (ThreadCache)Mockito.mock(ThreadCache.class), (Time)new MockTime(), stateManager, (RecordCollector)recordCollector, (InternalProcessorContext)context, logContext, false);
    }

    private void mockThread(boolean initialized) {
        Mockito.when((Object)this.threadMock.readOnlyActiveTasks()).thenReturn(new HashSet<Task>(this.tasks.values()));
        Mockito.when((Object)this.threadMock.state()).thenReturn((Object)(initialized ? StreamThread.State.RUNNING : StreamThread.State.PARTITIONS_ASSIGNED));
    }

    private void configureClients(MockClientSupplier clientSupplier, String topic) {
        List<PartitionInfo> partitions = Arrays.asList(new PartitionInfo(topic, 0, null, null, null), new PartitionInfo(topic, 1, null, null, null));
        clientSupplier.restoreConsumer.updatePartitions(topic, partitions);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        clientSupplier.restoreConsumer.assign(Arrays.asList(tp1, tp2));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(tp1, 0L);
        offsets.put(tp2, 0L);
        clientSupplier.restoreConsumer.updateBeginningOffsets(offsets);
        clientSupplier.restoreConsumer.updateEndOffsets(offsets);
        clientSupplier.adminClient.updateBeginningOffsets(offsets);
        clientSupplier.adminClient.updateEndOffsets(offsets);
    }
}

