/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.WindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class WindowStoreBuilderTest {
    @Mock
    private WindowBytesStoreSupplier supplier;
    @Mock
    private WindowStore<Bytes, byte[]> inner;
    private WindowStoreBuilder<String, String> builder;

    public void setUpWithoutInner() {
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)"name");
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)"metricScope");
        this.builder = new WindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    public void setUp() {
        Mockito.when((Object)this.supplier.get()).thenReturn(this.inner);
        this.setUpWithoutInner();
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        this.setUp();
        WindowStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        this.setUp();
        WindowStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        this.setUp();
        WindowStore store = (WindowStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        this.setUp();
        WindowStore store = (WindowStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        this.setUp();
        WindowStore store = (WindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        this.setUp();
        WindowStore store = (WindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldDisableCachingWithRetainDuplicates() {
        this.supplier = Stores.persistentWindowStore((String)"name", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L), (boolean)true);
        StoreBuilder builder = new WindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()).withCachingEnabled();
        builder.build();
        Assertions.assertFalse((boolean)((AbstractStoreBuilder)builder).enableCaching);
    }

    @Test
    public void shouldDisableLogCompactionWithRetainDuplicates() {
        this.supplier = Stores.persistentWindowStore((String)"name", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L), (boolean)true);
        StoreBuilder builder = new WindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()).withCachingEnabled();
        MatcherAssert.assertThat(builder.logConfig().get("cleanup.policy"), (Matcher)Matchers.equalTo((Object)"delete"));
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new WindowStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new WindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        this.setUpWithoutInner();
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new WindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier's metricsScope can't be null"));
    }
}

