/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class RocksDBMetricsRecordingTriggerTest {
    private static final String STORE_NAME1 = "store-name1";
    private static final String STORE_NAME2 = "store-name2";
    private static final TaskId TASK_ID1 = new TaskId(1, 2);
    private static final TaskId TASK_ID2 = new TaskId(2, 4);
    @Mock
    private RocksDBMetricsRecorder recorder1;
    @Mock
    private RocksDBMetricsRecorder recorder2;
    private final Time time = new MockTime();
    private final RocksDBMetricsRecordingTrigger recordingTrigger = new RocksDBMetricsRecordingTrigger(this.time);

    private void setUp() {
        Mockito.when((Object)this.recorder1.storeName()).thenReturn((Object)STORE_NAME1);
        Mockito.when((Object)this.recorder1.taskId()).thenReturn((Object)TASK_ID1);
        Mockito.when((Object)this.recorder2.storeName()).thenReturn((Object)STORE_NAME2);
        Mockito.when((Object)this.recorder2.taskId()).thenReturn((Object)TASK_ID2);
    }

    @Test
    public void shouldTriggerAddedMetricsRecorders() {
        this.setUp();
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        this.recordingTrigger.addMetricsRecorder(this.recorder2);
        ((RocksDBMetricsRecorder)Mockito.doNothing().when((Object)this.recorder1)).record(this.time.milliseconds());
        ((RocksDBMetricsRecorder)Mockito.doNothing().when((Object)this.recorder2)).record(this.time.milliseconds());
        this.recordingTrigger.run();
    }

    @Test
    public void shouldThrowIfRecorderToAddHasBeenAlreadyAdded() {
        Mockito.when((Object)this.recorder1.storeName()).thenReturn((Object)STORE_NAME1);
        Mockito.when((Object)this.recorder1.taskId()).thenReturn((Object)TASK_ID1);
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        Assertions.assertThrows(IllegalStateException.class, () -> this.recordingTrigger.addMetricsRecorder(this.recorder1));
    }

    @Test
    public void shouldThrowIfRecorderToRemoveCouldNotBeFound() {
        this.setUp();
        this.recordingTrigger.addMetricsRecorder(this.recorder1);
        Assertions.assertThrows(IllegalStateException.class, () -> this.recordingTrigger.removeMetricsRecorder(this.recorder2));
    }
}

