/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.test.MockProcessor;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;

public class MockProcessorSupplier<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn, KOut, VOut> {
    private final long scheduleInterval;
    private final PunctuationType punctuationType;
    private final List<MockProcessor<KIn, VIn, KOut, VOut>> processors = new ArrayList<MockProcessor<KIn, VIn, KOut, VOut>>();

    public MockProcessorSupplier() {
        this(-1L);
    }

    public MockProcessorSupplier(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorSupplier(long scheduleInterval, PunctuationType punctuationType) {
        this.scheduleInterval = scheduleInterval;
        this.punctuationType = punctuationType;
    }

    public Processor<KIn, VIn, KOut, VOut> get() {
        MockProcessor processor = new MockProcessor(this.punctuationType, this.scheduleInterval);
        if (!StreamsTestUtils.isCheckSupplierCall()) {
            this.processors.add(processor);
        }
        return processor;
    }

    public MockProcessor<KIn, VIn, KOut, VOut> theCapturedProcessor() {
        return this.capturedProcessors(1).get(0);
    }

    public int capturedProcessorsCount() {
        return this.processors.size();
    }

    public List<MockProcessor<KIn, VIn, KOut, VOut>> capturedProcessors(int expectedNumberOfProcessors) {
        Assertions.assertEquals((int)expectedNumberOfProcessors, (int)this.processors.size());
        return this.processors;
    }
}

