/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ConsumeBenchWorker;
import org.apache.kafka.trogdor.workload.TopicsSpec;

public class ConsumeBenchSpec
extends TaskSpec {
    private final String consumerNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final int maxMessages;
    private final Map<String, String> consumerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final TopicsSpec activeTopics;

    @JsonCreator
    public ConsumeBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="consumerNode") String consumerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="maxMessages") int maxMessages, @JsonProperty(value="consumerConf") Map<String, String> consumerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="activeTopics") TopicsSpec activeTopics) {
        super(startMs, durationMs);
        this.consumerNode = consumerNode == null ? "" : consumerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.maxMessages = maxMessages;
        this.consumerConf = this.configOrEmptyMap(consumerConf);
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
        this.adminClientConf = this.configOrEmptyMap(adminClientConf);
        this.activeTopics = activeTopics == null ? TopicsSpec.EMPTY : activeTopics.immutableCopy();
    }

    @JsonProperty
    public String consumerNode() {
        return this.consumerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public int maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public Map<String, String> consumerConf() {
        return this.consumerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public TopicsSpec activeTopics() {
        return this.activeTopics;
    }

    @Override
    public TaskController newController(String id) {
        return new TaskController(){

            @Override
            public Set<String> targetNodes(Topology topology) {
                return Collections.singleton(ConsumeBenchSpec.this.consumerNode);
            }
        };
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ConsumeBenchWorker(id, this);
    }
}

