/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.server.util.PartitionFilter;
import org.apache.kafka.server.util.TopicFilter;
import org.apache.kafka.server.util.TopicPartitionFilter;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsUtils;

public class GetOffsetShell {
    private static final Pattern TOPIC_PARTITION_PATTERN = Pattern.compile("([^:,]*)(?::(?:([0-9]*)|(?:([0-9]*)-([0-9]*))))?");

    public static void main(String ... args) {
        Exit.exit((int)GetOffsetShell.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            GetOffsetShell.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println("Error occurred: " + e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println("Error occurred: " + e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    static void execute(String ... args) throws IOException, ExecutionException, InterruptedException, TerseException {
        GetOffsetShell getOffsetShell = new GetOffsetShell();
        GetOffsetShellOptions options = new GetOffsetShellOptions(args);
        Map<TopicPartition, Long> partitionOffsets = getOffsetShell.fetchOffsets(options);
        for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
            TopicPartition topic = entry.getKey();
            System.out.println(String.join((CharSequence)":", topic.topic(), String.valueOf(topic.partition()), entry.getValue().toString()));
        }
    }

    public Map<TopicPartition, Long> fetchOffsets(GetOffsetShellOptions options) throws IOException, ExecutionException, InterruptedException, TerseException {
        String clientId = "GetOffsetShell";
        String brokerList = options.effectiveBrokerListOpt();
        if (options.hasTopicPartitionsOpt() && (options.hasTopicOpt() || options.hasPartitionsOpt())) {
            throw new TerseException("--topic-partitions cannot be used with --topic or --partitions");
        }
        boolean excludeInternalTopics = options.hasExcludeInternalTopicsOpt();
        OffsetSpec offsetSpec = this.parseOffsetSpec(options.timeOpt());
        TopicPartitionFilter topicPartitionFilter = options.hasTopicPartitionsOpt() ? this.createTopicPartitionFilterWithPatternList(options.topicPartitionsOpt()) : this.createTopicPartitionFilterWithTopicAndPartitionPattern(options.topicOpt(), options.partitionsOpt());
        Properties config = options.hasCommandConfigOpt() ? Utils.loadProps((String)options.commandConfigOpt()) : new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        try (Admin adminClient = Admin.create((Properties)config);){
            List<TopicPartition> partitionInfos = this.listPartitionInfos(adminClient, topicPartitionFilter, excludeInternalTopics);
            if (partitionInfos.isEmpty()) {
                throw new TerseException("Could not match any topic-partitions with the specified filters");
            }
            Map<TopicPartition, OffsetSpec> timestampsToSearch = partitionInfos.stream().collect(Collectors.toMap(tp -> tp, tp -> offsetSpec));
            ListOffsetsResult listOffsetsResult = adminClient.listOffsets(timestampsToSearch);
            TreeMap<TopicPartition, Long> partitionOffsets = new TreeMap<TopicPartition, Long>(Comparator.comparing(TopicPartition::toString));
            for (TopicPartition partition : partitionInfos) {
                ListOffsetsResult.ListOffsetsResultInfo partitionInfo;
                try {
                    partitionInfo = (ListOffsetsResult.ListOffsetsResultInfo)listOffsetsResult.partitionResult(partition).get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof KafkaException) {
                        System.err.println("Skip getting offsets for topic-partition " + partition.toString() + " due to error: " + e.getMessage());
                        continue;
                    }
                    throw e;
                }
                if (partitionInfo.offset() == -1L) continue;
                partitionOffsets.put(partition, partitionInfo.offset());
            }
            TreeMap<TopicPartition, Long> treeMap = partitionOffsets;
            return treeMap;
        }
    }

    private OffsetSpec parseOffsetSpec(String listOffsetsTimestamp) throws TerseException {
        long timestamp;
        switch (listOffsetsTimestamp) {
            case "earliest": {
                return OffsetSpec.earliest();
            }
            case "latest": {
                return OffsetSpec.latest();
            }
            case "max-timestamp": {
                return OffsetSpec.maxTimestamp();
            }
        }
        try {
            timestamp = Long.parseLong(listOffsetsTimestamp);
        }
        catch (NumberFormatException e) {
            throw new TerseException("Malformed time argument " + listOffsetsTimestamp + ". Please use -1 or latest / -2 or earliest / -3 or max-timestamp, or a specified long format timestamp");
        }
        if (timestamp == -2L) {
            return OffsetSpec.earliest();
        }
        if (timestamp == -1L) {
            return OffsetSpec.latest();
        }
        if (timestamp == -3L) {
            return OffsetSpec.maxTimestamp();
        }
        return OffsetSpec.forTimestamp((long)timestamp);
    }

    public TopicPartitionFilter createTopicPartitionFilterWithPatternList(String topicPartitions) {
        List<String> ruleSpecs = Arrays.asList(topicPartitions.split(","));
        List rules = ruleSpecs.stream().map(ruleSpec -> {
            try {
                return this.parseRuleSpec((String)ruleSpec);
            }
            catch (TerseException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return new TopicPartitionFilter.CompositeTopicPartitionFilter(rules);
    }

    public TopicPartitionFilter createTopicPartitionFilterWithTopicAndPartitionPattern(String topicOpt, String partitionIds) throws TerseException {
        return new TopicPartitionFilter.TopicFilterAndPartitionFilter(new TopicFilter.IncludeList(topicOpt != null ? topicOpt : ".*"), (PartitionFilter)new PartitionFilter.PartitionsSetFilter(this.createPartitionSet(partitionIds)));
    }

    private Set<Integer> createPartitionSet(String partitionsString) throws TerseException {
        Set<Integer> partitions;
        if (partitionsString == null || partitionsString.isEmpty()) {
            partitions = Collections.emptySet();
        } else {
            try {
                partitions = Arrays.stream(partitionsString.split(",")).map(Integer::parseInt).collect(Collectors.toSet());
            }
            catch (NumberFormatException e) {
                throw new TerseException("--partitions expects a comma separated list of numeric partition ids, but received: " + partitionsString);
            }
        }
        return partitions;
    }

    private List<TopicPartition> listPartitionInfos(Admin client, TopicPartitionFilter topicPartitionFilter, boolean excludeInternalTopics) throws ExecutionException, InterruptedException {
        ListTopicsOptions listTopicsOptions = new ListTopicsOptions().listInternal(!excludeInternalTopics);
        Set topics = (Set)client.listTopics(listTopicsOptions).names().get();
        Set filteredTopics = topics.stream().filter(arg_0 -> ((TopicPartitionFilter)topicPartitionFilter).isTopicAllowed(arg_0)).collect(Collectors.toSet());
        return ((Map)client.describeTopics(filteredTopics).allTopicNames().get()).entrySet().stream().flatMap(topic -> ((TopicDescription)topic.getValue()).partitions().stream().map(tp -> new TopicPartition((String)topic.getKey(), tp.partition())).filter(arg_0 -> ((TopicPartitionFilter)topicPartitionFilter).isTopicPartitionAllowed(arg_0))).collect(Collectors.toList());
    }

    private TopicPartitionFilter parseRuleSpec(String ruleSpec) throws TerseException, RuntimeException {
        PartitionFilter.UniquePartitionFilter partitionFilter;
        TopicFilter.IncludeList topicFilter;
        Matcher matcher = TOPIC_PARTITION_PATTERN.matcher(ruleSpec);
        if (!matcher.matches()) {
            throw new TerseException("Invalid rule specification: " + ruleSpec);
        }
        IntFunction<String> group = g -> matcher.group(g) != null && !matcher.group(g).isEmpty() ? matcher.group(g) : null;
        TopicFilter.IncludeList includeList = topicFilter = group.apply(1) != null ? new TopicFilter.IncludeList(group.apply(1)) : new TopicFilter.IncludeList(".*");
        if (group.apply(2) != null) {
            partitionFilter = new PartitionFilter.UniquePartitionFilter(Integer.parseInt(group.apply(2)));
        } else {
            int lowerRange = group.apply(3) != null ? Integer.parseInt(group.apply(3)) : 0;
            int upperRange = group.apply(4) != null ? Integer.parseInt(group.apply(4)) : Integer.MAX_VALUE;
            partitionFilter = new PartitionFilter.PartitionRangeFilter(lowerRange, upperRange);
        }
        return new TopicPartitionFilter.TopicFilterAndPartitionFilter(topicFilter, (PartitionFilter)partitionFilter);
    }

    private static class GetOffsetShellOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> brokerListOpt;
        private final OptionSpec<String> bootstrapServerOpt;
        private final OptionSpec<String> topicPartitionsOpt;
        private final OptionSpec<String> topicOpt;
        private final OptionSpec<String> partitionsOpt;
        private final OptionSpec<String> timeOpt;
        private final OptionSpec<String> commandConfigOpt;
        private final OptionSpec<String> effectiveBrokerListOpt;
        private final OptionSpecBuilder excludeInternalTopicsOpt;

        public GetOffsetShellOptions(String[] args) throws TerseException {
            super(args);
            this.brokerListOpt = this.parser.accepts("broker-list", "DEPRECATED, use --bootstrap-server instead; ignored if --bootstrap-server is specified. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").requiredUnless("broker-list", new String[0]).withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
            this.topicPartitionsOpt = this.parser.accepts("topic-partitions", "Comma separated list of topic-partition patterns to get the offsets for, with the format of '" + TOPIC_PARTITION_PATTERN + "'. The first group is an optional regex for the topic name, if omitted, it matches any topic name. The section after ':' describes a 'partition' pattern, which can be: a number, a range in the format of 'NUMBER-NUMBER' (lower inclusive, upper exclusive), an inclusive lower bound in the format of 'NUMBER-', an exclusive upper bound in the format of '-NUMBER' or may be omitted to accept all partitions.").withRequiredArg().describedAs("topic1:1,topic2:0-3,topic3,topic4:5-,topic5:-3").ofType(String.class);
            this.topicOpt = this.parser.accepts("topic", "The topic to get the offsets for. It also accepts a regular expression. If not present, all authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("topic").ofType(String.class);
            this.partitionsOpt = this.parser.accepts("partitions", "Comma separated list of partition ids to get the offsets for. If not present, all partitions of the authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("partition ids").ofType(String.class);
            this.timeOpt = this.parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently committed record timestamp is given.]").withRequiredArg().describedAs("<timestamp> / -1 or latest / -2 or earliest / -3 or max-timestamp").ofType(String.class).defaultsTo((Object)"latest", (Object[])new String[0]);
            this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("config file").ofType(String.class);
            this.excludeInternalTopicsOpt = this.parser.accepts("exclude-internal-topics", "By default, internal topics are included. If specified, internal topics are excluded.");
            if (args.length == 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"An interactive shell for getting topic-partition offsets.");
            }
            try {
                this.options = this.parser.parse(args);
            }
            catch (OptionException e) {
                throw new TerseException(e.getMessage());
            }
            this.effectiveBrokerListOpt = this.options.has(this.bootstrapServerOpt) ? this.bootstrapServerOpt : this.brokerListOpt;
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.effectiveBrokerListOpt});
            String brokerList = (String)this.options.valueOf(this.effectiveBrokerListOpt);
            try {
                ToolsUtils.validateBootstrapServer(brokerList);
            }
            catch (IllegalArgumentException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
            }
        }

        public boolean hasTopicPartitionsOpt() {
            return this.options.has(this.topicPartitionsOpt);
        }

        public String topicPartitionsOpt() {
            return (String)this.options.valueOf(this.topicPartitionsOpt);
        }

        public boolean hasTopicOpt() {
            return this.options.has(this.topicOpt);
        }

        public String topicOpt() {
            return (String)this.options.valueOf(this.topicOpt);
        }

        public boolean hasPartitionsOpt() {
            return this.options.has(this.partitionsOpt);
        }

        public String partitionsOpt() {
            return (String)this.options.valueOf(this.partitionsOpt);
        }

        public String timeOpt() {
            return (String)this.options.valueOf(this.timeOpt);
        }

        public boolean hasCommandConfigOpt() {
            return this.options.has(this.commandConfigOpt);
        }

        public String commandConfigOpt() {
            return (String)this.options.valueOf(this.commandConfigOpt);
        }

        public String effectiveBrokerListOpt() {
            return (String)this.options.valueOf(this.effectiveBrokerListOpt);
        }

        public boolean hasExcludeInternalTopicsOpt() {
            return this.options.has((OptionSpec)this.excludeInternalTopicsOpt);
        }
    }
}

