/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.admin.TestAdminUtils;
import kafka.common.InvalidConfigException;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaId$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u00131A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!)A\u0005\u0001C\u0001K\u0005A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]\"mS\u0016tGo]#oi&$\u0018\u0010V=qKR\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0003V]&$\bFA\u0012.!\tq\u0003'D\u00010\u0015\tYa\"\u0003\u00022_\t!A+Z:u\u0011\u0015\u0019\u0004\u0001\"\u0001&\u0003\u001d\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'\u000fV8qS\u000e\u001cXI\u001c;jif$\u0016\u0010]3)\u0005Ij\u0003\"\u0002\u001c\u0001\t\u0003)\u0013\u0001K:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u0005J|7.\u001a:t\u000b:$\u0018\u000e^=UsB,\u0007FA\u001b.\u0011\u0015I\u0004\u0001\"\u0001;\u0003E!Xm\u001d;Be\u001e,X.\u001a8u!\u0006\u00148/\u001a\u000b\u0003MmBQ\u0001\u0010\u001dA\u0002u\n!\"\u001a8uSRLH+\u001f9f!\tq\u0014I\u0004\u0002(\u007f%\u0011\u0001\tK\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002AQ!)Q\t\u0001C\u0001K\u0005\u00113\u000f[8vY\u00124\u0015-\u001b7JMVs'/Z2pO:L7/\u001a3F]RLG/\u001f+za\u0016DC\u0001R\u0017H\u0011\u0006AQ\r\u001f9fGR,GmI\u0001J!\tQ%K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011aJB\u0001\u0007yI|w\u000e\u001e \n\u0003%J!!\u0015\u0015\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA))\u0011\u00151\u0006\u0001\"\u0001&\u0003U\u0019\bn\\;mI\u0006#Gm\u00117jK:$8i\u001c8gS\u001eD#!V\u0017\t\u000be\u0003A\u0011A\u0013\u0002)MDw.\u001e7e\u0003\u0012$Gk\u001c9jG\u000e{gNZ5hQ\tAV\u0006C\u0003]\u0001\u0011\u0005Q%A\u000btQ>,H\u000eZ!eI\n\u0013xn[3s\u0007>tg-[4)\u0005mk\u0003\"B0\u0001\t\u0003)\u0013!I:i_VdGmU;qa>\u0014HoQ8n[\u0006\u001cV\r]1sCR,GMV1mk\u0016\u001c\bF\u00010.\u0011\u0015\u0011\u0007\u0001\"\u0001&\u0003A\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\rZ#oi&$\u0018PT1nK\"\"\u0011-L$I\u0011\u0015)\u0007\u0001\"\u0001&\u00031\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\rZ\"p]\u001aLw\r\u000b\u0003e[\u001dC\u0005\"\u00025\u0001\t\u0003)\u0013aM:i_VdGMT8u+B$\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00134NC24wN]7fI\n\u0013\u0018mY6fi\u000e{gNZ5hQ\u00119Wf\u0012%\t\u000b-\u0004A\u0011A\u0013\u0002oMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001atuN\\#ySN$\u0018N\\4D_:4\u0017nZ%t\t\u0016dW\r^3eQ\u0011QWfR7$\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0003\u0002\r\r|W.\\8o\u0013\t\u0019\bO\u0001\fJ]Z\fG.\u001b3D_:4\u0017nZ#yG\u0016\u0004H/[8o\u0011\u0015)\b\u0001\"\u0001&\u0003a\u0019\bn\\;mI\u0012+G.\u001a;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0015\u0003i6BQ\u0001\u001f\u0001\u0005\u0002\u0015\nA\u0003^3tiN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c\bFA<.\u0011\u0015Y\b\u0001\"\u0001&\u0003U!Xm\u001d;Rk>$\u0018mQ8oM&<WI\u001c;jifD#A_\u0017\t\u000by\u0004A\u0011A\u0013\u0002/Q,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1PaR\u001c\bFA?.\u0011\u0019\t\u0019\u0001\u0001C\u0001K\u0005IB/Z:u#V|G/\u0019#fg\u000e\u0014\u0018NY3F]RLG/[3tQ\r\t\t!\f")
public class ConfigCommandTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigCommandTest$CredentialChange$4$ kafka$admin$ConfigCommandTest$$CredentialChange$2$lzycompute(Map x$1, VolatileObjectRef x$2) {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (x$2.elem != null) return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
            x$2.elem = new ConfigCommandTest$CredentialChange$4$(this, x$1, x$2);
            return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
        }
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "a=b"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=InvalidConfigException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return properties;
            }

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void testScramCredentials() {
        VolatileObjectRef CredentialChange$module = new VolatileObjectRef(null);
        Map credentials = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends TestAdminUtils
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            public final /* synthetic */ ConfigCommandTest $outer;
            public final Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Properties apply() {
                        return new Properties();
                    }
                });
            }

            public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1)new Serializable(this, configChange){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Kafka_admin_ConfigCommandTest$CredentialChange$3 $outer;
                    private final Properties configChange$1;

                    public final Object apply(String mechanism) {
                        String value = this.configChange$1.getProperty(mechanism);
                        Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                        ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                        Assert.assertEquals((long)this.$outer.iterations(), (long)scramCredential.iterations());
                        return this.configChange$1 == null ? BoxedUnit.UNIT : this.$outer.credentials$1.put((Object)this.$outer.user(), (Object)this.configChange$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.configChange$1 = configChange$1;
                    }
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.kafka$admin$ConfigCommandTest$CredentialChange$$$outer(), user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 0: {
                        object = this.user();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)x$1;
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$CredentialChange$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                Product.class.$init$((Product)this);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminUtilities)this.kafka$admin$ConfigCommandTest$$CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminUtilities)this.kafka$admin$ConfigCommandTest$$CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminUtilities)this.kafka$admin$ConfigCommandTest$$CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminUtilities)this.kafka$admin$ConfigCommandTest$$CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, clientId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String clientId$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)this.clientId$1), this.clientId$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.clientId$1 = clientId$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)QuotaId$.MODULE$.desanitize(sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, principal, sanitizedPrincipal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String principal$1;
            private final String sanitizedPrincipal$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.sanitizedPrincipal$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String[] describeOpts$1;
            private final String clientId$1;
            private final String principal$1;
            private final String sanitizedPrincipal$1;
            private final String userClient$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.userClient$1, (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), new StringBuilder().append((Object)this.sanitizedPrincipal$1).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)this.clientId$1).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])this.describeOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
                this.clientId$1 = clientId$1;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
                this.userClient$1 = userClient$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients").toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])describeOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.kafka$admin$ConfigCommandTest$$clientIdOpts$1(clientId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        try {
            this.checkEntity$2("clients", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
            throw this.fail("Did not fail with invalid client-id", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        }
        catch (InvalidConfigException invalidConfigException) {
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
            this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
            return;
        }
    }

    @Test
    public void testQuotaDescribeEntities() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/<default>").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-4").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        this.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-2").toString()})), zkUtils);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    public final ConfigCommandTest$CredentialChange$4$ kafka$admin$ConfigCommandTest$$CredentialChange$2(Map credentials$1, VolatileObjectRef CredentialChange$module$1) {
        return CredentialChange$module$1.elem == null ? this.kafka$admin$ConfigCommandTest$$CredentialChange$2$lzycompute(credentials$1, CredentialChange$module$1) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.elem);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        Option option;
        block4: {
            String[] stringArray;
            String[] optArray;
            block3: {
                block2: {
                    optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
                    option = entityName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    stringArray = (String[])((Object[])new String[]{"--entity-name", name});
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            String[] nameArray = stringArray;
            return new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optArray).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nameArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        throw new MatchError((Object)option);
    }

    public final void kafka$admin$ConfigCommandTest$$checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final String[] kafka$admin$ConfigCommandTest$$clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, ZkUtils zkUtils$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])opts).$colon$plus((Object)"--describe", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        expectedFetches.foreach((Function1)new Serializable(this, zkUtils$1){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final IExpectationSetters<Seq<String>> apply(Tuple2<String, Seq<String>> x0$1) {
                Tuple2<String, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.zkUtils$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
                    return iExpectationSetters;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{zkUtils$1});
        Seq entities = entity.getAllEntities(zkUtils$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigCommand.ConfigEntity e) {
                return e.fullSanitizedName();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkUtils$1});
    }

    public ConfigCommandTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
    }
}

