/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u0001>l\u0013\t9BC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\t1\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018nY,ji\"\fE\u000e\\!mSZ,'+\u001a9mS\u000e\f7\u000fF\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;)\u0005u9\u0003C\u0001\u0015+\u001b\u0005I#BA\u0006\u000f\u0013\tY\u0013F\u0001\u0003UKN$\b\"B\u0017\u0001\t\u0003y\u0012A\u000b;fgR\u0014Vm];nK\u0012+G.\u001a;f)>\u0004\u0018nY,ji\"\u0014VmY8wKJ,GMR8mY><XM\u001d\u0015\u0003Y\u001dBQ\u0001\r\u0001\u0005\u0002}\t\u0011\u0006^3tiJ+7/^7f\t\u0016dW\r^3U_BL7m\u00148D_:$(o\u001c7mKJ4\u0015-\u001b7pm\u0016\u0014\bFA\u0018(\u0011\u0015\u0019\u0004\u0001\"\u0001 \u0003)\"Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;EkJLgn\u001a#fY\u0016$X\rV8qS\u000eD#AM\u0014\t\u000bY\u0002A\u0011A\u0010\u0002CQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e$UO]5oO\u0006#G\rU1si&$\u0018n\u001c8)\u0005U:\u0003\"B\u001d\u0001\t\u0003y\u0012!\t;fgR\fE\r\u001a)beRLG/[8o\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007F\u0001\u001d(\u0011\u0015a\u0004\u0001\"\u0001 \u0003y!Xm\u001d;SK\u000e\u0014X-\u0019;f)>\u0004\u0018nY!gi\u0016\u0014H)\u001a7fi&|g\u000e\u000b\u0002<O!)q\b\u0001C\u0001?\u0005QB/Z:u\t\u0016dW\r^3O_:,\u00050[:uS:<Gk\u001c9jG\"\u0012ah\n\u0005\u0006\u0005\u0002!\taH\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[\"mK\u0006tWM\u001d\u0015\u0003\u0003\u001eBQ!\u0012\u0001\u0005\u0002}\tQ\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018nY!me\u0016\fG-_'be.,G-Q:EK2,G/\u001a3)\u0005\u0011;\u0003\"\u0002%\u0001\t\u0013I\u0015!G2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$2A\u0013/f!\rY5K\u0016\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001*#\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0007M+\u0017O\u0003\u0002SEA\u0011qKW\u0007\u00021*\u0011\u0011\fB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mC&aC&bM.\f7+\u001a:wKJDQ!X$A\u0002y\u000bQ\u0001^8qS\u000e\u0004\"a\u00182\u000f\u0005\u0005\u0002\u0017BA1#\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u0014\u0003b\u00024H!\u0003\u0005\raZ\u0001\u0013I\u0016dW\r^3U_BL7-\u00128bE2,G\r\u0005\u0002\"Q&\u0011\u0011N\t\u0002\b\u0005>|G.Z1o\u0011\u0015A\u0005\u0001\"\u0003l)\rQE.\u001c\u0005\u0006;*\u0004\rA\u0018\u0005\u0006]*\u0004\ra\\\u0001\u000eEJ|7.\u001a:D_:4\u0017nZ:\u0011\u0007-\u001b\u0006\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006!Q\u000f^5m\u0015\u0005)\u0018\u0001\u00026bm\u0006L!a\u001e:\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003z\u0001\u0011%!0A\u0005xe&$X\rR;qgR910!\u0002\u0002\n\u00055\u0001cA&TyB!\u0011%`@\u0000\u0013\tq(E\u0001\u0004UkBdWM\r\t\u0004C\u0005\u0005\u0011bAA\u0002E\t\u0019\u0011J\u001c;\t\r\u0005\u001d\u0001\u00101\u0001\u0000\u0003\u001dqW/\\&fsNDa!a\u0003y\u0001\u0004y\u0018a\u00028v[\u0012+\bo\u001d\u0005\b\u0003\u001fA\b\u0019AA\t\u0003\rawn\u001a\t\u0005\u0003'\t9\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0002\u0003\n\t\u0005e\u0011Q\u0003\u0002\u0004\u0019><\u0007BBA\u000f\u0001\u0011\u0005q$\u0001\fuKN$H)[:bE2,G)\u001a7fi\u0016$v\u000e]5dQ\r\tYb\n\u0005\n\u0003G\u0001\u0011\u0013!C\u0005\u0003K\t1e\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002()\u001aq-!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DeleteTopicTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DeleteTopicTest deleteTopicTest = this;
        synchronized (deleteTopicTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers, follower){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$1;
            private final Seq servers$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((IterableLike)this.servers$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer x$2) {
                        return x$2.getLogManager().getLog(this.$outer.topicPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$1 = topicPartition$1;
                this.servers$1 = servers$1;
                this.follower$1 = follower$1;
            }
        }, "Replicas 0,1 have not deleted log.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, "Admin path /admin/delete_topic/test path deleted even when a follower replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, controllerId, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;
            private final Option leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$2.get()) && s.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, "Admin path /admin/delete_topic/test path deleted even when a replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12());
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        Seq allServers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq servers = (Seq)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(KafkaServer x$5) {
                        return x$5.getLogManager().getLog(this.$outer.topicPartition$2).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.servers$2 = servers$2;
            }
        }, "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$3.get());
            }
            {
                this.leaderIdOpt$3 = leaderIdOpt$3;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        Seq oldAssignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topicPartition)), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3());
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicPartition topicPartition$2;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$6) {
                        return x$6.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), new TopicAndPartition(this.topicPartition$2), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(this.topicPartition$2)), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.newReplicas$1 = newReplicas$1;
            }
        }, "Partition reassignment shouldn't complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)new TopicAndPartition(topicPartition)));
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)servers);
        allServers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$7) {
                x$7.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$4;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$4.get());
            }
            {
                this.leaderIdOpt$4 = leaderIdOpt$4;
            }
        })).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        follower.shutdown();
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, 2, "0:1:2,0:1:2", false, AdminUtils$.MODULE$.addPartitions$default$6());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, servers, newPartition){
            public static final long serialVersionUID = 0L;
            private final Seq servers$3;
            public final TopicPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$1 $outer;

                    public final boolean apply(KafkaServer x$8) {
                        return x$8.getLogManager().getLog(this.$outer.newPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$3 = servers$3;
                this.newPartition$1 = newPartition$1;
            }
        }, "Replica logs not for new partition [test,1] not deleted after delete topic is complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$9) {
                x$9.shutdown();
            }
        });
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        String topic = "test";
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, 2, "0:1:2,0:1:2", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition newPartition$2;

            public final boolean apply(KafkaServer x$10) {
                return x$10.getLogManager().getLog(this.newPartition$2).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        }));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$11) {
                x$11.shutdown();
            }
        });
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"New leader should be elected after re-creating topic test", (boolean)leaderIdOpt.isDefined());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$3;
            private final Seq servers$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(KafkaServer x$12) {
                        return x$12.getLogManager().getLog(this.$outer.topicPartition$3).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.servers$4 = servers$4;
            }
        }, "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$13) {
                x$13.shutdown();
            }
        });
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test2", 1, servers);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
                public static final long serialVersionUID = 0L;
                public final TopicPartition topicPartition$4;
                private final Seq servers$5;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.servers$5.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                        public final boolean apply(KafkaServer x$14) {
                            return x$14.getLogManager().getLog(this.$outer.topicPartition$4).isDefined();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.topicPartition$4 = topicPartition$4;
                    this.servers$5 = servers$5;
                }
            }, "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
            Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$15) {
                    x$15.shutdown();
                }
            });
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.delete.delay.ms", "1000");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, brokerConfigs);
        KafkaServer server = (KafkaServer)servers.head();
        Log log = (Log)server.logManager().getLog(topicPartition).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$1 = server.logManager().cleaner();
        TopicPartition x$21 = new TopicPartition(topicName, 0);
        long x$22 = 0L;
        long x$23 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$21, x$22, x$23);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test", 1, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$16) {
                x$16.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2());
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, servers);
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$17) {
                    x$17.shutdown();
                }
            });
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12());
        brokerConfigs.foreach((Function1)new Serializable(this, deleteTopicEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean deleteTopicEnabled$1;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteTopicEnabled$1)).toString());
            }
            {
                this.deleteTopicEnabled$1 = deleteTopicEnabled$1;
            }
        });
        return this.createTestTopicAndCluster(topic, brokerConfigs);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs) {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$5;
            private final Seq servers$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$6.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer x$18) {
                        return x$18.getLogManager().getLog(this.$outer.topicPartition$5).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPartition$5 = topicPartition$5;
                this.servers$6 = servers$6;
            }
        }, "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = new IntRef(0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, counter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final IntRef counter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.counter$1.elem;
                        this.$outer.log$1.append(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)this.$outer.counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), true);
                        ++this.$outer.counter$1.elem;
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.counter$1 = counter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic, false);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)servers.forall((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$6;

            public final boolean apply(KafkaServer x$19) {
                return x$19.getLogManager().getLog(this.topicPartition$6).isDefined();
            }
            {
                this.topicPartition$6 = topicPartition$6;
            }
        }));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$20) {
                x$20.shutdown();
            }
        });
    }

    public DeleteTopicTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
    }
}

