/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.server.ConfigType$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u000f\t\u0001Bk\u001c9jG\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001B\u0005\r\u001f!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\u0012!\n\t\u0003?\u0001AQa\n\u0001\u0005\u0002!\nq\u0006^3ti\u000e{gNZ5h!J,7/\u001a:wCRLwN\\!de>\u001c8\u000fU1si&$\u0018n\u001c8BYR,'/\u0019;j_:$\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000f\u000b\u0002'aA\u0011\u0011gM\u0007\u0002e)\u00111BD\u0005\u0003iI\u0012A\u0001V3ti\")a\u0007\u0001C\u0001Q\u0005\tB/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0005U\u0002\u0004\"B\u001d\u0001\t\u0003A\u0013A\u0005;fgR$U\r\\3uK&3W\t_5tiND#\u0001\u000f\u0019\t\u000bq\u0002A\u0011\u0001\u0015\u0002#Q,7\u000f^!mi\u0016\u0014\u0018JZ#ySN$8\u000f\u000b\u0002<a!)q\b\u0001C\u0001Q\u0005)B/Z:u\u0007J,\u0017\r^3JM:{G/\u0012=jgR\u001c\bF\u0001 1\u0011\u0015\u0011\u0005\u0001\"\u0001)\u0003\u0005\"Xm\u001d;De\u0016\fG/Z!mi\u0016\u0014Hk\u001c9jG^KG\u000f\u001b*bG.\fu/\u0019:fQ\t\t\u0005\u0007")
public class TopicCommandTest
extends JUnitSuite
implements ZooKeeperTestHarness,
RackAwareTest {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicCommandTest topicCommandTest = this;
        synchronized (topicCommandTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        String topic = "test";
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder().append((Object)cleanupKey).append((Object)"=").append((Object)cleanupVal).toString(), "--topic", topic}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOpts);
        Properties props = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Properties after creation don't contain ").append((Object)cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = ZkUtils$.MODULE$.ConfigChangesPath();
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", topic}));
        TopicCommand$.MODULE$.alterTopic(this.zkUtils(), alterOpts);
        Properties newProps = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Updated properties do not contain ").append((Object)cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        String normalTopic = "test";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", normalTopic}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", normalTopic}));
        String deletePath = ZkUtils$.MODULE$.getDeleteTopicPath(normalTopic);
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkUtils().zkClient().exists(deletePath));
        TopicCommand$.MODULE$.deleteTopic(this.zkUtils(), deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkUtils().zkClient().exists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", Topic$.MODULE$.GroupMetadataTopicName()}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", Topic$.MODULE$.GroupMetadataTopicName()}));
        String deleteOffsetTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(Topic$.MODULE$.GroupMetadataTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkUtils().zkClient().exists(deleteOffsetTopicPath));
        this.intercept((Function0)new Serializable(this, deleteOffsetTopicOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOffsetTopicOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.deleteTopic(this.$outer.zkUtils(), this.deleteOffsetTopicOpts$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.deleteOffsetTopicOpts$1 = deleteOffsetTopicOpts$1;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkUtils().zkClient().exists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test"}));
        this.intercept((Function0)new Serializable(this, deleteOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.deleteTopic(this.$outer.zkUtils(), this.deleteOpts$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.deleteOpts$1 = deleteOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--if-exists"}));
        TopicCommand$.MODULE$.deleteTopic(this.zkUtils(), deleteExistsOpts);
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--partitions", "1"}));
        this.intercept((Function0)new Serializable(this, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.alterTopic(this.$outer.zkUtils(), this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--partitions", "1", "--if-exists"}));
        TopicCommand$.MODULE$.alterTopic(this.zkUtils(), alterExistsOpts);
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        String topic = "test";
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", topic}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOpts);
        this.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.createTopic(this.$outer.zkUtils(), this.createOpts$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.createOpts$1 = createOpts$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", topic, "--if-not-exists"}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createNotExistsOpts);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkUtils());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", "foo"}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOpts);
        scala.collection.mutable.Map assignment = (scala.collection.mutable.Map)this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", "foo"}));
        TopicCommand$.MODULE$.alterTopic(this.zkUtils(), alterOpts);
        assignment = (scala.collection.mutable.Map)this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    public TopicCommandTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        RackAwareTest$class.$init$(this);
    }
}

